#include "server.h"

int sockReadReady( int sock )
{
	struct timeval tv;

	tv.tv_sec  = 0;
	tv.tv_usec = 0;

	FD_ZERO(&tempFds);
	FD_SET(sock, &tempFds);

	select(sock+1, &tempFds, NULL, NULL, &tv);

	if (FD_ISSET(sock, &tempFds))
		return 1;

	return 0;
}

void sockSend( int sock, char *text, ... )
{
	unsigned char	buffer[4098],
			tmpbuf[4098];
	va_list		va;
	int		i, j;

	va_start(va, text);
	vsnprintf(buffer, 4098, text, va);
	va_end(va);

	i = strlen(buffer) / 200;
	j = strlen(buffer) - (i * 200);

	if (i == 0)
		i = 201;

	sprintf(tmpbuf, "%c%c%s", i, j, buffer);
	send(sock, tmpbuf, strlen(tmpbuf), 0);
}

int sockRead( int sock, char *text )
{
	int		r, r2, num;
	unsigned char	num1, num2;

	memset(text, 0, sizeof(text));

	r	= read(sock, &num1, 1);
	r2	= read(sock, &num2, 1);
	if (r == 0 || r2 == 0)
		return(0);

	if (num1 == 201)
		num = num2;
	else
		num = (num1 * 200) + num2;

	r = read(sock, text, num);
	
	return(num);
}

void sockClose( int i )
{
	FD_CLR(cli[i].sock, &usedFds);
	close(cli[i].sock);

	cli[i].sock	= -1;
	memset(cli[i].from, 0, 20);

#ifdef	KEEP_WATCH
	someoneConnected -= 1;
#endif
}

int sockInit( void )
{
	int	i, sock;
	struct	sockaddr_in	socket_info;

        for (i = 0; i < SERVER_CLIENTS; i++)
        {
                cli[i].sock = -1;
                memset(cli[i].from, 0, 99);
        }

        FD_ZERO(&nullFds);
        FD_ZERO(&usedFds);

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		Error("Cannot open bind socket.");

	socket_info.sin_family		= AF_INET;
	socket_info.sin_addr.s_addr	= INADDR_ANY;
	socket_info.sin_port		= htons(SERVER_PORT);

	if (bind(sock, (struct sockaddr *) &socket_info, sizeof(socket_info)) < 0)
		Error("Cannot bind socket.");

	if (listen(sock, 3) < 0)
		Error("Cannot listen to socket.");

	return(sock);
}

int sockConnect( void )
{
	struct 	sockaddr_in	socket;
	int			sock,
				i,
				socket_size = sizeof(socket);

	if ((sock = accept(listenSock, (struct sockaddr *)&socket, &socket_size)) > -1)
	{
		for (i = 0; i < SERVER_CLIENTS; i++)
			if (cli[i].sock == -1)
			{
				cli[i].sock = sock;
				FD_SET(sock, &usedFds);

				if (sock > currentSock)
					currentSock = sock;

				sprintf(cli[i].from, "%i.%i.%i.%i",
					((unsigned char *)&socket.sin_addr.s_addr)[0],
					((unsigned char *)&socket.sin_addr.s_addr)[1],
					((unsigned char *)&socket.sin_addr.s_addr)[2],
					((unsigned char *)&socket.sin_addr.s_addr)[3]);

				ret.sock	= i;

#ifdef	KEEP_WATCH
				someoneConnected += 1;
#endif
				return SERVER_CONNECTED;
			}

		close(sock);
		return SERVER_NOCHANGE;
	} else
		addLog("Accept Failed: Error #%i", errno);

	return SERVER_NOCHANGE;
}

void sockProcess( void )
{
	int		i, r;
	struct timeval	tv;

	tv.tv_sec  = 1;
	tv.tv_usec = 0;

	for(;;) {
		midcheckServer();

		memcpy(&readFds, &usedFds, sizeof(&usedFds));
		select(currentSock+1, &readFds, &nullFds, &nullFds, &tv);

		if (FD_ISSET(listenSock, &readFds))
		{
			if (sockConnect() == SERVER_CONNECTED)
			{
				ret.id = SERVER_CONNECTED;
				return;
			}
		}

		for(i = 0; i < SERVER_CLIENTS; i++)
			if ((cli[i].sock != -1) && (FD_ISSET(cli[i].sock, &readFds)))
				if ((r = sockRead(cli[i].sock, ret.buf)))
				{
					ret.id		= SERVER_DATARDY;
					ret.sock	= i;
					return;
				}
				else if (r == 0)
				{
					ret.id		= SERVER_DISCONNECT;
					ret.sock	= i;
					return;
				}

		ret.id	= SERVER_NOCHANGE;

		return;
	}
}					

void Error( char *message )
{
	addLog("%s", message);
	exit(-1);
}

void sockDeInit( void )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (cli[i].sock != -1)
		{
			FD_CLR(cli[i].sock, &usedFds);
			close(cli[i].sock);
			cli[i].sock = -1;
		}

	close(listenSock);

	sleep(1);
}

void getNext( char *buf, char *buf2 )
{
	int     i;

	memset(buf2, 0, sizeof(buf2));

	for(i = 0; i < strlen(buf); i++)
		if (buf[i] != ';')
			buf2[i] = buf[i];
		else
		{
			buf2[i] = 0;
			strcpy(buf,buf+i+1);
			return;
		}

	buf[i+1] = 0;
}

void initSig( void )
{
	int	i;

	for(i = 0; i < 29; i++)
		signal(i, signalHandler);
}

static void sendAllMessage( char *msg )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (cli[i].sock != -1)
			sockSend(cli[i].sock, "%i;%s", PKT_KIL, msg);
}

void serverShutdown( char *message )
{
	preServerShutdown();
	sendAllMessage(message);
	sleep(1);
	sockDeInit();
	postServerShutdown(0);
}

void serverRestart( char *message )
{
	preServerShutdown();
	sockDeInit();
	postServerShutdown(0);
	recycleServer();
}

void signalHandler( int sig )
{
	switch (sig)
	{
	case SIGHUP:
		addLog("[PID: %i] Received Signal [HUP], " \
			"restarting server.", getpid());
		break;
	case SIGTERM:
		addLog("[PID: %i] Received Signal [TERM], " \
			"terminating server.", getpid());
		break;
	case SIGSEGV:
		addLog("[PID: %i] Received Signal [SEGV], " \
			"terminating server.", getpid());
		break;
	case SIGPIPE:
		addLog("[PID: %i] Received Signal [PIPE], " \
			"terminating server.", getpid());
		break;
	}

	preServerShutdown();
	sockDeInit();
	postServerShutdown(sig);

	if (sig == SIGHUP)
		recycleServer();

	exit(0);
}

void recycleServer( void )
{
	char	tmpbuf[100];

	sprintf(tmpbuf, "./%s &", SERVER_NAME);
	system(tmpbuf);

	sprintf(tmpbuf, "kill %i", getpid());
	system(tmpbuf);
}

static void checkConfig( void )
{
	FILE	*fto;
	char	tmpbuf[512];
	int	line = 0;

	if ((fto = fopen(SERVER_CONF, "r")) == NULL)
	{
		addLog("Unable to open configuration file [%s].", SERVER_CONF);
		exit(-1);
	}

	while(fgets(tmpbuf, 512, fto))
	{
		line++;

		if (tmpbuf[0] == '#' || tmpbuf[0] == 10)
		{
			continue;
		}
		else if (!strncasecmp(tmpbuf, "TrackingIp", 10))
		{
			strcpy(tmpbuf, tmpbuf+11);
			tmpbuf[strlen(tmpbuf)-1] = 0;
			sprintf(TRK_IP, tmpbuf);
		}
		else if (!strncasecmp(tmpbuf, "TrackingPort", 12))
		{
			strcpy(tmpbuf, tmpbuf+13);
			tmpbuf[strlen(tmpbuf)-1] = 0;
			TRK_PORT = atoi(tmpbuf);
		}
#ifndef	SERVER_IP
		else if (!strncasecmp(tmpbuf, "ServerIP", 8))
		{
			strcpy(tmpbuf, tmpbuf+9);
			tmpbuf[strlen(tmpbuf)-1] = 0;
			sprintf(SERVER_IP, tmpbuf);
		}
#endif
		else if (!strncasecmp(tmpbuf, "ServerPORT", 10))
		{
			strcpy(tmpbuf, tmpbuf+11);
			tmpbuf[strlen(tmpbuf)-1] = 0;
			SERVER_PORT = atoi(tmpbuf);
		}
		else if (!strncasecmp(tmpbuf, "ServerName", 10))
		{
			strcpy(tmpbuf, tmpbuf+11);
			tmpbuf[strlen(tmpbuf)-1] = 0;
			sprintf(SERVER_DESC, tmpbuf);
		}
		else if (!strncasecmp(tmpbuf, "ServerClients", 13))
		{
			strcpy(tmpbuf, tmpbuf+14);
			tmpbuf[strlen(tmpbuf)-1] = 0;
			SERVER_CLIENTS = atoi(tmpbuf);
			if (SERVER_CLIENTS > 255)
			{
				addLog("Maximum Connections set too high, " \
					"set below 255.");
				exit(-1);
			}
		}
		else
		{
			addLog("Unknown Variable on line %i of the " \
				"configuration file.", line);
			exit(-1);
		}
	}
}

void main( void )
{
	addLog("Unholy Knights %s Server version %s. [PID: %i]",
		SRVNAME, VERSION, getpid());

	initSig();
	checkConfig();
	preServerStartup();

	currentSock = (listenSock = sockInit());
	addLog("Recieving connections on port %i. [MAX CONNECT: %i]",
		SERVER_PORT, SERVER_CLIENTS);

	FD_SET(listenSock, &usedFds);

	for (;;)
	{
		sockProcess();
		ProgramProcess(ret.id, ret.sock, ret.buf);
	}
}
