#include "log.h"

static char *getDate( void )
{
	long		timeL;
	struct tm	timeT;
	char		*timeR;

	timeR	= (char *)malloc(10);
	timeL	= time(NULL);
	memcpy(&timeT, localtime(&timeL), sizeof(struct tm));
	sprintf(timeR, "%02i/%02i/%02i", timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year);

	return	timeR;
}

static char *getTime( void )
{
	long		timeL;
	struct tm	timeT;
	char		*timeR;

	timeR	= (char *)malloc(10);
	timeL	= time(NULL);
	memcpy(&timeT, localtime(&timeL), sizeof(struct tm));
	sprintf(timeR, "%02i:%02i:%02i", timeT.tm_hour, timeT.tm_min, timeT.tm_sec);

	return	timeR;
}

void addLog( char *text, ... )
{
	FILE		*fto;
	unsigned char	buffer[1024];
	va_list		va;
	char		*ptr1, *ptr2;

	va_start(va, text);
	vsnprintf(buffer, 1024, text, va);
	va_end(va);

	if ((fto = fopen(SERVER_LOGFILE, "a")) == NULL)
		return;

	ptr1    = getDate();
	ptr2    = getTime();

	fprintf(fto, SERVER_LOGFRMT, ptr1, ptr2, buffer);

	fclose(fto);

#ifdef SHOW_LOG
	printf(SERVER_LOGFRMT, ptr1, ptr2, buffer);
#endif

	free(ptr1);
	free(ptr2);
}
