#include "warp.h"

void clearWarpStuff( void )
{
	int	i;

	for(i = 0; i < maxWarp; i++)
	{
		warp[i].oldL = 0;
		warp[i].oldX = 0;
		warp[i].oldY = 0;
		warp[i].newL = 0;
		warp[i].newX = 0;
		warp[i].newY = 0;
	}
}

int initWarpStuff( void )
{
	int	i, len;
	FILE	*fd;

	if ((fd = fopen(F_WARP, "r")) == NULL)
	{
		printf("ERROR: Unable to open warp database [%s].\n", F_WARP);
		return	0;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(warpStruct);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		if (!fread(&warp[i], sizeof(warpStruct), 1, fd))
		{
			printf("ERROR: Unable to read warp database [%s].\n",
				F_WARP);
			return	0;
		}

	fclose(fd);

	return	1;
}
