#include "npc.h"

void clearNpcStuff( void )
{
	int	i;

	for(i = 0; i < NPCCNT; i++)
	{
		memset(NPCS[i].name, 0, 15);
		memset(NPCS[i].npcfile, 0, 20);
		NPCS[i].gfx		= 0;
		NPCS[i].armor		= 0;
		NPCS[i].helm		= 0;
		NPCS[i].roam		= 0;
		NPCS[i].level		= 0;
		NPCS[i].startx		= 0;
		NPCS[i].starty		= 0;
		NPCS[i].delay		= 0;
	}
}

int initNpcStuff( void )
{
	int		i, len;
	FILE		*fd;

	if ((fd = fopen(F_NPC, "r")) == NULL)
	{
		printf("ERROR: Unable to open npc database [%s].\n", F_NPC);
		return	0;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(npcStruct);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		if (!fread(&NPCS[i], sizeof(npcStruct), 1, fd))
		{
			printf("ERROR: Unable to read npc database [%s].\n",
				F_NPC);
			return	0;
		}

	fclose(fd);

	return	1;
}
