#include "monster.h"

void clearMonsterStuff( void )
{
	int	i;

	for(i = 0; i < MONSCNT; i++)
	{
		memset(MONS[i].name, 0, 15);
		MONS[i].gfx		= 0;
		MONS[i].color		= 0;
		MONS[i].attack		= 0;
		MONS[i].str		= 0;
		MONS[i].def		= 0;
		MONS[i].mag		= 0;
		MONS[i].spd		= 0;
		MONS[i].delay		= 0;
		MONS[i].experience	= 0;
		MONS[i].hp		= 0;
		MONS[i].mp		= 0;
	}
}

int initMonsterStuff( void )
{
	int		i, len;
	FILE		*fd;

	if ((fd = fopen(F_MONSTER, "r")) == NULL)
	{
		printf("ERROR: Unable to open monster database [%s].\n", F_MONSTER);
		return	0;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(monsterStruct);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		if (!fread(&MONS[i], sizeof(monsterStruct), 1, fd))
		{
			printf("ERROR: Unable to read monster database [%s].\n",
				F_MONSTER);
			return	0;
		}

	fclose(fd);

	return	1;
}
