#include "helm.h"

void clearHelmStuff( void )
{
	int	i;

	for(i = 0; i < HELMCNT; i++)
	{
		memset(HELMS[i].name, 0, 20);
		HELMS[i].color		= 0;
		HELMS[i].ac		= 0;
	}
}

int initHelmStuff( void )
{
	int		i, len;
	FILE		*fd;

	if ((fd = fopen(F_HELM, "r")) == NULL)
	{
		printf("ERROR: Unable to open helm database [%s].\n", F_HELM);
		return	0;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(helmStruct);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		if (!fread(&HELMS[i], sizeof(helmStruct), 1, fd))
		{
			printf("ERROR: Unable to read helm database [%s].\n",
				F_HELM);
			return	0;
		}

	fclose(fd);

	return	1;
}
