#include "class.h"

void clearClassStuff( void )
{
	int	i;

	for(i = 0; i < CLASSCNT; i++)
	{
		memset(CLASS[i].name, 0, 15);
		memset(CLASS[i].desc, 0, 25);
		CLASS[i].gfx		= 0;
		CLASS[i].startHp	= 0;
		CLASS[i].startMp	= 0;
		CLASS[i].startStr	= 0;
		CLASS[i].startDef	= 0;
		CLASS[i].startMag	= 0;
		CLASS[i].startSpd	= 0;
		CLASS[i].incStr		= 0;
		CLASS[i].incDef		= 0;
		CLASS[i].incMag		= 0;
		CLASS[i].incSpd		= 0;
	}
}

int initClassStuff( void )
{
	int		i, len;
	FILE		*fd;

	if ((fd = fopen(F_CLASS, "r")) == NULL)
	{
		printf("ERROR: Unable to open class database [%s].\n", F_CLASS);
		return	0;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(classStruct);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		if (!fread(&CLASS[i], sizeof(classStruct), 1, fd))
		{
			printf("ERROR: Unable to read class database [%s].\n",
				F_CLASS);
			return	0;
		}

	fclose(fd);

	return	1;
}
