#include "armor.h"

void clearArmorStuff( void )
{
	int	i;

	for(i = 0; i < ARMORCNT; i++)
	{
		memset(ARMORS[i].name, 0, 20);
		ARMORS[i].color		= 0;
		ARMORS[i].ac		= 0;
	}
}

int initArmorStuff( void )
{
	int		i, len;
	FILE		*fd;

	if ((fd = fopen(F_ARMOR, "r")) == NULL)
	{
		printf("ERROR: Unable to open armor database [%s].\n", F_ARMOR);
		return	0;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(armorStruct);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		if (!fread(&ARMORS[i], sizeof(armorStruct), 1, fd))
		{
			printf("ERROR: Unable to read armor database [%s].\n",
				F_ARMOR);
			return	0;
		}

	fclose(fd);

	return	1;
}
