#include "client.h"

int setBackGround( char *filename, int id )
{
	FILE	*fd;
	short	x, y;

	fd = openDataFile(filename);

	if (!findDataFile(fd, 1, id))
	{
		closeDataFile(fd);
		return	0;
	}

	fread(&x, 2, 1, fd);
	fread(&y, 2, 1, fd);

	if (!fread(BACKGROUND, (x * y), 1, fd))

	closeDataFile(fd);

	return	1;
}

void showSprite( spriteStruct *SPR, int Y, int X )
{
	int	i, j;
	u_char	*image;

	image = SPR->image;

	for(i = 0; i < SPR->height; i++)
		for(j = 0; j < SPR->width; j++)
			gfxPixel(Y+j, X+i, image[(i * SPR->width) + j]);
}

void showSpriteHit( spriteStruct *SPR, int Y, int X, int C )
{
	int	i, j;
	u_char	*image;

	image = SPR->image;

	for(i = 0; i < SPR->height; i++)
		for(j = 0; j < SPR->width; j++)
			if ((image[(i * SPR->width) + j]))
				gfxPixel(Y+j, X+i, C);
}

void showSpriteTransparent( spriteStruct *SPR, int Y, int X )
{
	int	i, j, c;
	u_char	*image;

	image = SPR->image;

	for(i = 0; i < SPR->height; i++)
		for(j = 0; j < SPR->width; j++)
		{
			c = image[(i * SPR->width) + j];
			if (c)	gfxPixel(Y+j, X+i, c);
		}
}

void showSpriteSpecial( int Y, int X, spriteStruct *SPR, int c1, int c2, int c3 )
{
	int	i, j, k;
	u_char	*image;

	image = SPR->image;

	for(i = 0; i < SPR->width; i++)
		for(j = 0; j < SPR->height; j++)
			if ((k = (image[(i * SPR->width) + j])))
			{
				if (k == 144 && c3)
					gfxPixel(Y+j, X+i, c3);
				else if (k == 145 && c2)
					gfxPixel(Y+j, X+i, c2);
				else if (k == 146 && c1)
					gfxPixel(Y+j, X+i, c1);
				else
					gfxPixel(Y+j, X+i, k);
			}
}

void loadSprites( void )
{
	FILE	*fd;
	int	i;
	short	x, y;

	fd = openDataFile(DATAFILE);

	for(i = 0; i < 16; i++)
	{
		if (!findDataFile(fd, 10, i+1))
		{
			printf("ERROR: In-valid Class graphics [id=10,%i].\n", i+1);
			gfxClose();
		}

		fread(&x, 2, 1, fd);
		fread(&y, 2, 1, fd);

		if ((classGfx[i].image = (u_char *)malloc(x * y)) == NULL)
		{
			printf("ERROR: Not enough memory for Class graphics.\n");
			gfxClose();
		}

		classGfx[i].pri		= 1;
		classGfx[i].width	= x;
		classGfx[i].height	= y;

		if (!fread(classGfx[i].image, (x * y), 1, fd))
		{
			printf("ERROR: Cannot read Class graphic.\n");
			gfxClose();
		}
	}

	closeDataFile(fd);
}

void loadBox( void )
{
	FILE	*fd;
	int	i;
	short	x, y;

	fd = openDataFile(DATAFILE);

	for(i = 0; i < 14; i++)
	{
		if (!findDataFile(fd, 29, i+1))
		{
			printf("ERROR: In-valid Box graphics [id=29,%i].\n", i+1);
			gfxClose();
		}

		fread(&x, 2, 1, fd);
		fread(&y, 2, 1, fd);

		if ((boxGfx[i].image = (u_char *)malloc(x * y)) == NULL)
		{
			printf("ERROR: Not enough memory for Box graphics.\n");
			gfxClose();
		}

		boxGfx[i].pri		= 1;
		boxGfx[i].width		= x;
		boxGfx[i].height	= y;

		if (!fread(boxGfx[i].image, (x * y), 1, fd))
		{
			printf("ERROR: Cannot read Box graphic.\n");
			gfxClose();
		}
	}

	closeDataFile(fd);
}

void loadSpc( void )
{
	FILE	*fd;
	short	x, y;

	fd = openDataFile(DATAFILE);
	if (!findDataFile(fd, 28, 1))
	{
		printf("ERROR: In-valid Spc graphics [id=28,1].\n");
		gfxClose();
	}

	fread(&x, 2, 1, fd);
	fread(&y, 2, 1, fd);

	if (!fread(spcGfx1, x * y, 1, fd))
	{
		printf("ERROR: Cannot read Spc graphic.\n");
		gfxClose();
	}
	closeDataFile(fd);
}

void loadMenu( void )
{
	long	total;
	FILE	*fd;

	fd = openDataFile(DATAFILE);
	if (!findDataFile(fd, 35, 1))
	{
		printf("ERROR: In-valid Menu graphics [id=35,1].\n");
		gfxClose();
	}

	fread(&menuGfx[0].width, 2, 1, fd);
	fread(&menuGfx[0].height, 2, 1, fd);

	total = menuGfx[0].width * menuGfx[0].height;

	if ((menuGfx[0].image = (char *)malloc(total)) == NULL)
	{
		printf("ERROR: Cannot get enough memory for menu graphics.\n");
		gfxClose();
	}

	if (!fread(menuGfx[0].image, total, 1, fd))
	{
		printf("ERROR: Cannot read Menu graphic.\n");
		gfxClose();
	}
	closeDataFile(fd);
}

void loadLand( char *filename )
{
	FILE	*fd;
	int	i;
	short	x, y;

	if ((fd = openDataFile(filename)) == NULL)
	{
		printf("ERROR: Unable to open data file [%s].\n", filename);
		gfxClose();
	}

	for(i = 0; i < numLand; i++)
	{
		if (!findDataFile(fd, 30, i+1))
		{
			printf("ERROR: In-valid font [id=30,%i], please report.\n", i+1);
			gfxClose();
		}

		fread(&x, 2, 1, fd);
		fread(&y, 2, 1, fd);

		if ((landGfx[i].image = (u_char *)malloc(x * y)) == NULL)
		{
			printf("ERROR: Not enough memory for land.\n");
			gfxClose();
		}

		landGfx[i].pri		= 1;
		landGfx[i].width	= x;
		landGfx[i].height	= y;

		if (!fread(landGfx[i].image, (x * y), 1, fd))
		{
			printf("ERROR: Cannot read land.\n");
			gfxClose();
		}
	}

	closeDataFile(fd);
}
