#include "client.h"

void sockSend( int sock, char *text, ... )
{
	unsigned char	buffer[4098],
			tmpbuf[4098];
	va_list		va;
	int		i, j;

	va_start(va, text);
	vsnprintf(buffer, 4098, text, va);
	va_end(va);

	i = strlen(buffer) / 200;
	j = strlen(buffer) - (i * 200);

	if (i == 0)
		i = 201;

	sprintf(tmpbuf, "%c%c%s", i, j, buffer);
	send(sock, tmpbuf, strlen(tmpbuf), 0);
}

int sockRead( int sock, char *text )
{
	int		r, r2, num;
	unsigned char	num1, num2;

#ifdef __compile_SVGALIB
#ifdef	KEYBOARD
	keyboard_update();
#endif
#endif

	memset(text, 0, sizeof(text));

	r	= read(sock, &num1, 1);
	r2	= read(sock, &num2, 1);
	if (r == 0 || r2 == 0)
		return(0);

	if (num1 == 201)
		num = num2;
	else
		num = (num1 * 200) + num2;

	r = read(sock, text, num);

	return(num);
}

int sockReadReady( int sock )
{
        struct timeval tv;

        tv.tv_sec  = 0;
        tv.tv_usec = 0;

	FD_ZERO(&readFds);
	FD_SET(sock, &readFds);

	select(sock+1, &readFds, NULL, NULL, &tv);

	if (FD_ISSET(sock, &readFds))
		return 1;

	return 0;
}

void sockClose( int sock )
{
	close(sock);
}

int sockConnect( char *host, int port )
{
	struct sockaddr_in	server;
	struct hostent		*lookup;
	int			tempsock;

	if ((lookup = gethostbyname(host)) == NULL)
		return	gfxERROR;

	memset((char *)&server, 0, sizeof(server));
	memcpy(&server.sin_addr, lookup->h_addr, lookup->h_length);

	server.sin_family	= AF_INET;
	server.sin_port		= htons(port);

        if ((tempsock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		return	gfxERROR;

	if (connect(tempsock, (struct sockaddr *)&server, sizeof(server)) < 0)
		return	gfxERROR;

	return tempsock;
}

int connectTracker( void )
{
	if ((TRK_SOCK = sockConnect(TRK_IP, TRK_PORT)) == gfxERROR)
		return	0;

	return	1;
}

int connectServer( void )
{
	if ((CLI_SOCK = sockConnect(trk[CLI_ID].ip, trk[CLI_ID].port)) == gfxERROR)
		return	0;

	return	1;
}

int connectPatch( void )
{
	if ((PCH_SOCK = sockConnect(PCH_IP, PCH_PORT)) == gfxERROR)
		return	0;

	return	1;
}

static int checkFile( char *filename )
{
	int	l;
	FILE	*fd;

	if ((fd = fopen(filename, "r")) == NULL)
		return	0;

	fseek(fd, 0, SEEK_END);

	l = ftell(fd);

	fclose(fd);

	return	l;
}

static void showProgress( char *filename, long br, long bt )
{
	gfxClearScreen();
	gfxDimBox(20, 79, 280, 40, 2);
	sprintf(TEMP_CRAP, "Recieving: %s (%lu of %lu)...", filename, br, bt);
	printLetters(35, 96, TEMP_CRAP, 63);
	gfxShowScreen();
}

static void addTrkServer( char *buf )
{
	char	tmpbuf[10];
	int	i;

	for(i = 0; i < 255; i++)
		if (trk[i].port == 0)
			break;

	getNext(buf, trk[i].name);
	getNext(buf, trk[i].ip);
	getNext(buf, tmpbuf); trk[i].port = atoi(tmpbuf);
	getNext(buf, tmpbuf); trk[i].cli  = atoi(tmpbuf);
	trk[i].mcli = atoi(buf);
}

static void addPatch( char *buf )
{
	int	i;

	for(i = 0; i < 20; i++)
		if (pch[i].size == 0)
			break;

	getNext(buf, pch[i].name);
	getNext(buf, pch[i].realname);
	pch[i].size = atoi(buf);
}

static int processTracker( char *buf )
{
	int		sw;

	getNext(buf, TEMP_CRAP);
	sw = atoi(TEMP_CRAP);

	switch(sw)
	{
	case PKT_OK:
		return	1;
		break;
	case PKT_LST:
		addTrkServer(buf);
		return	0;
		break;
	}

	return	0;
}

static void add2File( char *buf )
{
	char		tmpbuf[10];
	int		num, i;
	char		tmpchar;

	getNext(buf, tmpbuf);
	num = atoi(tmpbuf);

	for(i = 0; i < num; i++, TEMP_CNT++)
	{
		getNext(buf, tmpbuf);
		tmpchar = atoi(tmpbuf);
		fputc(tmpchar, temp_fd);
	}
}

static int processPatch( char *buf )
{
	int		sw;

	getNext(buf, TEMP_CRAP);
	sw = atoi(TEMP_CRAP);

	switch(sw)
	{
	case PKT_ERR:
		if (atoi(buf) == PKT_LUP)
		{
			printf("ERROR: Error while recieving Patch Information.\n");
			return	1;
		}
		else if (atoi(buf) == PKT_RCV)
		{
			printf("ERROR: Error while updating file.\n");
			return	-1;
		}
		break;
	case PKT_OK:
		return	1;
		break;
	case PKT_LUP:
		addPatch(buf);
		break;
	case PKT_RCV:
		add2File(buf);
		sockSend(PCH_SOCK, "%i", PKT_CON);
		break;
	}

	return	0;
}

static void convertFile( char *filename )
{
	FILE	*fd1, *fd2;
	int	i, len;

	fd1 = fopen(".temp.update", "r");
	if ((fd2 = fopen(filename, "w")) == NULL)
	{
		printf("ERROR: Unable to open %s for updating.\n", filename);

		fclose(fd1);
		fd1 = fopen(".temp.update", "w");
		fclose(fd1);

		return;
	}

	fseek(fd1, 0, SEEK_END);
	len = ftell(fd1);
	fseek(fd1, 0, SEEK_SET);

	for(i = 0; i < len; i++)
		fputc((unsigned char)fgetc(fd1), fd2);

	fclose(fd2);

	fclose(fd1);
	fd1 = fopen(".temp.update", "w");
	fclose(fd1);

	printf("Download: '%s' has been updated.\n", filename);
	if (!strncasecmp(filename, "ukClient", 8))
		printf("(you must rename '%s' to 'ukClient' for " \
			"update to take effect)\n", filename);
}

static void updateFile( char *filename, long filesize )
{
	char	buf[4098];
	int	r;

	if ((temp_fd = fopen(".temp.update", "w")) == NULL)
	{
		printf("ERROR: Unable open file for updating.\n");
		return;
	}

	sockSend(PCH_SOCK, "%i;%s", PKT_RCV, filename);

	for( ;; )
	{
		memset(buf, 0, 4098);

		keyGet();
		if (sockReadReady(PCH_SOCK))
		{
			sockRead(PCH_SOCK, buf);
			if ((r = processPatch(buf)) == -1)
			{
				fclose(temp_fd);
				return;
			}
			else if (r)
				break;
			else
				showProgress(filename, TEMP_CNT, filesize);
		}
	}

	fclose(temp_fd);

	convertFile(filename);
}

int recieveTracker( void )
{
	char	buf[4098];

	sockSend(TRK_SOCK, "%i", PKT_LST);

	for( ;; )
	{
		memset(buf, 0, 4098);

		keyGet();
		if (sockReadReady(TRK_SOCK))
		{
			sockRead(TRK_SOCK, buf);
			if (processTracker(buf))
				return 1;
		}
	}

	return	0;
}

int recievePatch( void )
{
	char	buf[4098];
	int	i, count = 0;

	sockSend(PCH_SOCK, "%i", PKT_LUP);

	for( ;; )
	{
		memset(buf, 0, 4098);

		keyGet();
		if (sockReadReady(PCH_SOCK))
		{
			sockRead(PCH_SOCK, buf);
			if (processPatch(buf))
				break;
		}
	}

	for(i = 0; i < 20; i++)
		if (pch[i].size != 0)
			if (checkFile(pch[i].name) != pch[i].size)
			{
				count++;
				TEMP_CNT = 0;
				updateFile(pch[i].realname, pch[i].size);
			}

	return	count;
}

void disconnectTracker( void )
{
	sockClose(TRK_SOCK);
}

void disconnectPatch( void )
{
	sockClose(PCH_SOCK);
}
