#include "client.h"

static int numServer( void )
{
	int	i, count = 0;

	for(i = 0; i < 255; i++)
		if (trk[i].port != 0)
			count++;

	return	count;
}

int chooseServer( void )
{
	int	current = 1, currentID = 0, servers;
	char	c;

#ifndef	KEYBOARD
	CLI_ID = currentID;
	if (!connectServer())
	{
		printf("ERROR: Cannot connect to server.\n");
		gfxClose();
	}
	processLogin();
	return	1;
#endif

	servers = numServer();
	drawServerScreen();
	gfxShowScreen();

	if (servers)
		drawBar(current);

	for( ;; )
	{
		c = keyGet();

		if (c == 2 && servers)
		{
			if (current < servers)
			{
				current += 1;
				currentID += 1;
				drawBar(current);
			}
		}
		else if (c == 1 && servers)
		{
			if (current > 1)
			{
				current -= 1;
				currentID -= 1;
				drawBar(current);
			}
		}
		else if (c == 13)
		{
			gfxClearScreen();
			statusBox("Connectin to Server...");
			gfxShowScreen();

			CLI_ID = currentID;
			if (!connectServer())
			{
				printf("ERROR: Cannot connect to server.\n");
				gfxClose();
			}
			processLogin();
			return	1;
		}
		else if (c == 27)
		{
			gfxClose();
		}
	}

	return	1;
}

void processLogin( void )
{
	int	current = 2, drawScreen = 1, selected = 0, k = 0;
	char	c;

	int	word1count = 0, word2count = 0;
	char	word1string[30], word2string[30];

#ifndef	KEYBOARD
	sockSend(CLI_SOCK, "%i;rebelord;bleh", PKT_LGN);
	if (recieveStuff(CHK_LOGIN))
		return;
	printf("failed login...\n");
	gfxClose();
#endif

	memset(word1string, 0, 30);
	memset(word2string, 0, 30);

	for( ;; )
	{
		if (drawScreen)
		{
			drawScreen = 0;
			drawLoginScreen(word1string, word2string, selected, current);
		}

		switch(current)
		{
		case 1:
			while(!k)
			{
				c = keyGet();
				if (c == 'Y' || c == 'y')
				{
					selected = 1;
					drawScreen = 1;
					current++;
					k++;
				}
				else if (c == 'N' || c == 'n')
				{
					selected = 0;
					drawScreen = 1;
					current++;
					k++;
				}
				else if (c == 9)
				{
					current = 2;
					drawScreen = 1;
					k++;
				}
				else if (c == 27)
				{
					sockClose(CLI_SOCK);
					gfxClose();
				}
			}
			k = 0;
			break;
		case 2:
			while(!k)
			{
				c = keyGetSpc2();
				if (c == 8 && word1count > 0)
				{
					word1string[--word1count] = 0;
					drawScreen = 1;
					k++;
				}
				else if (c == 9)
				{
					current = 3;
					drawScreen = 1;
					k++;
				}
				else if (c == 13)
				{
					current = 3;
					drawScreen = 1;
					k++;
				}
				else if (c == 27)
				{
					sockClose(CLI_SOCK);
					gfxClose();
				}
				else if (c != gfxERROR && word1count < 20)
				{
					sprintf(word1string, "%s%c",
						word1string, c);
					word1count++;
					drawScreen = 1;
					k++;
				}
			}
			k = 0;
			break;
		case 3:
			while(!k)
			{
				c = keyGetSpc2();
				if (c == 8 && word2count > 0)
				{
					word2string[--word2count] = 0;
					drawScreen = 1;
					k++;
				}
				else if (c == 9)
				{
					current = 1;
					drawScreen = 1;
					k++;
				}
				else if (c == 13)
				{
					gfxClearScreen();
					if (selected)
					{
						statusBox("Creating new account...");
						sockSend(CLI_SOCK, "%i;%s;%s",
							PKT_NEW,
							word1string,
							word2string);
					}
					else
					{
						statusBox("Verifing Account...");
						sockSend(CLI_SOCK, "%i;%s;%s",
							PKT_LGN,
							word1string,
							word2string);
					}
					gfxShowScreen();

					gfxClearScreen();
					if (recieveStuff(CHK_LOGIN) == PKT_OK)
						return;
					else
						statusBox("Could not login or create account.");
					gfxShowScreen();
					sleep(3);

					drawScreen = 1;
					k++;
				}
				else if (c == 27)
				{
					sockClose(CLI_SOCK);
					gfxClose();
				}
				else if (c != gfxERROR && word2count < 20)
				{
					sprintf(word2string, "%s%c",
						word2string, c);
					word2count++;
					drawScreen = 1;
					k++;
				}
			}
			k = 0;
			break;
		}
	}
}

int chooseCreate( void )
{
	int	ask = 1, current = 1, drawScreen = 1;
	char	c, name[13], desc[21];

	memset(name, 0, 13);
	memset(desc, 0, 21);

	for( ;; )
	{
		if (drawScreen)
		{
			drawScreen = 0;
			drawCreateScreen(name, desc, current, ask);
		}

		if (ask == 3)
			c = keyGetSpc1();
		else
			c = keyGetSpc2();

		if (c == 9)
		{
			if (++ask >= 4)
				ask = 1;
			drawScreen++;
		}
		else if (c == 2 && ask == 3)
		{
			if (current == 10)
				current = 1;
			else
				current++;
			drawScreen++;
		}
		else if (c == 1 && ask == 3)
		{
			if (current == 1)
				current = 10;
			else
				current--;
			drawScreen++;
		}
		else if (c == 13 && ask == 3 && CLASS[current-1].startHp)
		{
			gfxClearScreen();
			statusBox("Creating new character...");
			gfxShowScreen();

			sockSend(CLI_SOCK, "%i;%s;%s;%i",
				PKT_CRT, name, desc, current);

			if (recieveStuff(CHK_CREATE) == PKT_OK)
				return	PKT_NEW;

			gfxClearScreen();
			sprintf(TEMP_CRAP, "Unable to create the character %s.", name);
			statusBox(TEMP_CRAP);
			gfxShowScreen();
			sleep(3);
			drawScreen++;
		}
		else if (c == 13 && ask != 3)
		{
			ask++;
			drawScreen++;
		}
		else if (c == 27)
		{
			gfxClearScreen();
			gfxShowScreen();
			return	0;
		}
		else if (c == 8 && (ask == 1 || ask == 2))
		{
			if (ask == 1 && strlen(name) > 0)
			{
				name[strlen(name)-1] = 0;
				drawScreen = 1;
			}
			else if (ask == 2 && strlen(desc) > 0)
			{
				desc[strlen(desc)-1] = 0;
				drawScreen = 1;
			}
		}
		else if (c != gfxERROR && (ask == 1 || ask == 2))
		{
			if (ask == 1 && strlen(name) < 12)
			{
				sprintf(name, "%s%c", name, c);
				drawScreen = 1;
			}
			else if (ask == 2 && strlen(desc) < 20)
			{
				sprintf(desc, "%s%c", desc, c);
				drawScreen = 1;
			}
		}
	}
}

int chooseCharacter( void )
{
	int	current = 1, drawScreen = 1;
	char	c;

#ifndef	KEYBOARD
	return	current;
#endif

	for( ;; )
	{
		if (drawScreen)
		{
			drawScreen = 0;
			drawCharacterScreen(current);
		}

		c = keyGetSpc1();

		if (c == 2)
		{
			if (current == 5)
				current = 1;
			else
				current++;
			drawScreen++;
		}
		else if (c == 1)
		{
			if (current == 1)
				current = 5;
			else
				current--;
			drawScreen++;
		}
		else if (c == 13)
		{
			if (!plr[current-1].active)
			{
				if (chooseCreate())
					return	PKT_NEW;
			}
			else
			{
				CH = current - 1;
				return	current;
			}

			drawScreen++;
		}
		else if (c == 27)
		{
			gfxClearScreen();
			gfxShowScreen();
			sockClose(CLI_SOCK);
			return	0;
		}
	}
}
