#include "mouse.h"

int mouseInit( void )
{
#ifdef __compile_X
	gfxMask |= (ButtonPressMask | ButtonReleaseMask |
		LeaveWindowMask | EnterWindowMask);

	XSelectInput(gfxDisplay, gfxWindow, gfxMask);
	XWarpPointer(gfxDisplay, None, gfxWindow, 0, 0, 0, 0, -10, -10);
	XFlush(gfxDisplay);

	return	1;
#endif
#ifdef __compile_SVGALIB
	return	0;
#endif
}

void mouseShow( void )
{
#ifdef __compile_SVGALIB
#endif
}

void mouseHide( void )
{
#ifdef __compile_SVGALIB
#endif
}

void mouseStatus( int *x, int *y, int *buttons )
{
#ifdef __compile_X
	XEvent		mEvent;
	Window		dRoot, dChild;
	int		dX, dY;
	unsigned int	dKey;
	static int	button;
	static short	in;

	if (XCheckTypedEvent(gfxDisplay, ButtonPress, &mEvent))
		button = mEvent.xbutton.button;

	if (XCheckTypedEvent(gfxDisplay, ButtonRelease, &mEvent))
		button = 0;

	if (XCheckTypedWindowEvent(gfxDisplay, gfxWindow, LeaveNotify, &mEvent))
		in = 0;

	if (in)
		XQueryPointer(gfxDisplay, gfxWindow, &dRoot, &dChild,
			&dX, &dY, x, y, &dKey);

	*buttons = button;
#endif
#ifdef __compile_SVGALIB
#endif
}

void mouseMove( int x, int y )
{
#ifdef __compile_X
	XWarpPointer(gfxDisplay, None, gfxWindow, 0, 0, 0, 0, x, y);
#endif
#ifdef __compile_SVGALIB
#endif
}

void mouseDeInit( void )
{
#ifdef __compile_X
	gfxMask &= ~ButtonPressMask;
	gfxMask &= ~ButtonReleaseMask;
	gfxMask &= ~LeaveWindowMask;
	gfxMask &= ~EnterWindowMask;

	XSelectInput(gfxDisplay, gfxWindow, gfxMask);
#endif
#ifdef __compile_SVGALIB
#endif
}
