#include "mapeditor.h"

void statusBox( char *text )
{
	int	i;

	i = totalLetters(text);
	gfxDimBox(140 - (i/2), 79, i + 40, 40, 2);
	printLetters(160 - (i/2), 96, text, 63);
}

void putSprite( spriteStruct *SPR, int Y, int X )
{
	int	i, j;
	u_char	*image;

	image	 = SPR->image;

	for(i = 0; i < SPR->width; i++)
		for(j = 0; j < SPR->height; j++)
			gfxPixel(Y+j, X+i, image[(i * SPR->width) + j]);
}

void showMap( int X, int Y )
{
	int	i, j, image;

	for(i = 0; i < 10; i++)
		for (j = 0; j < 14; j++)
		{
			image = mapData[((Y+i) * MAPM_X) + (X+j)];
			putSprite(&landGfx[image], 5+(j<<4), 5+(i<<4));
		}
}

void showCur( int X, int Y )
{
	gfxHLine((X*16)+5, (X*16)+20, (Y*16)+5, 13);
	gfxHLine((X*16)+5, (X*16)+20, (Y*16)+20, 13);
	gfxVLine((X*16)+5, (Y*16)+5, (Y*16)+20, 13);
	gfxVLine((X*16)+20, (Y*16)+5, (Y*16)+20, 13);
}

int chooseTile( int current )
{
	int	cur, i, j, drawScreen = 1,
		curX = 0, curY = 0;
	char	c;

	cur = current;

	for( ;; )
	{
		if (drawScreen)
		{
			drawScreen = 0;
			gfxClearScreen();
			gfxDimBox(4, 4, 306, 162, 0);
			sprintf(TEMP_CRAP, "USE CURSOR KEYS. ENTER TO SELECT. ESCAPE TO CANCEL.");
			printLetters(161-(totalLetters(TEMP_CRAP)/2), 173,
				TEMP_CRAP, 0);
			printLetters(160-(totalLetters(TEMP_CRAP)/2), 172,
				TEMP_CRAP, 62);

			for(i = 0; i < 10; i++)
				for(j = 0; j < 19; j++)
					if (((i*19)+j) < numLand)
						putSprite(&landGfx[(i*19)+j],
							5+(j*16), 5+(i*16));

			showCur(curX, curY);
			gfxShowScreen();
		}

		c = keyGet();
		if (c == 27)
		{
			return	current;
		}
		else if (c == 1)
		{
			if (curY > 0)
				curY--;
			drawScreen = 1;
		}
		else if (c == 2)
		{
			if (curY < 9)
				curY++;
			drawScreen = 1;
		}
		else if (c == 3)
		{
			if (curX > 0)
				curX--;
			drawScreen = 1;
		}
		else if (c == 4)
		{
			if (curX < 18)
				curX++;
			drawScreen = 1;
		}
		else if (c == 13)
		{
			if (((curY*19)+curX) < numLand)
				return	(curY * 19) + curX;
		}
	}
}

int highestX( void )
{
	int	i, j;

	for(i = MAPM_X-1; i > 0; i--)
		for(j = 0; j < MAPM_Y; j++)
			if (mapData[(j*MAPM_X)+(i-1)] != 0)
				return	i;

	return	0;
}

int highestY( void )
{
	int	i, j;

	for(i = MAPM_Y-1; i > 0; i--)
		for(j = 0; j < MAPM_X; j++)
			if (mapData[(i*MAPM_X)+j] != 0)
				return	i+1;

	return	0;
}

int saveMap( char *filename )
{
	int	i, j;
	FILE	*fd;

	if ((fd = fopen(filename, "w")) == NULL)
		return	0;

	fputc((unsigned char)highestX(), fd);
	fputc((unsigned char)highestY(), fd);

	for(i = 0; i < highestY(); i++)
		for(j = 0; j < highestX(); j++)
			fputc((unsigned char)mapData[(i*MAPM_X)+j], fd);

	fclose(fd);
	return	1;
}

void main( int argc, char *argv[] )
{
	char	*filename, *ukData, c;
	FILE	*fd_filename, *fd_ukData;
	int	i, j, k, drawScreen = 1,
		curX = 0, curY = 0,
		posX = 0, posY = 0,
		curTile = 0,
		sizeX, sizeY;
	short	x, y;

	gfxInit();
	keyInit();

	printf("\n");
	printf("Unholy Knights MapEditor version %s, Copyright 1998 by Brian Justen.\n",
		VERSION);

#ifdef __compile_SVGALIB
	if (getuid() != 0)
	{
		printf("UID 0 is required to use the Unholy Knights MapEditor.\n");
		gfxClose();
	}
#endif

	if (argc != 3)
	{
		printf("usage: ukMapEditor <map filename> <location of uk.data>\n");
		gfxClose();
	}

	filename = argv[1];
	ukData	 = argv[2];

	gfxSetVideoMode(gfxVIDEO);

	if ((VB = (unsigned char *)malloc(gfxBig)) == NULL)
	{
		printf("ERROR: Unable to allocate memory for video buffer.\n");
		gfxClose();
	}

	gfxSetScreen();

	if ((fd_ukData = fopen(ukData, "r")) == NULL)
	{
		printf("Unable to open graphics file (uk.data) [%s].\n",
			ukData);
		gfxClose();
	}

	for(i = 0; i < numLand; i++)
	{
		if (!findDataFile(fd_ukData, 30, i+1))
		{
			printf("ERROR: In-valid Land graphics [id=30,%i].\n", i+1);
			gfxClose();
		}

		fread(&x, 2, 1, fd_ukData);
		fread(&y, 2, 1, fd_ukData);

		if ((landGfx[i].image = (u_char *)malloc(x * y)) == NULL)
		{
			printf("ERROR: Unable to get memory for graphics.\n");
			gfxClose();
		}

		landGfx[i].pri		= 1;
		landGfx[i].width	= x;
		landGfx[i].height	= y;

		if (!fread(landGfx[i].image, (x * y), 1, fd_ukData))
		{
			printf("ERROR: Problem reading graphics file.\n");
			gfxClose();
		}
	}

	if (!findDataFile(fd_ukData, 1, 1))
	{
		printf("ERROR: Unable to get open background.\n");
		gfxClose();
	}

	fread(&x, 2, 1, fd_ukData);
	fread(&y, 2, 1, fd_ukData);

	if (!fread(BACKGROUND, (x * y), 1, fd_ukData))
	{
		printf("ERROR: Unable to read background.\n");
		gfxClose();
	}

	fclose(fd_ukData);
	memset(mapData, 0, MAPM_X * MAPM_Y);

	loadFont(ukData);

	if ((fd_filename = fopen(filename, "r")) == NULL)
	{
		printf("Unable to open map file [%s], assuming new.\n", filename);

		if ((fd_filename = fopen(filename, "w")) == NULL)
		{
			printf("Unable to open, check file premissions.\n");
			gfxClose();
		}

		printf("Creating: [Map %s].\n", filename);

		if (!fwrite(mapData, MAPM_X * MAPM_Y, 1, fd_filename))
		{
			printf("Unable to write to map file [%s].\n", filename);
			gfxClose();
		}
		fclose(fd_filename);
	}
	else
	{
		sizeX = fgetc(fd_filename);
		sizeY = fgetc(fd_filename);
		printf("Opened: [Map %s - Size %ix%i].\n",
			filename, sizeX, sizeY);

		for(j = 0; j < sizeY; j++)
			for(k = 0; k < sizeX; k++)
				mapData[(j*MAPM_X)+k] = fgetc(fd_filename);

		fclose(fd_filename);
	}

	keyOpen();
	gfxLoadPalette(ukData);

	gfxClearScreen();
	gfxSaveBack(0, 190, 320, 10);
	gfxDimBack(2);
	gfxPutBack();

	printLetters(3, 193, "Unholy Knights MapEditor", 111);
	sprintf(TEMP_CRAP, "Version %s", VERSION);
	printLetters(266, 193, TEMP_CRAP, 111);
	gfxSaveScreen();

	for( ;; )
	{
		if (drawScreen)
		{
			drawScreen = 0;
			gfxClearScreen();
			gfxDimBox(4, 4, ((MAP_X+1)*16)+2, ((MAP_Y+1)*16)+2, 0);
			showMap(posX, posY);
			showCur(curX, curY);

			sprintf(TEMP_CRAP, "USER CURSOR KEYS. COMMANDS ARE LISTED ABOVE ON THE RIGHT.");
			printLetters(161-(totalLetters(TEMP_CRAP)/2), 177,
				TEMP_CRAP, 0);
			printLetters(160-(totalLetters(TEMP_CRAP)/2), 176,
				TEMP_CRAP, 62);

			gfxDimBox(236, 5, 78, 45, 2);
			printLetters(246, 11, "Current Tile", 0);
			printLetters(245, 10, "Current Tile", 62);
			putSprite(&landGfx[curTile], 267, 23);

			gfxDimBox(236, 55, 78, 45, 2);
			printLetters(247, 61, "Map Position", 0);
			printLetters(246, 60, "Map Position", 62);
			sprintf(TEMP_CRAP, "%03i", posX+curX+1);
			printLetters(261, 74, "X", 106);
			printLetters(273, 74, TEMP_CRAP, 111);
			sprintf(TEMP_CRAP, "%03i", posY+curY+1);
			printLetters(261, 82, "Y", 106);
			printLetters(273, 82, TEMP_CRAP, 111);

			gfxDimBox(236, 105, 78, 61, 2);
			printLetters(254, 111, "Commands:", 0);
			printLetters(253, 110, "Commands:", 62);
			printLetters(242, 121, "'S'", 106);
			printLetters(277, 121, "SAVE", 111);
			printLetters(242, 129, "'R'", 106);
			printLetters(277, 129, "RELOAD", 111);
			printLetters(242, 137, "ESCAPE", 106);
			printLetters(277, 137, "EXIT", 111);
			printLetters(242, 145, "ENTER", 106);
			printLetters(277, 145, "SELECT", 111);
			printLetters(242, 153, "SPACE", 106);
			printLetters(277, 153, "CHANGE", 111);

			gfxShowScreen();
		}

		c = keyGet();

		if (c == 27)
		{
			if (CHANGED)
			{
				gfxClearScreen();
				statusBox("Do you wish to save (Y/N)? [Yes]");
				gfxShowScreen();
				for( ;; )
				{
					c = keyGet();
					if (c == 'Y' || c == 'y' || c == 13)
					{
						if (!saveMap(filename))
							printf("ERROR: Could not save map!\n");
						gfxClose();
					}
					else if (c == 'N' || c == 'n')
					{
						gfxClose();
					}
				}
			}
			gfxClose();
		}
		else if (c == 1)
		{
			if (curY > 0)
				curY--;
			else if (posY > 0)
				posY--;
			drawScreen = 1;
		}
		else if (c == 2)
		{
			if (curY < 9)
				curY++;
			else if (posY < (MAPM_Y - 10))
				posY++;

			drawScreen = 1;
		}
		else if (c == 3)
		{
			if (curX > 0)
				curX--;
			else if (posX > 0)
				posX--;
			drawScreen = 1;
		}
		else if (c == 4)
		{
			if (curX < 13)
				curX++;
			else if (posX < (MAPM_X - 14))
				posX++;
			drawScreen = 1;
		}
		else if (c == 13)
		{
			curTile = chooseTile(curTile);
			drawScreen = 1;
		}
		else if (c == ' ')
		{
			mapData[((posY+curY)*MAPM_X)+(posX+curX)] = curTile;
			CHANGED = 1;
			drawScreen = 1;
		}
		else if (c == 'S' || c == 's')
		{
			gfxClearScreen();
			if (!saveMap(filename))
			{
				statusBox("Unable to save map!");
				gfxShowScreen();
				sleep(3);
			}
			else
			{
				statusBox("Map dumped to file.");
				gfxShowScreen();
				sleep(1);
			}
			drawScreen = 1;
		}
	}
}
