#include <stdio.h>
#include <stdlib.h>
#define PACKFILE "/home/devel/UnholyKnights-ClientRelease/ukClient/uk.mapdata"

void packFile( FILE *f_fd, char *filename, short id )
{
	FILE	*fd;
	int	X, Y;
	char	*tmpbuf;

	if ((fd = fopen(filename, "r")) == NULL)
	{
		printf("ERROR: Cannot open map file [%s].\n", filename);
		exit(0);
	}

	X = fgetc(fd);
	Y = fgetc(fd);

	if ((tmpbuf = (char *)malloc(X*Y)) == NULL)
	{
		printf("ERROR: Cannot allocate memory.\n");
		exit(0);
	}

	if (!fread(tmpbuf, X*Y, 1, fd))
	{
		printf("ERROR: Unable to read from map file [%s].\n", filename);
		exit(0);
	}

	fwrite(&id, sizeof(short), 1, f_fd);
	fputc(X, f_fd);
	fputc(Y, f_fd);

	if (!fwrite(tmpbuf, X*Y, 1, f_fd))
	{
		printf("ERROR: Unable to write to map pack file.\n");
		exit(0);
	}

	fclose(fd);

	free(tmpbuf);
}

void main( void )
{
	FILE	*fd;

	printf("Unholy Knights Map Packer version 1.0\n");

	if ((fd = fopen(PACKFILE, "w")) == NULL)
	{
		printf("ERROR: Unable to open map pack file for writing [%s].\n",
			PACKFILE);
		exit(0);
	}

	printf("Packing map:         ");

	printf("\b\b\b\b\b\b\b\b%-8s", "1.map");
	packFile(fd, "../maps/1.map", 1);
	printf("\b\b\b\b\b\b\b\b%-8s", "2.map");
	packFile(fd, "../maps/2.map", 2);
	printf("\b\b\b\b\b\b\b\b%-8s", "3.map");
	packFile(fd, "../maps/3.map", 3);
	printf("\b\b\b\b\b\b\b\b%-8s", "4.map");
	packFile(fd, "../maps/4.map", 4);
	printf("\b\b\b\b\b\b\b\b%-8s", "5.map");
	packFile(fd, "../maps/5.map", 5);
	printf("\b\b\b\b\b\b\b\b%-8s", "6.map");
	packFile(fd, "../maps/6.map", 6);

	printf("\nComplete.\n");
	fclose(fd);
}
