#include "client.h"
#include "mouse.h"

void clearMonsterStuff( void )
{
	int	i;

	for(i = 0; i < MAXMONS; i++)
		MONSTER[i].active = 0;
}

void clearNpcStuff( void )
{
	int	i;

	for(i = 0; i < NPCCNT; i++)
	{
		memset(npc[i].name, 0, 15);
		npc[i].gfx = 0;
		npc[i].helm = 0;
		npc[i].armor = 0;
		npc[i].posX = 0;
		npc[i].posY = 0;
		npc[i].level = 0;
	}
}

static void showBackDrop( void )
{
	int	i, tmpT1, tmpT2;

	memcpy(VB, spcGfx1, gfxBig);

	showSprite(&boxGfx[0], 0, 0);
	showSprite(&boxGfx[1], (MAP_X << 4)+4, 0);
	showSprite(&boxGfx[2], (MAP_X << 4)+4, (MAP_Y << 4)+4);
	showSprite(&boxGfx[3], 0, (MAP_Y << 4)+4);

	for(i = 0; i < (MAP_Y * 4); i++)
		showSprite(&boxGfx[4], 0, 4 + (i * 4));
	for(i = 0; i < (MAP_Y * 4); i++)
		showSprite(&boxGfx[6], 4+(MAP_X << 4), 4 + (i * 4));
	for(i = 0; i < (MAP_X * 4); i++)
		showSprite(&boxGfx[5], 4 + (i * 4), 0);
	for(i = 0; i < (MAP_X * 4); i++)
		showSprite(&boxGfx[7], 4 + (i * 4), 4+(MAP_Y << 4));

	tmpT1 = 9 + (MAP_X << 4);
	tmpT2 = 4 + (MAP_Y << 4);

	for(i = 0; i < (MAP_Y * 4); i++)
		showSprite(&boxGfx[4], tmpT1, 4 + (i * 4));
	for(i = 0; i < (MAP_Y * 4); i++)
		showSprite(&boxGfx[6], 316, 4 + (i * 4));
	for(i = 0; i < (MAP_X * 4); i++)
		showSprite(&boxGfx[5], tmpT1+(i * 4), 0);
	for(i = 0; i < (MAP_X * 4); i++)
		showSprite(&boxGfx[7], tmpT1+(i * 4), tmpT2);

	showSprite(&boxGfx[0], tmpT1, 0);
	showSprite(&boxGfx[1], 316, 0);
	showSprite(&boxGfx[2], 316, (MAP_Y << 4)+4);
	showSprite(&boxGfx[3], tmpT1, (MAP_Y << 4)+4);

	gfxSaveBack(0, 190, 320, 10);
	gfxDimBack(2);
	gfxPutBack();

	printLetters(16+(MAP_X << 4), 19, "L", 0);
	printLetters(15+(MAP_X << 4), 18, "L", 111);
	printLetters(256, 19, "XP", 0);
	printLetters(255, 18, "XP", 111);
	printLetters(16+(MAP_X << 4), 32, "HP", 0);
	printLetters(15+(MAP_X << 4), 31, "HP", 111);
	printLetters(273, 32, "MP", 0);
	printLetters(272, 31, "MP", 111);

	gfxHLine(12+(MAP_X << 4), 316, 13, 0);
	gfxHLine(12+(MAP_X << 4), 316, 14, 120);
	gfxHLine(12+(MAP_X << 4), 316, 15, 0);
	gfxHLine(12+(MAP_X << 4), 316, 26, 0);
	gfxHLine(12+(MAP_X << 4), 316, 27, 120);
	gfxHLine(12+(MAP_X << 4), 316, 28, 0);
	gfxHLine(12+(MAP_X << 4), 316, 39, 0);
	gfxHLine(12+(MAP_X << 4), 316, 40, 120);
	gfxHLine(12+(MAP_X << 4), 316, 41, 0);

	gfxVLine(250, 15, 26, 0);
	gfxVLine(251, 15, 27, 120);
	gfxVLine(252, 15, 26, 0);
	gfxVLine(266, 28, 39, 0);
	gfxVLine(267, 28, 40, 120);
	gfxVLine(268, 28, 39, 0);
}

static void addChat( char *text, int color )
{
	int	i;

	for(i = 0; i < 3; i++)
	{
		sprintf(CHAT[i].text, CHAT[i+1].text);
		CHAT[i].color = CHAT[i+1].color;
	}

	sprintf(CHAT[3].text, text);
	CHAT[3].color = color;
}

static void addInfo( int color, char *text, ... )
{
	unsigned char	buffer[1024];
	va_list		va;
	int	i;

	va_start(va, text);
	vsnprintf(buffer, 1024, text, va);
	va_end(va);

	for(i = 0; i < 12; i++)
	{
		sprintf(INFO[i].text, INFO[i+1].text);
		INFO[i].color = INFO[i+1].color;
	}

	sprintf(INFO[12].text, buffer);
	INFO[12].color = color;
}

static void showChat( void )
{
	int	i;

	for(i = 0; i < 4; i++)
	{
		printLetters(5, 158+(i << 3), CHAT[i].text, 0);
		printLetters(5, 157+(i << 3), CHAT[i].text, CHAT[i].color);
	}
}

static void showInfo( void )
{
	int	i;

	for(i = 0; i < 13; i++)
	{
		printLetters(16+(MAP_X << 4), 45+(i << 3),
			INFO[i].text, 0);
		printLetters(15+(MAP_X << 4), 44+(i << 3),
			INFO[i].text, INFO[i].color);
	}
}

static void showMap( void )
{
	int	i, j;
	short	pic;

	for(i = 0; i < MAP_Y; i++)
		for(j = 0; j < MAP_X; j++)
		{
			pic = mapData[((i+CURRENTY)*(MAPM_X+MAPO_X+1))+(j+CURRENTX)];
			showSprite(&landGfx[pic], 4+(j << 4), 4+(i << 4));
		}
}

static void showChars( int facing, int moving )
{
	int	i, classPic, armorNum, helmNum;

	classPic = CLASS[plr[CH].class].gfx + facing + moving;
	armorNum = ARMORS[plr[CH].armor].color;
	helmNum = HELMS[plr[CH].helm].color;

	showSpriteSpecial(100, 68, &classGfx[classPic], armorNum, helmNum, 0);

	for(i = 0; i < 255; i++)
		if (CHAR[i].active
			&& strcasecmp(CHAR[i].name, plr[CH].name)
			&& CHAR[i].level == CURRENTMAP)
		{
			classPic = CLASS[CHAR[i].class].gfx+CHAR[i].facing;
			armorNum = ARMORS[CHAR[i].armor].color;
			helmNum = HELMS[CHAR[i].helm].color;

			if (CHAR[i].posX+7 > CURRENTX &&
				CHAR[i].posX+7 <= CURRENTX+MAP_X &&
				CHAR[i].posY+5 > CURRENTY &&
				CHAR[i].posY+5 <= CURRENTY+MAP_Y)
				showSpriteSpecial(
					4 + ((6+(CHAR[i].posX-(CURRENTX))) << 4),
					4 + ((4+(CHAR[i].posY-(CURRENTY))) << 4),
					&classGfx[classPic],
					armorNum, helmNum, 0);
		}

	for(i = 0; i < NPCCNT; i++)
		if (npc[i].posX != -1 && npc[i].level == CURRENTMAP)
		{
			classPic = CLASS[npc[i].gfx].gfx+npc[i].facing;
			armorNum = ARMORS[npc[i].armor].color;
			helmNum = HELMS[npc[i].helm].color;

			if (npc[i].posX+7 > CURRENTX &&
				npc[i].posX+7 <= CURRENTX+MAP_X &&
				npc[i].posY+5 > CURRENTY &&
				npc[i].posY+5 <= CURRENTY+MAP_Y)
				showSpriteSpecial(
					4 + ((6+(npc[i].posX-(CURRENTX))) << 4),
					4 + ((4+(npc[i].posY-(CURRENTY))) << 4),
					&classGfx[classPic],
					armorNum, helmNum, 0);
		}

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].active)
		{
			classPic = CLASS[MONSTER[i].gfx].gfx+MONSTER[i].facing;

			if (MONSTER[i].posX+7 > CURRENTX &&
				MONSTER[i].posX+7 <= CURRENTX+MAP_X &&
				MONSTER[i].posY+5 > CURRENTY &&
				MONSTER[i].posY+5 <= CURRENTY+MAP_Y)
			{
				if (MONSTER[i].hitCount)
				{
					MONSTER[i].hitCount--;
					showSpriteHit(&classGfx[classPic],
						4 + ((6+(MONSTER[i].posX-(CURRENTX))) << 4),
						4 + ((4+(MONSTER[i].posY-(CURRENTY))) << 4),
						111);
				}
				else
				{
					showSpriteSpecial(
						4 + ((6+(MONSTER[i].posX-(CURRENTX))) << 4),
						4 + ((4+(MONSTER[i].posY-(CURRENTY))) << 4),
						&classGfx[classPic],
						MONSTER[i].color,
						MONSTER[i].color, 0);
				}
			}
		}
}

static void showDisplay( int mode, char *text )
{
	printLetters(16+(MAP_X << 4), 7, plr[CH].name, 0);
	printLetters(15+(MAP_X << 4), 6, plr[CH].name, 111);
	sprintf(TEMP_CRAP, "%07lu", plr[CH].exp);
	printLetters(270, 19, TEMP_CRAP, 0);
	printLetters(269, 18, TEMP_CRAP, 105);
	sprintf(TEMP_CRAP, "%04i", plr[CH].hp);
	printLetters(29+(MAP_X << 4), 32, TEMP_CRAP, 0);
	printLetters(28+(MAP_X << 4), 31, TEMP_CRAP, 105);
	sprintf(TEMP_CRAP, "%04i", plr[CH].mp);
	printLetters(287, 32, TEMP_CRAP, 0);
	printLetters(286, 31, TEMP_CRAP, 105);
	sprintf(TEMP_CRAP, "%03i", plr[CH].level);
	printLetters(23+(MAP_X << 4), 19, TEMP_CRAP, 0);
	printLetters(22+(MAP_X << 4), 18, TEMP_CRAP, 105);

	if (mode == 0)
	{
		printLetters(5, 192, "Press F1 for Help.", 111);
	}
	else if (mode == 1)
	{
		printLetters(5, 192, "[message]: ", 107);
		sprintf(TEMP_CRAP, "%s_", text);
		printLetters(50, 192, TEMP_CRAP, 111);
	}
}

static void clearNpcTalk( void )
{
	int	i;

	for(i = 0; i < 10; i++)
		memset(NpcTalk[i], 0, 100);

	NpcCount = 0;
}

static void addNpcTalk( char *text )
{
	if (++NpcCount > 10)
		return;

	sprintf(NpcTalk[NpcCount], text);
}

static void showNpcTalk( int current )
{
	int	i, classPic, armorNum, helmNum;

	showSprite(&menuGfx[0], 25, 20);

	classPic = CLASS[npc[CMN_CLASS].gfx].gfx;
	armorNum = ARMORS[npc[CMN_CLASS].armor].color;
	helmNum = HELMS[npc[CMN_CLASS].helm].color;

	showSpriteSpecial(46, 51, &classGfx[classPic],
		armorNum, helmNum, 0);

	for(i = 0; i < 10; i++)
	{
		printLetters(86, 36+(i * 8), NpcTalk[i], 0);
		printLetters(85, 35+(i * 8), NpcTalk[i], 59);
	}

	printLetters(86, 158, "Press ESCAPE to return.", 0);
	printLetters(85, 157, "Press ESCAPE to return.", 111);
}

static int processMain( char *buf )
{
	char	tmpbuf[1024];
	int	r, i;
	float	f;

	memset(tmpbuf, 0, 1024);

	getNext(buf, tmpbuf);
	r = atoi(tmpbuf);

	switch(r)
	{
	case PKT_GO:
		getNext(buf, tmpbuf);
		sockSend(CLI_SOCK, "%i;0;0", PKT_MOV);
		return	PKT_GO;
		break;
	case PKT_MOV:
		getNext(buf, tmpbuf); CURRENTX = atoi(tmpbuf);
		getNext(buf, tmpbuf); CURRENTY = atoi(tmpbuf);
		getNext(buf, tmpbuf);
		if (atoi(tmpbuf) != CURRENTMAP)
		{
			CURRENTMAP = atoi(tmpbuf);
			loadMap(CURRENTMAP);
		}
		return	PKT_MOV;
		break;
	case PKT_TLK:
		memset(TEMP_CRAP, 0, 1024);

		getNext(buf, tmpbuf);
		if (atoi(tmpbuf) == 1)
			sprintf(TEMP_CRAP, "[Server] ");

		getNext(buf, tmpbuf);
		i = atoi(tmpbuf);
		getNext(buf, tmpbuf);
		sprintf(TEMP_CRAP, "%s%s", TEMP_CRAP, tmpbuf);

		addChat(TEMP_CRAP, i);
		return	PKT_TLK;
		break;
	case PKT_PMV:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		getNext(buf, tmpbuf); CHAR[i].posX = atoi(tmpbuf);
		getNext(buf, tmpbuf); CHAR[i].posY = atoi(tmpbuf);
		getNext(buf, tmpbuf); CHAR[i].level = atoi(tmpbuf);
		getNext(buf, tmpbuf); CHAR[i].facing = atoi(tmpbuf);
		return	PKT_PMV;
		break;
	case PKT_NPC:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		getNext(buf, npc[i].name);
		getNext(buf, tmpbuf); npc[i].gfx = atoi(tmpbuf);
		getNext(buf, tmpbuf); npc[i].armor = atoi(tmpbuf);
		getNext(buf, tmpbuf); npc[i].helm = atoi(tmpbuf);
		getNext(buf, tmpbuf); npc[i].posX = atoi(tmpbuf);
		getNext(buf, tmpbuf); npc[i].posY = atoi(tmpbuf);
		getNext(buf, tmpbuf); npc[i].level = atoi(tmpbuf);
		getNext(buf, tmpbuf);

		if (atoi(tmpbuf) != -1)
			npc[i].facing = atoi(tmpbuf);

		return	PKT_PMV;
		break;
	case PKT_LVL:
		getNext(buf, tmpbuf);
		if (!loadMap(atoi(tmpbuf)))
		{
			printf("ERROR: Unable to locate map [id=%i].\n",
				atoi(tmpbuf));
			gfxClose();
		}
		return	PKT_CON;
		break;
	case PKT_ENT:
		getNext(buf, tmpbuf);
		i = atoi(tmpbuf);
		getNext(buf, tmpbuf); CHAR[i].class = atoi(tmpbuf);
		if (CHAR[i].class == -1)
			CHAR[i].active = 0;
		else
		{
			getNext(buf, CHAR[i].name);
			getNext(buf, tmpbuf); CHAR[i].posX = atoi(tmpbuf);
			getNext(buf, tmpbuf); CHAR[i].posY = atoi(tmpbuf);
			getNext(buf, tmpbuf); CHAR[i].level = atoi(tmpbuf);
			getNext(buf, tmpbuf); CHAR[i].armor = atoi(tmpbuf);
			getNext(buf, tmpbuf); CHAR[i].helm = atoi(tmpbuf);
			CHAR[i].active = 1;
		}
		return	PKT_ENT;
		break;
	case PKT_CLR:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		switch(i)
		{
		case RFH_NPC:
			clearNpcStuff();
		case RFH_MON:
			clearMonsterStuff();
		}
		break;
	case PKT_CLV:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		getNext(buf, tmpbuf); CHAR[i].level = atoi(tmpbuf);
		return	PKT_CON;
	case PKT_CMN:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		if (i == CMN_START)
		{
			getNext(buf, tmpbuf);
			CMN_MODE = atoi(tmpbuf);
			getNext(buf, tmpbuf);
			CMN_CLASS = atoi(tmpbuf);
			return	CMN_START;
		}
		else if (i == CMN_TEXT)
		{
			getNext(buf, tmpbuf);
			addNpcTalk(tmpbuf);
			return	CMN_TEXT;
		}
		else if (i == CMN_END)
		{
			return	CMN_END;
		}
		break;
	case PKT_MON:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);

		if (!MONSTER[i].active)
		{
			MONSTER[i].active	= 1;
			MONSTER[i].hitCount	= 0;
			MONSTER[i].hitType	= 0;
		}

		getNext(buf, tmpbuf); MONSTER[i].gfx = atoi(tmpbuf);

		if (MONSTER[i].gfx == -1)
		{
			MONSTER[i].active	= 0;
		}
		else
		{
			getNext(buf, tmpbuf); MONSTER[i].color = atoi(tmpbuf);
			getNext(buf, tmpbuf); MONSTER[i].posX = atoi(tmpbuf);
			getNext(buf, tmpbuf); MONSTER[i].posY = atoi(tmpbuf);
			getNext(buf, tmpbuf);

			if (atoi(tmpbuf) != -1)
				MONSTER[i].facing = atoi(tmpbuf);

		}
		break;
	case PKT_HIT:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		getNext(buf, tmpbuf); f = atof(tmpbuf);
		MONSTER[i].hitCount = 1;
		break;
	case PKT_CUP:
		getNext(buf, tmpbuf); plr[CH].level	= atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[CH].exp	= atol(tmpbuf);
		getNext(buf, tmpbuf); plr[CH].hp	= atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[CH].mp	= atoi(tmpbuf);
		return PKT_CUP;
		break;
	case PKT_NFO:
		getNext(buf, tmpbuf);
		addInfo(106, tmpbuf);
		break;
	case PKT_KIL:
		getNext(buf, tmpbuf);
		printf("%s\n", tmpbuf);
		return PKT_KIL;
		break;
	}

	return	PKT_ERR;
}

int passOK( int X, int Y )
{
	int	i, value;

	if ((X+CURRENTX) >= cur_X)
		return	0;

	if ((Y+CURRENTY) >= cur_Y)
		return	0;

	for(i = 0; i < 255; i++)
		if (CHAR[i].active && CHAR[i].level == CURRENTMAP
			&& (CHAR[i].posX == CURRENTX+X)
			&& (CHAR[i].posY == CURRENTY+Y))
			return	0;

	for(i = 0; i < NPCCNT; i++)
		if (npc[i].posX != -1 && npc[i].level == CURRENTMAP
			&& (npc[i].posX == CURRENTX+X)
			&& (npc[i].posY == CURRENTY+Y))
			return	0;

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].active
			&& (MONSTER[i].posX == CURRENTX+X)
			&& (MONSTER[i].posY == CURRENTY+Y))
			return	0;

	i = mapData[((Y+CURRENTY+MAPO_Y)*(MAPM_X+MAPO_X+1))+(X+CURRENTX+MAPO_X)];
	value = landType[i].type;
	if (value)
		return	0;

	return	1;
}

static void processText( char *text )
{
	char	tmptext[1024];

	if (text[0] != '*')
		sockSend(CLI_SOCK, "%i;%i;%s: %s", PKT_TLK, PKT_TLK,
			plr[CH].name, text);

	memcpy(tmptext, text, 1024);
	strcpy(tmptext, tmptext + 1);

	if (!strncasecmp(tmptext, "refresh", 7))
	{
		strcpy(tmptext, tmptext + 8);
		if (!strlen(tmptext))
		{
			addInfo(0, "");
			addInfo(111, "Refresh Options");
			addInfo(106, "NPC, WARP,");
			addInfo(106, "HELM, ARMOR,");
			addInfo(106, "LAND, MAPS,");
			addInfo(106, "ITEM, MON");
		}
		else if (!strncasecmp(tmptext, "npc", 3))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_NPC);
		}
		else if (!strncasecmp(tmptext, "warp", 4))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_WARP);
		}
		else if (!strncasecmp(tmptext, "helm", 4))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_HELM);
		}
		else if (!strncasecmp(tmptext, "armor", 5))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_ARMOR);
		}
		else if (!strncasecmp(tmptext, "land", 4))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_LAND);
		}
		else if (!strncasecmp(tmptext, "maps", 4))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_MAPS);
		}
		else if (!strncasecmp(tmptext, "item", 4))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_ITEM);
		}
		else if (!strncasecmp(tmptext, "mon", 3))
		{
			sockSend(CLI_SOCK, "%i;%i;%i",
				PKT_TLK, PKT_RFH, RFH_MON);
		}
	}
	else if (!strncasecmp(tmptext, "monster", 7))
	{
		strcpy(tmptext, tmptext + 8);

		if (!strlen(tmptext))
		{
			addInfo(111, "Monster Usage");
			addInfo(106, "<type>;<level>;");
			addInfo(106, "<pos X>;<pos Y>");
		}
		else
		{
			sockSend(CLI_SOCK, "%i;%i;%s",
				PKT_TLK, PKT_MON, tmptext);
		}
	}
	else if (!strncasecmp(tmptext, "help", 4))
	{
		addInfo(111, "Gamemaster Help");
		addInfo(106, "refresh");
		addInfo(106, "monster");
	}
	else if (!strncasecmp(tmptext, "position", 8))
	{
		sockSend(CLI_SOCK, "%i", PKT_GMI);
	}
}

static int isCounter( int x, int y )
{
	int	tile;

	tile = mapData[((y+4) * (MAPM_X+MAPO_X+1)) + (x+6)];

	if (tile == 29 || tile == 30 || tile == 31 || tile == 33)
		return	1;

	return	0;
}

void mainProcess( int r )
{
	char	tmpbuf[1024], c, text[100];
	int	ret, drawScreen = 1,
		facing = 0, moving = 0,
		mode = 0;


	memcpy(savedBG, BACKGROUND, gfxBig);
	memset(text, 0, 100);
	memset(VB, 0, gfxBig);
	showBackDrop();
	gfxSaveScreen();

	sockSend(CLI_SOCK, "%i;%i", PKT_GO, r);

	for( ;; )
	{
redraw:
		if (drawScreen)
		{
			gfxClearScreen();
			showMap();
			showChars(facing, moving);
			showChat();
			showDisplay(mode, text);
			showInfo();

			if (mode == 2)
				showNpcTalk(0);

			gfxShowScreen();
		}

		if (sockReadReady(CLI_SOCK))
		{
			memset(tmpbuf, 0, 1024);
			sockRead(CLI_SOCK, tmpbuf);
			ret = processMain(tmpbuf);

			if (ret == PKT_MOV)
				moving = 0;
			else if (ret == PKT_KIL)
			{
				sockClose(CLI_SOCK);
				gfxClose();
			}
			else if (ret == CMN_END)
			{
				mode = 2;
			}

			drawScreen = 1;
			goto redraw;
		}
		else
			drawScreen = 0;

		c = keyGet();
		switch(mode)
		{
		case 0:					/* regular mode */
			if (!moving && c == 1)
			{
				if (facing != 4)
				{
					facing = 4;
					sockSend(CLI_SOCK, "%i;0;0;%i",
						PKT_MOV, facing);
					moving = 1;
				}
				else if (passOK(0, -1))
				{
					sockSend(CLI_SOCK, "%i;0;-1;%i",
						PKT_MOV, facing);
					CURRENTY--;
					moving = 1;
				}
				drawScreen = 1;
			}
			else if (!moving && c == 2)
			{
				if (facing != 0)
				{
					facing = 0;
					sockSend(CLI_SOCK, "%i;0;0;%i",
						PKT_MOV, facing);
					moving = 1;
				}
				else if (passOK(0, 1))
				{
					sockSend(CLI_SOCK, "%i;0;1;%i",
						PKT_MOV, facing);
					CURRENTY++;
					moving = 1;
				}
				drawScreen = 1;
			}
			else if (!moving && c == 3)
			{
				if (facing != 6)
				{
					facing = 6;
					sockSend(CLI_SOCK, "%i;0;0;%i",
						PKT_MOV, facing);
					moving = 1;
				}
				else if (passOK(-1, 0))
				{
					sockSend(CLI_SOCK, "%i;-1;0;%i",
						PKT_MOV, facing);
					CURRENTX--;
					moving = 1;
				}
				drawScreen = 1;
			}
			else if (!moving && c == 4)
			{
				if (facing != 2)
				{
					facing = 2;
					sockSend(CLI_SOCK, "%i;0;0;%i",
						PKT_MOV, facing);
					moving = 1;
				}
				else if (passOK(1, 0))
				{
					sockSend(CLI_SOCK, "%i;1;0;%i",
						PKT_MOV, facing);
					CURRENTX++;
					moving = 1;
				}
				drawScreen = 1;
			}
			else if (c == 'A' || c == 'a' || c == 32)
			{
				if (facing == 4)
					sockSend(CLI_SOCK, "%i;%i;%i;%i",
						PKT_ATK, ATK_HAND,
						CURRENTX, CURRENTY-1);
				else if (facing == 0)
					sockSend(CLI_SOCK, "%i;%i;%i;%i",
						PKT_ATK, ATK_HAND,
						CURRENTX, CURRENTY+1);
				else if (facing == 6)
					sockSend(CLI_SOCK, "%i;%i;%i;%i",
						PKT_ATK, ATK_HAND,
						CURRENTX-1, CURRENTY);
				else
					sockSend(CLI_SOCK, "%i;%i;%i;%i",
						PKT_ATK, ATK_HAND,
						CURRENTX+1, CURRENTY);
			}
			else if ((c == 'Q' || c == 'q'))
			{
				sockSend(CLI_SOCK, "%i", PKT_EXT);
				memcpy(BACKGROUND, savedBG, 64000);
				return;
			}
			else if ((c == 'M' || c == 'm'))
			{
				mode = 1;
				drawScreen = 1;
			}
			else if ((c == 'S' || c == 's'))
			{
				addInfo(0, "");
				addInfo(110, "Character Status");
				addInfo(106, "L-Hand: Nothing");
				addInfo(106, "R-Hand: Nothing");
				addInfo(106, "Armor: %s", ARMORS[plr[CH].armor].name);
				addInfo(106, "Helm: %s", HELMS[plr[CH].helm].name);
				addInfo(106, "Boots: Nothing");
				addInfo(106, "Necklace: Nothing");
	
				drawScreen = 1;
			}
			else if ((c == 'T' || c == 't'))
			{
				if (facing == 4)
				{
					if (isCounter(CURRENTX, CURRENTY-1))
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX, CURRENTY-2);
					else
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX, CURRENTY-1);
				}
				else if (facing == 0)
				{
					if (isCounter(CURRENTX, CURRENTY+1))
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX, CURRENTY+2);
					else
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX, CURRENTY+1);
				}
				else if (facing == 6)
				{
					if (isCounter(CURRENTX-1, CURRENTY))
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX-2, CURRENTY);
					else
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX-1, CURRENTY);
				}
				else
				{
					if (isCounter(CURRENTX+1, CURRENTY))
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX+2, CURRENTY);
					else
						sockSend(CLI_SOCK, "%i;%i;%i",
							PKT_CMN, CURRENTX+1, CURRENTY);
				}
			}
			else if (c == 15)
			{
				addInfo(0, "");
				addInfo(110, "Command Help");
				addInfo(106, "Q - QUIT GAME");
				addInfo(106, "M - SEND MESSAGE");
				addInfo(106, "S - STATUS");
				addInfo(106, "T - Talk");
				addInfo(106, "A - Attack");
	
				drawScreen = 1;
			}
			else if (c == 16 && plr[CH].sysop)
			{
				sockSend(CLI_SOCK, "%i;%i;1;3;3;3",
					PKT_TLK, PKT_MON);
			}
			else if (c == 17 && plr[CH].sysop)
			{
				sockSend(CLI_SOCK, "%i;%i;0;3;3;3",
					PKT_TLK, PKT_MON);
			}
			else if (c == 18 && plr[CH].sysop)
			{
				sockSend(CLI_SOCK,
					"%i;1;restarting server.", PKT_KIL);
			}
			break;
		case 1:					/* message mode */
			if (c >= 32 && c <= 122)
			{
				if (totalLetters(text) < 250)
					sprintf(text, "%s%c", text, c);
	
				drawScreen = 1;
			}
			else if (c == 8)
			{
				if (strlen(text) > 0)
					text[strlen(text)-1] = 0;

				drawScreen = 1;
			}
			else if (c == 13)
			{
				if (strlen(text) > 0)
					processText(text);

				memset(text, 0, 100);
				mode = 0;
				drawScreen = 1;
			}
			else if (c == 27)
			{
				memset(text, 0, 100);
				mode = 0;
				drawScreen = 1;
			}
			break;
		case 2:
			if (c == 27)
			{
				mode = 0;
				drawScreen = 1;
				clearNpcTalk();
			}
			break;
		}
	}
}
