#include "client.h"

int gKey( long num )
{
#ifdef __compile_X
	KeyCode	code;
	char	keyVec[32];
	int	keybit;
	u_int	byteI, bitI;

	code = XKeysymToKeycode(gfxDisplay, (KeySym)num);
	if (code == NoSymbol || !num)
		return	0;

	byteI = code / 8;
	bitI  = code & 7;

	XQueryKeymap(gfxDisplay, keyVec);
	keybit = (1 & (keyVec[byteI] >> bitI));

	return	keybit;
#endif
#ifdef __compile_SVGALIB
	return	keyboard_keypressed(num);
#endif
}

int keyInit( void )
{
	int	i;

	for(i = 0; i < 10; i++)
		keyS[i].key	= 0;

	for(i = 0; i < 100; i++)
		key[i].key	= 0;

	for(i = 0; i < 200; i++)
		keyR[i].key	= 0;

	for(i = 0; i < 256; i++)
		keyH[i].key	= 0;

#ifdef __compile_X
	keyS[0].key	= XK_Control_L;
	keyS[1].key	= XK_Control_R;
	keyS[2].key	= XK_Shift_L;
	keyS[3].key	= XK_Shift_R;
	keyS[4].key	= XK_Alt_L;
	keyS[5].key	= XK_Alt_R;
	keyS[6].key	= XK_Num_Lock;
	keyS[7].key	= XK_Scroll_Lock;

	key[0].key	= XK_Return;
	key[1].key	= XK_BackSpace;
	key[2].key	= XK_Escape;
	key[3].key	= XK_space;
	key[4].key	= XK_Tab;
	key[5].key	= XK_KP_Enter;
	key[6].key	= XK_KP_Up;
	key[7].key	= XK_KP_Down;
	key[8].key	= XK_KP_Left;
	key[9].key	= XK_KP_Right;
	key[10].key	= XK_Up;
	key[11].key	= XK_Down;
	key[12].key	= XK_Left;
	key[13].key	= XK_Right;

	key[15].key	= XK_F1;
	key[16].key	= XK_F2;
	key[17].key	= XK_F3;
	key[18].key	= XK_F4;
	key[19].key	= XK_F5;
	key[20].key	= XK_F6;

	key[30].key	= XK_0;
	key[31].key	= XK_1;
	key[32].key	= XK_2;
	key[33].key	= XK_3;
	key[34].key	= XK_4;
	key[35].key	= XK_5;
	key[36].key	= XK_6;
	key[37].key	= XK_7;
	key[38].key	= XK_8;
	key[39].key	= XK_9;
	key[40].key	= XK_a;
	key[41].key	= XK_b;
	key[42].key	= XK_c;
	key[43].key	= XK_d;
	key[44].key	= XK_e;
	key[45].key	= XK_f;
	key[46].key	= XK_g;
	key[47].key	= XK_h;
	key[48].key	= XK_i;
	key[49].key	= XK_j;
	key[50].key	= XK_k;
	key[51].key	= XK_l;
	key[52].key	= XK_m;
	key[53].key	= XK_n;
	key[54].key	= XK_o;
	key[55].key	= XK_p;
	key[56].key	= XK_q;
	key[57].key	= XK_r;
	key[58].key	= XK_s;
	key[59].key	= XK_t;
	key[60].key	= XK_u;
	key[61].key	= XK_v;
	key[62].key	= XK_w;
	key[63].key	= XK_x;
	key[64].key	= XK_y;
	key[65].key	= XK_z;
	key[66].key	= XK_comma;
	key[67].key	= XK_period;
	key[68].key	= XK_slash;
	key[69].key	= XK_backslash;
	key[70].key	= XK_colon;
	key[71].key	= XK_apostrophe;
	key[72].key	= XK_bracketleft;
	key[73].key	= XK_bracketright;
#endif
#ifdef __compile_SVGALIB
	keyS[0].key	= SCANCODE_LEFTCONTROL;
	keyS[1].key	= SCANCODE_RIGHTCONTROL;
	keyS[2].key	= SCANCODE_LEFTSHIFT;
	keyS[3].key	= SCANCODE_RIGHTSHIFT;
	keyS[4].key	= SCANCODE_LEFTALT;
	keyS[5].key	= SCANCODE_RIGHTALT;
	keyS[6].key	= SCANCODE_NUMLOCK;
	keyS[7].key	= SCANCODE_SCROLLLOCK;

	key[0].key	= SCANCODE_ENTER;
	key[1].key	= SCANCODE_BACKSPACE;
	key[2].key	= SCANCODE_ESCAPE;
	key[3].key	= SCANCODE_SPACE;
	key[4].key	= SCANCODE_TAB;
	key[5].key	= SCANCODE_KEYPADENTER;
	key[6].key	= SCANCODE_CURSORUP;
	key[7].key	= SCANCODE_CURSORDOWN;
	key[8].key	= SCANCODE_CURSORLEFT;
	key[9].key	= SCANCODE_CURSORRIGHT;
	key[10].key	= SCANCODE_CURSORBLOCKUP;
	key[11].key	= SCANCODE_CURSORBLOCKDOWN;
	key[12].key	= SCANCODE_CURSORBLOCKLEFT;
	key[13].key	= SCANCODE_CURSORBLOCKRIGHT;

	key[15].key	= SCANCODE_F1;
	key[16].key	= SCANCODE_F2;
	key[17].key	= SCANCODE_F3;
	key[18].key	= SCANCODE_F4;
	key[19].key	= SCANCODE_F5;
	key[20].key	= SCANCODE_F6;

	key[30].key	= SCANCODE_0;
	key[31].key	= SCANCODE_1;
	key[32].key	= SCANCODE_2;
	key[33].key	= SCANCODE_3;
	key[34].key	= SCANCODE_4;
	key[35].key	= SCANCODE_5;
	key[36].key	= SCANCODE_6;
	key[37].key	= SCANCODE_7;
	key[38].key	= SCANCODE_8;
	key[39].key	= SCANCODE_9;
	key[40].key	= SCANCODE_A;
	key[41].key	= SCANCODE_B;
	key[42].key	= SCANCODE_C;
	key[43].key	= SCANCODE_D;
	key[44].key	= SCANCODE_E;
	key[45].key	= SCANCODE_F;
	key[46].key	= SCANCODE_G;
	key[47].key	= SCANCODE_H;
	key[48].key	= SCANCODE_I;
	key[49].key	= SCANCODE_J;
	key[50].key	= SCANCODE_K;
	key[51].key	= SCANCODE_L;
	key[52].key	= SCANCODE_M;
	key[53].key	= SCANCODE_N;
	key[54].key	= SCANCODE_O;
	key[55].key	= SCANCODE_P;
	key[56].key	= SCANCODE_Q;
	key[57].key	= SCANCODE_R;
	key[58].key	= SCANCODE_S;
	key[59].key	= SCANCODE_T;
	key[60].key	= SCANCODE_U;
	key[61].key	= SCANCODE_V;
	key[62].key	= SCANCODE_W;
	key[63].key	= SCANCODE_X;
	key[64].key	= SCANCODE_Y;
	key[65].key	= SCANCODE_Z;
	key[66].key	= SCANCODE_COMMA;
	key[67].key	= SCANCODE_PERIOD;
	key[68].key	= SCANCODE_SLASH;
	key[69].key	= SCANCODE_BACKSLASH;
	key[70].key	= SCANCODE_SEMICOLON;
	key[71].key	= SCANCODE_APOSTROPHE;
	key[72].key	= SCANCODE_BRACKET_LEFT;
	key[73].key	= SCANCODE_BRACKET_RIGHT;
#endif

	keyR[0].key	= 13;
	keyR[1].key	= 8;
	keyR[2].key	= 27;
	keyR[3].key	= 32;
	keyR[4].key	= 9;
	keyR[5].key	= 13;
	keyR[6].key	= 1;
	keyR[7].key	= 2;
	keyR[8].key	= 3;
	keyR[9].key	= 4;
	keyR[10].key	= 1;
	keyR[11].key	= 2;
	keyR[12].key	= 3;
	keyR[13].key	= 4;

	keyR[15].key	= 15;
	keyR[16].key	= 16;
	keyR[17].key	= 17;

	keyR[30].key	= 48;
	keyR[31].key	= 49;
	keyR[32].key	= 50;
	keyR[33].key	= 51;
	keyR[34].key	= 52;
	keyR[35].key	= 53;
	keyR[36].key	= 54;
	keyR[37].key	= 55;
	keyR[38].key	= 56;
	keyR[39].key	= 57;
	keyR[40].key	= 97;
	keyR[41].key	= 98;
	keyR[42].key	= 99;
	keyR[43].key	= 100;
	keyR[44].key	= 101;
	keyR[45].key	= 102;
	keyR[46].key	= 103;
	keyR[47].key	= 104;
	keyR[48].key	= 105;
	keyR[49].key	= 106;
	keyR[50].key	= 107;
	keyR[51].key	= 108;
	keyR[52].key	= 109;
	keyR[53].key	= 110;
	keyR[54].key	= 111;
	keyR[55].key	= 112;
	keyR[56].key	= 113;
	keyR[57].key	= 114;
	keyR[58].key	= 115;
	keyR[59].key	= 116;
	keyR[60].key	= 117;
	keyR[61].key	= 118;
	keyR[62].key	= 119;
	keyR[63].key	= 120;
	keyR[64].key	= 121;
	keyR[65].key	= 122;
	keyR[66].key	= 44;
	keyR[67].key	= 46;
	keyR[68].key	= 47;
	keyR[69].key	= 92;
	keyR[70].key	= 59;
	keyR[71].key	= 39;
	keyR[72].key	= 91;
	keyR[73].key	= 93;

	keyR[130].key	= 41;
	keyR[131].key	= 33;
	keyR[132].key	= 64;
	keyR[133].key	= 35;
	keyR[134].key	= 36;
	keyR[135].key	= 37;
	keyR[136].key	= 94;
	keyR[137].key	= 38;
	keyR[138].key	= 42;
	keyR[139].key	= 40;
	keyR[140].key	= 65;
	keyR[141].key	= 66;
	keyR[142].key	= 67;
	keyR[143].key	= 68;
	keyR[144].key	= 69;
	keyR[145].key	= 70;
	keyR[146].key	= 71;
	keyR[147].key	= 72;
	keyR[148].key	= 73;
	keyR[149].key	= 74;
	keyR[150].key	= 75;
	keyR[151].key	= 76;
	keyR[152].key	= 77;
	keyR[153].key	= 78;
	keyR[154].key	= 79;
	keyR[155].key	= 80;
	keyR[156].key	= 81;
	keyR[157].key	= 82;
	keyR[158].key	= 83;
	keyR[159].key	= 84;
	keyR[160].key	= 85;
	keyR[161].key	= 86;
	keyR[162].key	= 87;
	keyR[163].key	= 88;
	keyR[164].key	= 89;
	keyR[165].key	= 90;
	keyR[166].key	= 60;
	keyR[167].key	= 62;
	keyR[168].key	= 63;
	keyR[169].key	= 124;
	keyR[170].key	= 58;
	keyR[171].key	= 34;
	keyR[172].key	= 123;
	keyR[173].key	= 125;

	return	gfxOK;
}

static int keyCheck( int num )
{
	if (keyH[num].key)
		return	gfxERROR;

	return	gfxOK;
}

static void keyAdd( int num )
{
	keyH[num].key	= 1;
}

static void keyDel( int num )
{
	keyH[num].key	 = 0;
}

int keyOpen( void )
{
#ifdef __compile_X
	gfxMask |= KeyPressMask;
	XSelectInput(gfxDisplay, gfxWindow, gfxMask);
#endif

#ifdef __compile_SVGALIB
#ifdef	KEYBOARD
	if (keyboard_init())
		return	gfxERROR;
#endif
#endif

	return	gfxOK;
}

int keyGet( void )
{
	int	i;

#ifdef __compile_SVGALIB
#ifdef	KEYBOARD
	keyboard_update();
#endif
#endif

	for(i = 30; i < 74; i++)
		if (key[i].key && gKey(key[i].key))
		{
			if (gKey(keyS[2].key) || gKey(keyS[3].key))
			{
				if (keyCheck(i) == gfxOK)
				{
					keyAdd(i);
					return	keyR[i+100].key;
				}
			}
			else
			{
				if (keyCheck(i) == gfxOK)
				{
					keyAdd(i);
					return	keyR[i].key;
				}
			}
		}
		else
			keyDel(i);

	for(i = 0; i < 6; i++)
		if (gKey(key[i].key))
		{
			if (keyCheck(i) == gfxOK)
			{
				keyAdd(i);
				return	keyR[i].key;
			}
		}
		else
			keyDel(i);

	for(i = 6; i < 14; i++)
		if (gKey(key[i].key))
			return	keyR[i].key;

	for(i = 15; i < 21; i++)
		if (gKey(key[i].key))
		{
			if (keyCheck(i) == gfxOK)
			{
				keyAdd(i);
				return	keyR[i].key;
			}
		}
		else
			keyDel(i);

	return	gfxERROR;
}

int keyGetSpc1( void )
{
	int	i;

#ifdef __compile_SVGALIB
#ifdef	KEYBOARD
	keyboard_update();
#endif
#endif

	for(i = 0; i < 14; i++)
		if (gKey(key[i].key))
		{
			if (keyCheck(i) == gfxOK)
			{
				keyAdd(i);
				return	keyR[i].key;
			}
		}
		else
			keyDel(i);

	return	gfxERROR;
}

int keyGetSpc2( void )
{
	int	i;

#ifdef __compile_SVGALIB
#ifdef	KEYBOARD
	keyboard_update();
#endif
#endif

	for(i = 0; i < 5; i++)
		if (gKey(key[i].key))
		{
			if (keyCheck(i) == gfxOK)
			{
				keyAdd(i);
				return	keyR[i].key;
			}
		}
		else
			keyDel(i);

	for(i = 30; i < 66; i++)
		if (gKey(key[i].key))
		{
			if (gKey(keyS[2].key) || gKey(keyS[3].key))
			{
				if (keyCheck(i) == gfxOK)
				{
					keyAdd(i);
					return	keyR[i+100].key;
				}
			}
			else
			{
				if (keyCheck(i) == gfxOK)
				{
					keyAdd(i);
					return	keyR[i].key;
				}
			}
		}
		else
			keyDel(i);

	return	gfxERROR;
}

void keyClose( void )
{
#ifdef __compile_X
	gfxMask %= ~KeyPressMask;
	XSelectInput(gfxDisplay, gfxWindow, gfxMask);
#endif

#ifdef __compile_SVGALIB
#ifdef	KEYBOARD
	keyboard_close();
#endif
#endif
}

static int findLetter( int letter )
{
	switch (toupper(letter))
	{
		case 'A':  return	1;
		case 'B':  return	2;
		case 'C':  return	3;
		case 'D':  return	4;
		case 'E':  return	5;
		case 'F':  return	6;
		case 'G':  return	7;
		case 'H':  return	8;
		case 'I':  return	9;
		case 'J':  return	10;
		case 'K':  return	11;
		case 'L':  return	12;
		case 'M':  return	13;
		case 'N':  return	14;
		case 'O':  return	15;
		case 'P':  return	16;
		case 'Q':  return	17;
		case 'R':  return	18;
		case 'S':  return	19;
		case 'T':  return	20;
		case 'U':  return	21;
		case 'V':  return	22;
		case 'W':  return	23;
		case 'X':  return	24;
		case 'Y':  return	25;
		case 'Z':  return	26;
		case '1':  return	27;
		case '2':  return	28;
		case '3':  return	29;
		case '4':  return	30;
		case '5':  return	31;
		case '6':  return	32;
		case '7':  return	33;
		case '8':  return	34;
		case '9':  return	35;
		case '0':  return	36;
		case '!':  return	37;
		case '.':  return	38;
		case ',':  return	39;
		case ' ':  return	40;
		case '(':  return	41;
		case ')':  return	42;
		case '\'': return	43;
		case ':':  return	44;
		case '@':  return	45;
		case '#':  return	46;
		case '$':  return	47;
		case '%':  return	48;
		case '^':  return	49;
		case '&':  return	50;
		case '*':  return	51;
		case '/':  return	52;
		case '\\': return	53;
		case '?':  return	54;
		case ';':  return	55;
		case '-':  return	56;
		case '_':  return	57;
		case '=':  return	58;
		case '+':  return	59;
		case '|':  return	60;
		case '[':  return	61;
		case ']':  return	62;
	}

	return	-1;
}

static void printLetter( int X, int Y, spriteStruct *sprite, int C )
{
	int	x, y, offset = 0;

	for(y = 0; y < sprite->height; y++, offset += sprite->width)
		for(x = 0; x < sprite->width; x++)
			if (sprite->image[offset + x])
				gfxPixel(X+x, Y+y, C);
}

void printLetters( int X, int Y, char *text, int C )
{
	int	i, r, newx = 0;

	for(i = 0; i < strlen(text); i++)
		if ((r = findLetter(text[i])) != -1)
		{
			printLetter(X + newx, Y, &font[r - 1], C);
			newx += font[r - 1].width + 1;
		}
}

int totalLetters( char *text )
{
	int	i, r, total = 0;

	for(i = 0; i < strlen(text); i++)
		if ((r = findLetter(text[i])) != -1)
			total += font[r - 1].width + 1;

	return	total;
}

void loadFont( char *filename )
{
	FILE	*fd;
	int	i;
	short	x, y;

	if ((fd = openDataFile(filename)) == NULL)
	{
		printf("ERROR: Unable to open data file [%s].\n", filename);
		gfxClose();
	}

	for(i = 1; i < 63; i++)
	{
		if (!findDataFile(fd, 2, i))
		{
			printf("ERROR: In-valid font [id=2,%i], please report.\n", i);
			gfxClose();
		}

		fread(&x, 2, 1, fd);
		fread(&y, 2, 1, fd);

		if ((font[i - 1].image = (u_char *)malloc(x * y)) == NULL)
		{
			printf("ERROR: Not enough memory for fonts.\n");
			gfxClose();
		}

		font[i - 1].pri	 	= 1;
		font[i - 1].width	= x;
		font[i - 1].height	= y;

		if (!fread(font[i - 1].image, (x * y), 1, fd))
		{
			printf("ERROR: Cannot read font.\n");
			gfxClose();
		}
	}

	closeDataFile(fd);
}
