#ifndef	__GRAPHICS_H_
#define	__GRAPHICS_H_
					/* Includes			*/
#ifdef __compile_X
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#endif
#ifdef __compile_SVGALIB
#include <vga.h>			/* Svgalib main stuff		*/
#include <vgagl.h>			/* Svgalib extended stuff	*/
#endif
#include <stdio.h>			/* Standard IO routines		*/
#include <stdlib.h>			/* Standard LIB routines	*/
#include <string.h>			/* Misc string routines		*/
#include <unistd.h>

					/* Defines			*/
#define	gfxOK		1		/* For routines returning GOOD	*/
#define	gfxERROR	0		/* For routines returning FAIL	*/
#define	gfxVIDEO	5		/* Video mode 320x200 256 color */
#define	gfxTEXT		0		/* Text mode 80x25		*/
#define	gfxX		320		/* Video mode is X big		*/
#define	gfxY		200		/* Video mode is Y big		*/
#define	gfxBig		64000		/* How big is whole screen	*/
					/* Structures			*/
typedef struct {			/* Palette structure		*/
	struct {			/* Palette.color structure	*/
		unsigned char red;	/* Red of RGB color scheme	*/
		unsigned char green;	/* Green of RGB color scheme	*/
		unsigned char blue;	/* Blue of RGB color scheme	*/
	} color[256];			/* Palette.color structure	*/
} gfxPalette;				/* Palette structure		*/
struct bg_save {
	u_char	data[gfxBig];
	int	X;
	int	Y;
	int	width;
	int	height;
};
struct bg_save	BG;
					/* Variables			*/
unsigned char	*VB,			/* Video buffer			*/
		BACKGROUND[gfxBig];	/* Background Default Screen	*/

#ifdef __compile_X
Display*	gfxDisplay;
int		gfxScreen;
Window		gfxWindow;
Colormap	gfxColormap;
GC		gfxGc;
long		gfxMask;
XImage		*gfxImage;
#endif
#ifdef __compile_SVGALIB
GraphicsContext	*SCREEN;		/* Graphics screen for svgalib	*/
#endif

					/* Prototypes			*/
void gfxSetVideoMode( int );		/* Set video mode		*/
void gfxSetScreen( void );		/* Seup virtual screens		*/
void gfxClearScreen( void );		/* Clear virtual screen		*/
void gfxShowScreen( void );		/* Copy virtual screen		*/
int  gfxLoadPalette( char * );		/* Load palette file and set	*/
int  gfxSavePalette( char * );		/* Save palette			*/
void gfxSetPalette( gfxPalette * );	/* Set palette into video	*/
void gfxInit( void );			/* Video initization		*/
void gfxClose( void );			/* Reset video to text, etc	*/
void gfxPixel( int, int, int );		/* Plot a single pixel		*/
					/* Show a sprite		*/
void gfxHLine( int, int, int, int );	/* Draw a line			*/
void gfxVLine( int, int, int, int );	/* Draw a line			*/
void gfxBox( int, int, int, int, int );	/* Draw a box			*/
void gfxSaveBack( int, int, int, int );
void gfxDimBack( int );
void gfxPutBack( void );
void gfxPutBackBox( void );
void gfxSaveScreen( void );
void gfxDimBox( int, int, int, int, int );

#endif
