#include "graphics.h"

void gfxSetVideoMode( int mode )
{
#ifdef	__compile_X
	XEvent			event;
	XGCValues		gcvals;
	XSizeHints		sh;
	XSetWindowAttributes	winattr;
	u_long			gcvmask	= 0;
	char			*nam[2];

	if ((gfxDisplay = XOpenDisplay(NULL)) == NULL)
	{
		printf("ERROR: Unable to open X display.\n");
		exit(0);
	}

	gfxScreen = DefaultScreen(gfxDisplay);

	gcvals.graphics_exposures	= 0;
	gcvmask = GCGraphicsExposures;

	gfxGc = XCreateGC(gfxDisplay, RootWindow(gfxDisplay, gfxScreen),
		gcvmask, &gcvals);

	winattr.backing_store	= WhenMapped;
	winattr.save_under	= True;
	winattr.border_pixel	= 1;

	gfxWindow = XCreateWindow(gfxDisplay,
		RootWindow(gfxDisplay, gfxScreen),
		0, 0, gfxX, gfxY, 0, 8,
		InputOutput, None,
		None, &winattr);

	gfxColormap = XCreateColormap(gfxDisplay, gfxWindow,
		DefaultVisual(gfxDisplay, gfxScreen), AllocAll);

	XSetWindowColormap(gfxDisplay, gfxWindow, gfxColormap);
	XSetWMColormapWindows(gfxDisplay, gfxWindow, NULL, 0);

	nam[0] = "Unholy Knights";
	nam[1] = NULL;

	sh.width = sh.min_width = sh.max_width = gfxX;
	sh.height = sh.min_height = sh.max_height = gfxY;
	sh.flags |= (PSize|USSize|PMinSize|PMaxSize);

	XSetStandardProperties(gfxDisplay, gfxWindow,
		"Unholy Knights", "Unholy Knights",
		None, nam, 1, &sh);

	XSelectInput(gfxDisplay, gfxWindow,
		StructureNotifyMask|ExposureMask);

	event.type = 0;

	XMapWindow(gfxDisplay, gfxWindow);

	XFlush(gfxDisplay);

	do {
		XWindowEvent(gfxDisplay, gfxWindow,
			StructureNotifyMask, &event);
	} while(event.type != MapNotify);

	XSelectInput(gfxDisplay, gfxWindow, NoEventMask);
	XFlush(gfxDisplay);
#endif

#ifdef	__compile_SVGALIB
	vga_setmode(mode);
#endif
}

void gfxSetScreen( void )
{
#ifdef __compile_X
	if ((gfxImage = (XImage *)malloc(sizeof(XImage))) == NULL)
	{
		printf("ERROR: Couldn't allocate memory for image map.\n");
		exit(0);
	}
	gfxImage = XCreateImage(gfxDisplay,
		DefaultVisual(gfxDisplay, gfxScreen), 8, ZPixmap, 0,
		VB, gfxX, gfxY, 8, gfxX);
#endif
#ifdef __compile_SVGALIB
	gl_setcontextvga(gfxVIDEO);
	SCREEN = gl_allocatecontext();
	gl_getcontext(SCREEN);
	gl_setcontext(SCREEN);

	memset(VB, 0, gfxBig);
	memset(BACKGROUND, 0, gfxBig);
#endif
}

void gfxClearScreen( void )
{
	memcpy(VB, BACKGROUND, gfxBig);
}

void gfxShowScreen( void )
{
#ifdef __compile_X
	memcpy(gfxImage->data, VB, gfxBig);
	XPutImage(gfxDisplay, gfxWindow, gfxGc, gfxImage,
		0, 0, 0, 0, gfxX, gfxY);

	XFlush(gfxDisplay);
#endif

#ifdef __compile_SVGALIB
	memcpy(VBUF, VB, gfxBig);
	gl_copyscreen(SCREEN);
#endif
}

int gfxLoadPalette( char *filename )
{
	FILE		*fto;
	int		i;
	gfxPalette	pal;

	if ((fto = fopen(filename, "r")) == NULL)
		return	gfxERROR;

	for (i = 0; i < 256; i++)
	{
#ifdef __compile_X
		pal.color[i].red	= fgetc(fto);
		pal.color[i].green	= fgetc(fto);
		pal.color[i].blue	= fgetc(fto);
#endif
#ifdef __compile_SVGALIB
		pal.color[i].red	= fgetc(fto) >> 2;
		pal.color[i].green	= fgetc(fto) >> 2;
		pal.color[i].blue	= fgetc(fto) >> 2;
#endif
	}

	gfxSetPalette(&pal);

	return	gfxOK;
}

void gfxSetPalette( gfxPalette *pal )
{
#ifdef __compile_X
	XColor	gfxCol;
	int	i;

	gfxCol.flags = DoRed | DoGreen | DoBlue;

	for (i = 0; i < 256; i++)
	{
		gfxCol.pixel = i;
		gfxCol.red = (pal->color[i].red << 8) | pal->color[i].red;
		gfxCol.blue = (pal->color[i].blue << 8) | pal->color[i].blue;
		gfxCol.green = (pal->color[i].green << 8) | pal->color[i].green;


		XStoreColor(gfxDisplay, gfxColormap, &gfxCol);
		XFlush(gfxDisplay);
	}
#endif

#ifdef __compile_SVGALIB
	gl_setpalette(pal);
#endif
}

void gfxInit( void )
{
#ifdef __compile_SVGALIB
	vga_init();
#endif
}

void gfxClose( void )
{
#ifdef __compile_X
	XDestroyWindow(gfxDisplay, gfxWindow);
	XFreeGC(gfxDisplay, gfxGc);
	XFreeColormap(gfxDisplay, gfxColormap);
	XCloseDisplay(gfxDisplay);
	XFree(gfxImage);
	exit(0);
#endif

#ifdef __compile_SVGALIB
	gfxSetVideoMode(gfxTEXT);
	printf("\n");
	exit(0);
#endif
}	

void gfxPixel( int X, int Y, int C )
{
	if (Y >= gfxY || Y < 0 || X >= gfxX || X < 0)
		return;

	VB[((Y<<8) + (Y<<6)) + X] = C;
}

void gfxHLine( int X, int X2, int Y, int C )
{
	memset(VB+(((Y<<8) + (Y<<6)) + X), C, X2 - X + 1);
}

void gfxVLine( int X, int Y, int Y2, int C )
{
	int	i;

	for(i = 0; i < (Y2 - Y); i++)
		VB[((Y+i)<<8)+((Y+i)<<6) + X] = C;
}

void gfxBox( int X, int X2, int Y, int Y2, int C )
{
	int	i;

	for(i = Y; i < Y2; i++)
		gfxHLine(X, X2, i, C);
}

void gfxSaveBack( int X, int Y, int width, int height )
{
	int	i, j;

	memset(BG.data, 0, gfxBig);

	for(i = 0; i < height; i++)
		for(j = 0; j < width; j++)
			BG.data[(i * width) + j] = VB[((Y+i)*gfxX)+X+j];

	BG.X		= X;
	BG.Y		= Y;
	BG.width	= width;
	BG.height	= height; 
}

void gfxDimBack( int dim )
{
	int	i;

	for(i = 0; i < gfxBig; i++)
		if (BG.data[i] > 0)
			BG.data[i] -= dim;
}

void gfxPutBack( void )
{
	int	i, j;

	for(i = 0; i < BG.height; i++)
		for(j = 0; j < BG.width; j++)
			VB[((BG.Y+i)*gfxX)+BG.X+j] = BG.data[(i*BG.width)+j];
}

void gfxPutBackBox( void )
{
	int	i, j;

	for(i = 0; i < BG.height; i++)
		for(j = 0; j < BG.width; j++)
			VB[((BG.Y+i)*gfxX)+BG.X+j] = BG.data[(i*BG.width)+j];

	gfxHLine(BG.X, BG.X+(BG.width-1), BG.Y, 107);
	gfxHLine(BG.X, BG.X+(BG.width-1), BG.Y+(BG.height-1), 107);
	gfxVLine(BG.X, BG.Y, BG.Y+(BG.height-1), 107);
	gfxVLine(BG.X+(BG.width-1), BG.Y, BG.Y+(BG.height-1), 107);
	gfxHLine(BG.X+1, BG.X+BG.width, BG.Y+BG.height, 0);
	gfxVLine(BG.X+BG.width, BG.Y+1, BG.Y+BG.height+1, 0);
}

void gfxDimBox( int X, int Y, int width, int height, int df )
{
	gfxSaveBack(X, Y, width, height);
	gfxDimBack(df);
	gfxPutBackBox();
}

void gfxSaveScreen( void )
{
	memcpy(BACKGROUND, VB, gfxBig);
}
