#include <stdio.h>

int packFont( char *filename, FILE *fd, int id )
{
	FILE	*fto;
	unsigned char	i, j;
	unsigned short	x, y;

	if ((fto = fopen(filename, "r")) == NULL)
	{
		printf("error packing %s!\n", filename);
		return	0;
	}

	for(j = 0; j < 62; j++)
	{
		x = fgetc(fto);
		y = fgetc(fto);

		fputc(id, fd);
		fputc(j + 1, fd);
		fwrite(&x, 2, 1, fd);
		fwrite(&y, 2, 1, fd);

		for(i = 0; i < (x*y); i++)
			fputc((unsigned char)fgetc(fto), fd);
	}

	fclose(fto);

	return	1;
}

int packPalette( char *filename, FILE *fd )
{
	FILE	*fto;
	int	i;

	if ((fto = fopen(filename, "r")) == NULL)
	{
		printf("error packing %s!\n", filename);
		return	0;
	}

	for(i = 0; i < 768; i++)
		fputc((unsigned char)fgetc(fto), fd);

	fclose(fto);

	return	1;
}

int packFile( char *filename, FILE *fd, int id1, int id2, short X, short Y )
{
	FILE	*fto;
	int	i;

	if ((fto = fopen(filename, "r")) == NULL)
	{
		printf("error packing %s!\n", filename);
		return	0;
	}

	fputc(id1, fd);
	fputc(id2, fd);

	fwrite(&X, 2, 1, fd);
	fwrite(&Y, 2, 1, fd);

	for(i = 0; i < (X * Y); i++)
			fputc(fgetc(fto), fd);

	fclose(fto);

	return	1;
}

void main( int argc, char *argv[] )
{
	FILE	*fto;

	printf("Graphics-Pack version 1.0 - For use with Unholy Knights only.\n");

	if (argc != 2)
	{
		printf("usage: graphics-pack <filename>\n");
		exit(-1);
	}

	printf("Creating: %s\n", argv[1]);

	if ((fto = fopen(argv[1], "w")) == NULL)
	{
		printf("Unable to open %s for output.\n", argv[1]);
		exit(-1);
	}

	printf("Packing: Palette, "); fflush(stdout);
	if (!packPalette("../graphics/palette.data", fto))
		exit(-1);
	printf("completed.\n");

	printf("Packing: Backgrounds, "); fflush(stdout);
	if (!packFile("../graphics/login.bg", fto, 1, 1, 320, 200))
		exit(-1);
	printf("completed.\n");

	printf("Packing: Font, "); fflush(stdout);
	if (!packFont("../graphics/font.data", fto, 2))
		exit(-1);
	printf("completed.\n");

	printf("Packing: Fighter Graphics, "); fflush(stdout);
	if (!packFile("../graphics/fight01.raw", fto, 10,   1, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight02.raw", fto, 10,   2, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight03.raw", fto, 10,   3, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight04.raw", fto, 10,   4, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight05.raw", fto, 10,   5, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight06.raw", fto, 10,   6, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight07.raw", fto, 10,   7, 16, 16)) exit(-1);
	if (!packFile("../graphics/fight08.raw", fto, 10,   8, 16, 16)) exit(-1);
	printf("completed.\n");

	printf("Packing: Priest Graphics, "); fflush(stdout);
	if (!packFile("../graphics/priest01.raw", fto, 10,  9, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest02.raw", fto, 10, 10, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest03.raw", fto, 10, 11, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest04.raw", fto, 10, 12, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest05.raw", fto, 10, 13, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest06.raw", fto, 10, 14, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest07.raw", fto, 10, 15, 16, 16)) exit(-1);
	if (!packFile("../graphics/priest08.raw", fto, 10, 16, 16, 16)) exit(-1);
	printf("completed.\n");

	printf("Packing: Land Graphics, "); fflush(stdout);
	if (!packFile("../graphics/spr001.raw", fto, 30,  1, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr002.raw", fto, 30,  2, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr003.raw", fto, 30,  3, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr004.raw", fto, 30,  4, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr005.raw", fto, 30,  5, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr006.raw", fto, 30,  6, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr007.raw", fto, 30,  7, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr008.raw", fto, 30,  8, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr009.raw", fto, 30,  9, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr010.raw", fto, 30, 10, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr011.raw", fto, 30, 11, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr012.raw", fto, 30, 12, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr013.raw", fto, 30, 13, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr014.raw", fto, 30, 14, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr015.raw", fto, 30, 15, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr016.raw", fto, 30, 16, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr017.raw", fto, 30, 17, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr018.raw", fto, 30, 18, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr019.raw", fto, 30, 19, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr020.raw", fto, 30, 20, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr021.raw", fto, 30, 21, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr022.raw", fto, 30, 22, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr023.raw", fto, 30, 23, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr024.raw", fto, 30, 24, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr025.raw", fto, 30, 25, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr026.raw", fto, 30, 26, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr027.raw", fto, 30, 27, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr028.raw", fto, 30, 28, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr029.raw", fto, 30, 29, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr030.raw", fto, 30, 30, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr031.raw", fto, 30, 31, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr032.raw", fto, 30, 32, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr033.raw", fto, 30, 33, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr034.raw", fto, 30, 34, 16, 16)) exit(-1);
	if (!packFile("../graphics/spr035.raw", fto, 30, 35, 16, 16)) exit(-1);
	printf("completed.\n");

	printf("Packing: Box Graphics, "); fflush(stdout);
	if (!packFile("../graphics/box01.raw", fto, 29,  1, 4, 4)) exit(-1);
	if (!packFile("../graphics/box02.raw", fto, 29,  2, 4, 4)) exit(-1);
	if (!packFile("../graphics/box03.raw", fto, 29,  3, 4, 4)) exit(-1);
	if (!packFile("../graphics/box04.raw", fto, 29,  4, 4, 4)) exit(-1);
	if (!packFile("../graphics/box05.raw", fto, 29,  5, 4, 4)) exit(-1);
	if (!packFile("../graphics/box06.raw", fto, 29,  6, 4, 4)) exit(-1);
	if (!packFile("../graphics/box07.raw", fto, 29,  7, 4, 4)) exit(-1);
	if (!packFile("../graphics/box08.raw", fto, 29,  8, 4, 4)) exit(-1);
	if (!packFile("../graphics/box09.raw", fto, 29,  9, 6, 6)) exit(-1);
	if (!packFile("../graphics/box10.raw", fto, 29, 10, 6, 6)) exit(-1);
	if (!packFile("../graphics/box11.raw", fto, 29, 11, 5, 4)) exit(-1);
	if (!packFile("../graphics/box12.raw", fto, 29, 12, 5, 4)) exit(-1);
	if (!packFile("../graphics/box13.raw", fto, 29, 13, 3, 4)) exit(-1);
	if (!packFile("../graphics/box14.raw", fto, 29, 14, 16, 16)) exit(-1);
	printf("completed.\n");

	printf("Packing: Menu Graphics, "); fflush(stdout);
	if (!packFile("../graphics/menu.raw", fto, 35,  1, 270, 160)) exit(-1);
	if (!packFile("../graphics/button.raw", fto, 35,  2, 44, 13)) exit(-1);
	printf("completed.\n");

	printf("Packing: Spc Graphics, "); fflush(stdout);
	if (!packFile("../graphics/spc01.raw", fto, 28, 1, 320, 200)) exit(-1);
	printf("completed.\n");

	printf("Packing Finished.\n");
	fclose(fto);

	exit(0);
}
