#include "client.h"

void drawServerScreen( void )
{
	int	k, cnt = 0;

	gfxDimBox(20, 20, 280, 165, 2);

	gfxHLine(27, 42, 34, 57);
	gfxHLine(47, 246, 34, 57);
	gfxHLine(251, 292, 34, 57);

	sprintf(TEMP_CRAP, "#");
	printLetters(30, 25, TEMP_CRAP, 110);
	sprintf(TEMP_CRAP, "Server Name");
	printLetters(50, 25, TEMP_CRAP, 110);
	sprintf(TEMP_CRAP, "Players");
	printLetters(253, 25, TEMP_CRAP, 110);

	for(k = 0; k < 19; k++)
		if (trk[k].port != 0)
		{
			sprintf(TEMP_CRAP, "%-3i",
				cnt+1);
			printLetters(30, 40+(8*cnt), TEMP_CRAP, 60);

			sprintf(TEMP_CRAP, "%-40s",
				trk[k].name);
			printLetters(50, 40+(8*cnt), TEMP_CRAP, 60);

			sprintf(TEMP_CRAP, "%3i",
				trk[k].cli);
			printLetters(253, 40+(8*cnt), TEMP_CRAP, 60);
			sprintf(TEMP_CRAP, "/");
			printLetters(270, 40+(8*cnt), TEMP_CRAP, 60);
			sprintf(TEMP_CRAP, "%3i",
				trk[k].mcli);
			printLetters(277, 40+(8*cnt), TEMP_CRAP, 60);

			cnt++;
		}

	if (cnt == 0)
	{
		sprintf(TEMP_CRAP, "No Servers Found");
		printLetters(30, 40, TEMP_CRAP, 63);
	}

	sprintf(TEMP_CRAP, "Use cursor keys. Escape to Exit. Enter to connect.");
	printLetters(160-(totalLetters(TEMP_CRAP)/2), 191, TEMP_CRAP, 110);
}

void drawBar( int num )
{
	gfxClearScreen();
	drawServerScreen();
	gfxSaveBack(25, 39+((num-1) * 8), 270, 7);
	gfxDimBack(-3);
	gfxPutBack();
	gfxShowScreen();
}

void drawLoginScreen( char *name, char *pass, int selected, int current )
{
	gfxClearScreen();
	gfxDimBox(49, 75, 220, 49, 2);

	printLetters(59, 85, "Create new account? [  ]", 105);

	printLetters(59, 98, "ID Login", 105);
	printLetters(130, 98, "(                        )", 105);
	printLetters(133, 98, name, 57);
	printLetters(59, 105, "ID Password", 105);
	printLetters(130, 105, "(                        )", 105);
	printLetters(133, 105, pass, 57);

	sprintf(TEMP_CRAP, "TAB TO SWITCH FIELDS. ENTER TO LOGIN.");
	printLetters(161-(totalLetters(TEMP_CRAP)/2), 131, TEMP_CRAP, 0);
	printLetters(160-(totalLetters(TEMP_CRAP)/2), 130, TEMP_CRAP, 110);

	sprintf(TEMP_CRAP, "NOTE: To create a new UK ID, press the 'Y'");
	printLetters(161-(totalLetters(TEMP_CRAP)/2), 55, TEMP_CRAP, 0);
	printLetters(160-(totalLetters(TEMP_CRAP)/2), 54, TEMP_CRAP, 62);
	sprintf(TEMP_CRAP, "key at the 'create new account' prompt.");
	printLetters(161-(totalLetters(TEMP_CRAP)/2), 64, TEMP_CRAP, 0);
	printLetters(160-(totalLetters(TEMP_CRAP)/2), 63, TEMP_CRAP, 62);

	switch(current)
	{
	case 1:
		printLetters(59, 85, "Create new account? [  ]", 110);
		printLetters(166, 85, "__", 61);
		break;
	case 2:
		printLetters(59, 98, "ID Login", 110);
		printLetters(130, 98, "(                        )", 110);
		printLetters(133, 98, name, 62);
		break;
	case 3:
		printLetters(59, 105, "ID Password", 110);
		printLetters(130, 105, "(                        )", 110);
		printLetters(133, 105, pass, 62);
		break;
	}

	if (selected && current != 1)
		printLetters(166, 85, "Y", 57);
	else if (current != 1)
		printLetters(166, 85, "N", 57);

	gfxShowScreen();
}

void drawCharacterScreen( int current )
{
	int	i;

	gfxClearScreen();
	gfxDimBox(10, 20, 140, 47, 2);

	for(i = 0; i < 5; i++)
		if (plr[i].active)
			printLetters(15, 25+(i*8), plr[i].name, 57);
		else
			printLetters(15, 25+(i*8), "No Character created", 57);

	gfxSaveBack(13, 24+((current-1) * 8), 134, 7);
	gfxDimBack(-4);
	gfxPutBack();

	if (plr[current-1].active)
	{
		gfxDimBox(159, 20, 150, 124, 2);
		showSpriteSpecial(165, 30, &classGfx[CLASS[plr[current-1].class].gfx],
			10, 15, 0);
		printLetters(185, 30, CLASS[plr[current-1].class].name, 111);
		printLetters(185, 38, plr[current-1].name, 62);
		printLetters(185, 46, plr[current-1].info, 62);

		printLetters(168, 57, "LVL", 57);
		sprintf(TEMP_CRAP, "%i", plr[current-1].level);
		printLetters(190, 57, TEMP_CRAP, 107);
		printLetters(168, 65, "EXP", 57);
		sprintf(TEMP_CRAP, "%07lu", plr[current-1].exp);
		printLetters(190, 65, TEMP_CRAP, 107);

		printLetters(168, 77, "HP", 57);
		sprintf(TEMP_CRAP, "%i/%i", plr[current-1].curhp, plr[current-1].hp);
		printLetters(190, 77, TEMP_CRAP, 107);
		printLetters(168, 84, "MP", 57);
		sprintf(TEMP_CRAP, "%i/%i", plr[current-1].curmp, plr[current-1].mp);
		printLetters(190, 84, TEMP_CRAP, 107);

		printLetters(168, 96, "STR", 57);
		sprintf(TEMP_CRAP, "%i", plr[current-1].str);
		printLetters(190, 96, TEMP_CRAP, 107);
		printLetters(168, 103, "DEF", 57);
		sprintf(TEMP_CRAP, "%i", plr[current-1].def);
		printLetters(190, 103, TEMP_CRAP, 107);
		printLetters(168, 110, "MAG", 57);
		sprintf(TEMP_CRAP, "%i", plr[current-1].mag);
		printLetters(190, 110, TEMP_CRAP, 107);
		printLetters(168, 117,"SPD", 57);
		sprintf(TEMP_CRAP, "%i", plr[current-1].spd);
		printLetters(190, 117, TEMP_CRAP, 107);

		if (plr[current-1].sysop)
			printLetters(168, 129, "Gamemaster Access", 13);
	}
	else
	{
		gfxDimBox(159, 20, 150, 23, 2);
		printLetters(164, 25, "Press enter to create", 62);
		printLetters(164, 33, "a new character.", 62);
	}

	sprintf(TEMP_CRAP, "USE CURSOR KEYS. ESCAPE TO DISCONNECT. ENTER TO SELECT.");
	printLetters(160-(totalLetters(TEMP_CRAP)/2), 189, TEMP_CRAP, 110);

	gfxShowScreen();
}

void drawCreateScreen( char *name, char *desc, int current, int ask )
{
	int	i;

	gfxClearScreen();
	gfxDimBox(10, 20, 140, 39, 2);

	if (ask == 1)
	{
		printLetters(15, 25, "Character name", 63);
		printLetters(15, 32, "(               )", 111);
		printLetters(18, 32, name, 63);
		printLetters(15, 40, "Character description", 57);
		printLetters(15, 48, "(                      )", 107);
		printLetters(18, 48, desc, 57);
	}
	else if (ask == 2)
	{
		printLetters(15, 25, "Character name", 57);
		printLetters(15, 32, "(               )", 107);
		printLetters(18, 32, name, 57);
		printLetters(15, 40, "Character description", 63);
		printLetters(15, 48, "(                      )", 111);
		printLetters(18, 48, desc, 63);
	}
	else if (ask == 3)
	{
		printLetters(15, 25, "Character name", 57);
		printLetters(15, 32, "(               )", 107);
		printLetters(18, 32, name, 57);
		printLetters(15, 40, "Character description", 57);
		printLetters(15, 48, "(                      )", 107);
		printLetters(18, 48, desc, 57);
	}

	if (ask == 2)
	{
	}
	else
	{
	}

	gfxDimBox(10, 70, 140, 21, 2);
	sprintf(TEMP_CRAP, "Choose class");
	printLetters(80-(totalLetters(TEMP_CRAP)/2), 78, TEMP_CRAP, 111);

	gfxDimBox(10, 90, 140, 87, 2);

	for(i = 0; i < 10; i++)
		if (CLASS[i].startHp)
			printLetters(15, 95+(i*8), CLASS[i].name, 57);
		else
			printLetters(15, 95+(i*8), "No Class available", 57);

	if (ask == 3)
	{
		gfxSaveBack(13, 94+((current-1) * 8), 134, 7);
		gfxDimBack(-4);
		gfxPutBack();
	}

	if (CLASS[current-1].startHp)
	{
		gfxDimBox(159, 70, 150, 107, 2);
		showSpriteSpecial(165, 80, &classGfx[CLASS[current-1].gfx],
			10, 15, 0);
		printLetters(185, 80, CLASS[current-1].name, 62);
		printLetters(185, 88, CLASS[current-1].desc, 62);

		printLetters(168, 105, "HP", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].startHp);
		printLetters(190, 105, TEMP_CRAP, 107);
		printLetters(168, 112, "MP", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].startMp);
		printLetters(190, 112, TEMP_CRAP, 107);

		printLetters(168, 124, "[STATS]", 10);
		printLetters(168, 134, "Starting", 63);
		printLetters(240, 134, "plus per lvl", 63);

		printLetters(168, 144, "STR", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].startStr);
		printLetters(190, 144, TEMP_CRAP, 107);
		printLetters(240, 144, "STR", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].incStr);
		printLetters(262, 144, TEMP_CRAP, 107);

		printLetters(168, 151, "DEF", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].startDef);
		printLetters(190, 151, TEMP_CRAP, 107);
		printLetters(240, 151, "DEF", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].incDef);
		printLetters(262, 151, TEMP_CRAP, 107);

		printLetters(168, 158, "MAG", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].startMag);
		printLetters(190, 158, TEMP_CRAP, 107);
		printLetters(240, 158, "MAG", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].incMag);
		printLetters(262, 158, TEMP_CRAP, 107);

		printLetters(168, 165,"SPD", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].startSpd);
		printLetters(190, 165, TEMP_CRAP, 107);
		printLetters(240, 165,"SPD", 57);
		sprintf(TEMP_CRAP, "%i", CLASS[current-1].incSpd);
		printLetters(262, 165, TEMP_CRAP, 107);
	}

	sprintf(TEMP_CRAP, "USE CURSOR KEYS. TAB TO CHANGE FIELDS. ENTER TO CREATE.");
	printLetters(160-(totalLetters(TEMP_CRAP)/2), 189, TEMP_CRAP, 110);

	gfxShowScreen();
}
