#ifndef	CLIENT_H__
#define	CLIENT_H__

#include "graphics.h"
#include "mouse.h"
#include <stdio.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <netinet/in.h>
#include <ctype.h>
#include <signal.h>
#include <vgakeyboard.h>

#include "/home/devel/UnholyKnights-CommonSource/pkt_code.h"
#include "/home/devel/UnholyKnights-CommonSource/armor.h"
#include "/home/devel/UnholyKnights-CommonSource/helm.h"
#include "/home/devel/UnholyKnights-CommonSource/class.h"
#include "/home/devel/UnholyKnights-CommonSource/land.h"
#include "/home/devel/UnholyKnights-CommonSource/spell.h"
#include "/home/devel/UnholyKnights-CommonSource/npc.h"

#define	KEYBOARD
#define	CONFFILE	"uk.conf"
#define	DATAFILE	"uk.data"
#define	MAPFILE		"uk.mapdata"

#define	CHK_LAND	1
#define	CHK_CLASS	2
#define	CHK_PLR		3
#define	CHK_ARMOR	4
#define	CHK_HELM	5
#define	CHK_SPELL	6
#define	CHK_LOGIN	7
#define	CHK_CREATE	8

#define	MAXMONS		255

char	TEMP_CRAP[64000],
	TRK_IP[20],
	PCH_IP[20],
	spcGfx1[64000],
	savedBG[64000],
	NpcTalk[10][100];
int	TRK_PORT,
	TRK_SOCK,
	PCH_PORT,
	PCH_SOCK,
	CLI_ID,
	CLI_SOCK,
	pL, pX, pY,
	CURRENTX,
	CURRENTY,
	SYSOP,
	CURRENTMP,
	CURRENTHP,
	CH,
	DEBUG,
	cur_X,
	cur_Y,
	MOUSE_PRESENT, MOUSE_X, MOUSE_Y, MOUSE_B,
	CMN_MODE,
	CMN_CLASS,
	NpcCount;
short	CURRENTMAP,
	mapData[(MAPM_X+MAP_X+1) * (MAPM_Y+MAP_Y+1)];
long	TEMP_CNT;

fd_set	readFds;
FILE	*temp_fd;

typedef struct {
	char	name[13];
	char	info[20];
	int	class;
	int	str;
	int	def;
	int	mag;
	int	spd;
	int	hp;
	int	curhp;
	int	mp;
	int	curmp;
	int	level;
	long	exp;
	int	armor;
	int	helm;
	int	sysop;
	int	active;
} playerStatus;

typedef struct {
	char	name[13];
	int	class;
	int	posX;
	int	posY;
	int	level;
	int	armor;
	int	helm;
	int	active;
	int	facing;
} charStruct;

typedef struct {
	long	key;
} keyboardStruct;

typedef struct {
	short		height;
	short		width;
	int		pri;
	unsigned char	*image;
} spriteStruct;

typedef struct {
	char	name[40];
	char	ip[20];
	int	port;
	int	cli;
	int	mcli;
} trackingStruct;

typedef struct {
	char	name[20];
	char	realname[50];
	long	size;
} patchStruct;

typedef struct {
	char	text[100];
	int	color;
} infoStruct;

typedef struct {
	char	name[15];
	int	gfx;
	int	armor;
	int	helm;
	int	posX;
	int	posY;
	int	level;
	int	facing;
} npcMStruct;

typedef struct {
	int	gfx;
	int	color;
	int	posX;
	int	posY;
	int	active;
	int	facing;
	int	hitCount;
	int	hitType;
} monStruct;

keyboardStruct	key[100],
		keyS[10],
		keyR[200],
		keyH[100];
spriteStruct	font[62],
		classGfx[CLASSCNT * 8],
		landGfx[numLand],
		boxGfx[14],
		menuGfx[1];
trackingStruct	trk[255];
patchStruct	pch[20];
playerStatus	plr[5];
infoStruct	CHAT[4],
		INFO[13];
charStruct	CHAR[255];
npcMStruct	npc[NPCCNT];
monStruct	MONSTER[MAXMONS];

/* client.c */
void getNext( char *, char * );
void statusBox( char * );
int  recieveStuff( int );

/* sprite.c */
void showSprite( spriteStruct *, int, int );
void showSpriteHit( spriteStruct *, int, int, int );
void showSpriteTransparent( spriteStruct *, int, int );
void showSpriteBlank( int, int );
void showSpriteSpecial( int, int, spriteStruct *, int, int, int );
int  setBackGround( char *, int );
void loadSprites( void );
void loadBox( void );
void loadSpc( void );
void loadLand( char * );
void loadMenu( void );

/* keyboard.c */
int  keyInit( void );
int  keyOpen( void );
int  keyGet( void );
int  keyGetSpc1( void );
int  keyGetSpc2( void );
void keyClose( void );
void printLetters( int, int, char *, int );
int  totalLetters( char * );
void loadFont( char * );

/* io.c */
FILE *openDataFile( char * );
int  findDataFile( FILE *, int, int );
void closeDataFile( FILE * );
int  readConfig( void );
void dumpScreen( void );
int  loadMap( short );

/* socket.c */
void sockSend( int, char *, ... );
int  sockRead( int, char * );
int  sockReadReady( int );
void sockClose( int );
int  sockConnect( char *, int );
int  connectTracker( void );
int  recieveTracker( void );
void disconnectTracker( void );
int  connectPatch( void );
int  recievePatch( void );
void disconnectPatch( void );
int  connectServer( void );

/* process.c */
void processLogin( void );
int  chooseServer( void );
int  chooseCharacter( void );
int  chooseCreate( void );

/* mainprocess.c */
void mainProcess( int );

/* draw.c */
void drawServerScreen( void );
void drawBar( int );
void drawLoginScreen( char *, char *, int, int );
void drawCharacterScreen( int );
void drawCreateScreen( char *, char *, int, int );

#ifndef KEYBOARD
int  gKey( int );
#endif

#endif
