#include "client.h"

void getNext( char *buf, char *buf2 )
{
	int	i;

	memset(buf2, 0, sizeof(buf2));

	for(i = 0; i < strlen(buf); i++)
		if (buf[i] != ';')
			buf2[i] = buf[i];
		else
		{
			buf2[i] = 0;
			strcpy(buf, buf+i+1);
			return;
		}

	buf[i+1] = 0;
}

void statusBox( char *text )
{
	int	i;

	i = totalLetters(text);
	gfxDimBox(140 - (i/2), 79, i + 40, 40, 2);
	printLetters(160 - (i/2), 96, text, 63);
}

static void mainInit( void )
{
	int	i;

	for(i = 0; i < 255; i++)
		trk[i].port = 0;

	for(i = 0; i < 20; i++)
		pch[i].size = 0;

	for(i = 0; i < 4; i++)
	{
		memset(CHAT[i].text, 0, 100);
		CHAT[i].color = 0;
	}

	for(i = 0; i < NPCCNT; i++)
	{
		memset(npc[i].name, 0, 15);
		npc[i].gfx	= 0;
		npc[i].armor	= 0;
		npc[i].helm	= 0;
		npc[i].posX	= -1;
		npc[i].posY	= -1;
		npc[i].level	= 0;
	}

	for(i = 0; i < 5; i++)
	{
		memset(plr[i].name, 0, 13);
		memset(plr[i].info, 0, 20);
		plr[i].class	= 0;
		plr[i].str	= 0;
		plr[i].def	= 0;
		plr[i].mag	= 0;
		plr[i].spd	= 0;
		plr[i].hp	= 0;
		plr[i].curhp	= 0;
		plr[i].mp	= 0;
		plr[i].curmp	= 0;
		plr[i].level	= 0;
		plr[i].exp	= 0;
		plr[i].armor	= 0;
		plr[i].helm	= 0;
		plr[i].sysop	= 0;
		plr[i].active	= 0;
	}

	for(i = 0; i < 255; i++)
	{
		memset(CHAR[i].name, 0, 13);
		CHAR[i].class	= 0;
		CHAR[i].posX	= 0;
		CHAR[i].posY	= 0;
		CHAR[i].level	= 0;
		CHAR[i].armor	= 0;
		CHAR[i].helm	= 0;
		CHAR[i].active	= 0;
		CHAR[i].facing	= 0;
	}

	for(i = 0; i < MAXMONS; i++)
		MONSTER[i].active = 0;

	CLI_ID		= -1;
	CLI_SOCK	= -1;
	CURRENTX	= 0;
	CURRENTY	= 0;
	CURRENTHP	= 0;
	CURRENTMP	= 0;
	CURRENTMAP	= 0;
	SYSOP		= 0;
	DEBUG		= 0;
	MOUSE_PRESENT	= 0;
}

int processStuff( char *buf )
{
	char	tmpbuf[512];
	int	r;

	getNext(buf, tmpbuf);
	r = atoi(tmpbuf);

	switch(r)
	{
	case PKT_CLS:
		getNext(buf, tmpbuf); r = atoi(tmpbuf);
		getNext(buf, CLASS[r].name);
		getNext(buf, CLASS[r].desc);
		getNext(buf, tmpbuf); CLASS[r].gfx = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].startHp = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].startMp = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].startStr = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].startDef = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].startMag = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].startSpd = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].incStr = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].incDef = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].incMag = atoi(tmpbuf);
		getNext(buf, tmpbuf); CLASS[r].incSpd = atoi(tmpbuf);
		return	PKT_CON;
		break;
	case PKT_LND:
		getNext(buf, tmpbuf); r = atoi(tmpbuf);
		getNext(buf, tmpbuf); landType[r].type = atoi(tmpbuf);
		return	PKT_CON;
		break;
	case PKT_CRT:
		getNext(buf, tmpbuf);
		return	atoi(tmpbuf);
		break;
	case PKT_NEW:
		getNext(buf, tmpbuf);
		return	atoi(tmpbuf);
		break;
	case PKT_LGN:
		getNext(buf, tmpbuf);
		return	atoi(tmpbuf);
		break;
	case PKT_ARM:
		getNext(buf, tmpbuf); r = atoi(tmpbuf);
		getNext(buf, ARMORS[r].name);
		getNext(buf, tmpbuf); ARMORS[r].color = atoi(tmpbuf);
		getNext(buf, tmpbuf); ARMORS[r].ac = atoi(tmpbuf);
		return	PKT_CON;
		break;
	case PKT_HLM:
		getNext(buf, tmpbuf); r = atoi(tmpbuf);
		getNext(buf, HELMS[r].name);
		getNext(buf, tmpbuf); HELMS[r].color = atoi(tmpbuf);
		getNext(buf, tmpbuf); HELMS[r].ac = atoi(tmpbuf);
		return	PKT_CON;
		break;
	case PKT_SPL:
		getNext(buf, tmpbuf); r = atoi(tmpbuf);
		getNext(buf, SPELLS[r].name);
		getNext(buf, tmpbuf); SPELLS[r].type = atoi(tmpbuf);
		getNext(buf, tmpbuf); SPELLS[r].effect = atoi(tmpbuf);
		getNext(buf, tmpbuf); SPELLS[r].modifier = atoi(tmpbuf);
		getNext(buf, tmpbuf); SPELLS[r].class = atoi(tmpbuf);
		getNext(buf, tmpbuf); SPELLS[r].battleonly = atoi(tmpbuf);
		getNext(buf, tmpbuf); SPELLS[r].gfx = atoi(tmpbuf);
		getNext(buf, tmpbuf); SPELLS[r].mana = atoi(tmpbuf);
		return	PKT_CON;
		break;
	case PKT_PLT:
		getNext(buf, tmpbuf); r = atoi(tmpbuf);
		getNext(buf, plr[r].name);
		getNext(buf, plr[r].info);
		getNext(buf, tmpbuf); plr[r].class = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].str = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].def = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].mag = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].spd = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].hp = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].curhp = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].mp = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].curmp = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].level = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].exp = atol(tmpbuf);
		getNext(buf, tmpbuf); plr[r].armor = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].helm = atoi(tmpbuf);
		getNext(buf, tmpbuf); plr[r].sysop = atoi(tmpbuf);
		plr[r].active = 1;
		return	PKT_CON;
		break;
	case PKT_OK:
		return	PKT_OK;
		break;
	case PKT_KIL:
		printf("%s\n", buf);
		return	PKT_KIL;
		break;
	}

	return	0;
}

int recieveStuff( int type )
{
	char	tmpbuf[1024];
	int	r;

	if (type == CHK_CLASS)
		sockSend(CLI_SOCK, "%i", PKT_CLS);
	else if (type == CHK_LAND)
		sockSend(CLI_SOCK, "%i", PKT_LND);
	else if (type == CHK_PLR)
		sockSend(CLI_SOCK, "%i", PKT_PLT);
	else if (type == CHK_SPELL)
		sockSend(CLI_SOCK, "%i", PKT_SPL);
	else if (type == CHK_ARMOR)
		sockSend(CLI_SOCK, "%i", PKT_ARM);
	else if (type == CHK_HELM)
		sockSend(CLI_SOCK, "%i", PKT_HLM);

	for( ;; )
	{
		keyGet();
		if (sockReadReady(CLI_SOCK))
		{
			memset(tmpbuf, 0, 1024);
			sockRead(CLI_SOCK, tmpbuf);
			r = processStuff(tmpbuf);
			if (r == PKT_OK)
				return	PKT_OK;
			else if (r == PKT_ERR)
				return	PKT_ERR;
			else if (r == PKT_KIL)
			{
				sockClose(CLI_SOCK);
				gfxClose();
			}
		}
	}
}

void main( int argc, char *argv[] )
{
	int	r;

#ifdef __compile_SVGALIB
	/*
	 * UID 0 Check
	 */
	if (getuid() != 0)
	{
		printf("SVGALIB requires User ID 0 (root).\n");
		printf("You must be logged in as 'root' to play Unholy Knights.\n");
		exit(0);
	}
#endif

	/*
	 * Program Init
	 */

	mainInit();
	clearArmorStuff();
	clearHelmStuff();
	clearClassStuff();
	clearLandStuff();
	clearSpellStuff();

	if ((VB = (unsigned char *)malloc(gfxBig)) == NULL)
	{
		printf("ERROR! Unable to get memory for virtual buffer.\n");
		exit(0);
	}


	gfxInit();
#ifdef KEYBOARD
	keyInit();
#endif
	gfxSetVideoMode(gfxVIDEO);

	gfxSetScreen();
	gfxLoadPalette(DATAFILE);

	printf("\n");
	printf("Unholy Knights Client version %s, Copyright 1998 by Brian Justen.\n",
		VERSION);

	if (!setBackGround(DATAFILE, 1))
	{
		printf("ERROR: In-valid background [id=1], please report.\n");
		gfxClose();
	}

	loadSprites();
	loadFont(DATAFILE);
	loadLand(DATAFILE);
	loadBox();
	loadSpc();
	loadMap(1);
	loadMenu();

	if (!readConfig())
	{
		printf("ERROR: Unable to access config file [%s]\n", CONFFILE);
		gfxClose();
	}

#ifdef KEYBOARD
	keyOpen();
#endif

	/*
	 * Program Start
	 */

	gfxClearScreen();
	gfxSaveBack(0, 0, 320, 9);
	gfxDimBack(2);
	gfxPutBack();

	sprintf(TEMP_CRAP, "VERSION: %s", VERSION);
	printLetters(2, 2, "Unholy Knights Game Client", 110);
	printLetters(320 - (totalLetters(TEMP_CRAP) + 2), 2, TEMP_CRAP, 110);

	gfxSaveScreen();

	/*
	 * Connect to patch server and retrieve update.
	 */

	statusBox("Connecting to patch server...");
	gfxShowScreen();

	if ((r = connectPatch()))
	{
		gfxClearScreen();
		statusBox("Retrieving Update Information...");
		gfxShowScreen();

		if (recievePatch())
		{
			printf("Client Updated, client must be restarted.\n");
			gfxClose();
		}

		disconnectPatch();
	}
	else
	{
		printf("ERROR: Cannot connect to Patch Server.\n");
	}

	/*
	 * Connect to tracking server and find a host
	 */

	gfxClearScreen();
	statusBox("Connecting to Tracking Server...");
	gfxShowScreen();

	if (!connectTracker())
	{
		printf("ERROR: Problem while trying to connect to Tracking Server.\n");
		gfxClose();
	}

	gfxClearScreen();
	statusBox("Retrieving Server Information...");
	gfxShowScreen();

	recieveTracker();
	disconnectTracker();

	gfxClearScreen();

chooseServ:
	chooseServer();

	gfxClearScreen();
	statusBox("Getting Information: Classes");
	gfxShowScreen();
	recieveStuff(CHK_CLASS);

recieveNew:
	gfxClearScreen();
	statusBox("Getting Information: Account");
	gfxShowScreen();

	for(r = 0; r < 5; r++)
		plr[r].active = 0;

	recieveStuff(CHK_PLR);

	r = chooseCharacter();
	if (!r)
		goto chooseServ;
	else if (r == PKT_NEW)
		goto recieveNew;

	gfxClearScreen();
	statusBox("Entering Game, Please Wait...");
	gfxShowScreen();
	recieveStuff(CHK_LAND);
	recieveStuff(CHK_ARMOR);
	recieveStuff(CHK_HELM);
	recieveStuff(CHK_SPELL);

	mainProcess(r);

	goto recieveNew;
}
