#include <stdio.h>
#define MSGLEN 1024
#include "../List.h"
/*-------- Public functions --------------*/
int IsThereWarning();
int IsThereError();
void CleanErrorMessages(int type);
void warning(char *msg);
void error(char *msg);
char *GetErrorMsg();
List *GetWarningList();
/*-------- Private variable --------------*/
static List *Warnings = NULL;
static char ErrorMsg[MSGLEN] = "";

void error(char *msg)
{
	sprintf(ErrorMsg, "Error: %s", msg);
#ifdef VERBOSE
	fprintf(stderr, ErrorMsg);
#endif
}

void warning(char *msg)
{
	char WarningMsg[MSGLEN];
	
	if (!Warnings)
	  	Warnings = NewList();
	
	sprintf(WarningMsg, "Warning: %s", msg);
	if(!NewListEntry(Warnings, WarningMsg))
	{
		fatal("Not enough memory\n");
		exit(1);
	}		
#ifdef VERBOSE
	fprintf(stderr, WarningMsg);
#endif
}

void ClearErrorMessages(int type)
{
	static int Persistent = 0;
	if(!Persistent)	
	{		
		FreeList(Warnings);
		Warnings = NULL;
	}	
	ErrorMsg[0] = '\0';
	Persistent = type;
}

int IsThereError()
{
	return(	ErrorMsg[0] != '\0' );
}

int IsThereWarning()
{
	return(Warnings?1:0);
}

char *GetErrorMsg()
{
	return ErrorMsg;	
}

List *GetWarningList()
{
	return Warnings;	
}


/*
 * Get a list pointer an insert the data in it, one line per list entry
 *  If data does not end in \n, future calls will append data to the
 *  previous entry.
 */
void ParseData(List *Listing, char *data, int i)
{
	static int FlagNewLine = 1;
	int pos=0;
	static char superstring[200];
	while(i--)
	{
		if(data[pos] == '\n')
		{
			char tmp[200];
			strncpy(tmp, data, pos);
			tmp[pos] = '\0';
			if (!FlagNewLine)
			{
				strcat(superstring, tmp);
			}
			else
			{	
				superstring[0] = '\0';
				strcpy(superstring, tmp);
			}
			data = data + pos + 1;
			pos = 0;
			FlagNewLine = 1;			
			if(!NewListEntry(Listing, superstring))
			{
				fatal("Not enough memory!\n");
				exit(1);
			}
		}
		else
			pos++;
	}
	if (pos)
	{		
		if (!FlagNewLine)
			strcat(superstring, data);
		else
		{	
			superstring[0] = '\0';
			strcpy(superstring, data);
		}
		FlagNewLine = 0;
	}
}
