.TH FILES 1 "16 February 1996" "X Version 11"
.SH NAME
files \- X file manager with drag and drop capabilities

.SH SYNOPSIS
.B files
[\fI-version\fP] [\fIdirectories\fP ...]
.sp
.SH DESCRIPTION
\fIFiles\fP is a file  manager program for the X window system formely known
as \fIxfm\fP. It provides virtually all of the features that you would expect in a file
manager \- move around your directory tree in multiple windows, move, copy
or delete files, and launch programs with simple mouse operations. Directory
displays are updated automatically in regular intervals when the contents of
the directory changes. User-definable file types let you specify a command
to be executed when double-clicking on a file. Last but not least,
\fIfiles\fP can automatically mount and unmount special devices like
floppies as you open and close the corresponding directories (mount points).
.SH "OPTIONS"
\fIfiles\fP accepts a list of directories as command line arguments. For
each directory, \fIfiles\fP opens a  file window. If no directory is given, 
the user's home directory will be used.
.SH "USAGE"
Most of it should be fairly obvious. There is one 
or more file windows in which directories (also termed \fIfolders\fP) are
displayed. In order to perform an action, you either select items and then
invoke a menu operation, or you drag items from a file window to a second
(maybe the same) file window. You can also
double-click on an item to start a corresponding action (like launching an
application, editing a file, or changing directories), and press the right
menu button on an item to bring up a menu containing operations for a single
file or application. File operations are accessed
from the file window menu bar as usual.
.PP
The left-hand mouse button selects an item (and deselects all others in the
same window). The second button toggles the selected state of an item.
.PP
You can drag with the left-hand button to another window to move files from
one directory to another. The second button used in the same way will copy
files. New file windows can be opened by simply dragging a directory icon 
to the root window. 
.PP
The action taken when double-clicking on a file depends on the type of the
file. If it is a directory, it is displayed in the file window. If it is an
executable, the program is started. Other files are opened in the default
editor (specified by the \fIdefaultEditor\fP resource), unless another action
is given in the \fIrc\fP file (see CONFIGURATION below).
.PP
Directories can be displayed in three different forms: \fItree\fP (display
subdirectories in tree-like form), \fIicon\fP (display directories and files
as icons) and \fItext\fP (similar to \fIls -l\fP). These options are selected
from the \fIView\fP menu. In the tree form, clicking on the arrows takes you
up or down one level.
.PP
Directory displays are updated automatically in regular intervals when the
contents of the directory changes. You can also explicitly request a folder
update by double-clicking on the directory name field of the corresponding
file window.
.SH "MENU COMMANDS"
.sp
FILE MENU
.PP
File manipulation operations.
.TP 4
.I New...
.br
Create a new (and empty) file.
.TP 4
.I Move...
.br
Rename a single item (directory or file) or move selected items to another
directory.
.TP 4
.I Copy...
.br
Create a copy of a single item under a new name or copy selected items to
another directory.
.TP 4
.I Link...
.br
Like \fICopy\fP, but creates symbolic links rather than copying the selected
items.
.TP 4
.I Delete
.br
Delete the selected items.
.TP 4
.I Select...
.br
Select items by pattern. The usual metacharacters are recognized (\fI*\fP,
\fI?\fP, \fI[ ]\fP). (Currently there is no provision for escaping these.)
.TP 4
.I Select all
.br
Select all items in the current directory (except the parent directory).
.TP 4
.I Deselect
.br
Deselect all items.
.TP 4
.I Quit
.br
Terminate \fIxfm\fP.
.PP
FOLDER MENU
.PP
Operations dealing with directories and the file window.
.TP 4
.I New...
.br
Create a new directory.
.TP 4
.I Go to...
.br
Display the specified directory.
.TP 4
.I Home
.br
Display your home directory.
.TP 4
.I Up
.br
Display the parent directory.
.TP 4
.I Empty
.br
Delete all items in the current directory.
.TP 4
.I Close
.br
Close this file window.
.PP
VIEW MENU
.PP
Options for the directory display.
.TP 4
.I Tree
.br
Select the tree form display.
.TP 4
.I Icons
.br
Select the icons form display.
.TP 4
.I Text
.br
Select the text form display.
.TP 4
.I Sort by name
.br
Sort directory by name.
.TP 4
.I Sort by size
.br
Sort directory by size.
.TP 4
.I Sort by date
.br
Sort directory by date.
.TP 4
.I Filter...
.br
Specify a pattern to determine the files which should be displayed in the file
window. (This only affects normal files, i.e. directory items will not be
filtered. The \fIClear\fP button in the Filter dialog form reverts to the full
display.)
.TP 4
.I Hide folders
.br
Suppress directory items.
.TP 4
.I Mix folders/files
.br
Mix directories and other files.
.TP 4
.I Show hidden files
.br
Show hidden files (files starting with a dot).
.PP
FILE POPUP MENU
.PP
Operations on a single file. This menu pops up when pressing the right mouse
button on a directory or file icon.
.TP 4
.I Open
Open a file window on the selected item. This option is only available if the
selected item is a directory.
.TP 4
.I Edit
.br
Edit the selected item using the program specified in the \fIdefaultEditor\fP
resource (only available if the selected item is not a directory).
.TP 4
.I View
.br
Same as Edit, but invokes a program for viewing the file (\fIdefaultViewer\fP
resource).
.TP 4
.I Move...
.br
Move the selected item.
.TP 4
.I Copy...
.br
Copy the selected item.
.TP 4
.I Link...
.br
Create a symbolic link.
.TP 4
.I Delete
.br
Delete the selected item.
.TP 4
.I Information...
.br
Display information about the selected item (file size, permissions and such).
.TP 4
.I Permissions...
.br
Change the permissions of the selected item.
.PP
.SH "RESOURCES"
Various aspects of \fIfiles\fP can be configured by changing corresponding
resource settings in the applications default file. Some important resources
are listed below:
.TP 4
.B bitmapPath
.TP 4
.B pixmapPath
.br
The path on which to search for bitmap and pixmap icons, respectively.
.TP 4
.B configFile
.br
The names of the system-wide configuration file used by \fIfiles\fP (see
CONFIGURATION). 
.TP 4
.B doubleClickTime
.br
Set the time interval in milliseconds for which a sequence of two mouse clicks
should be interpreted as a double click. Default: 300.
.TP 4
.B updateInterval
.br
Set the time interval in milliseconds in which to perform automatic folder
updates. Default: 10000.
.TP 4
.B confirmXXX
.br
Resources to request confirmation for various operations. \fIXXX\fP can be
any one of \fIDeletes\fP, \fIDeleteFolder\fP, \fICopies\fP, \fIMoves\fP,
\fIOverwrite\fP and \fIQuit\fP. By default these are all enabled.
.TP 4
.B defaultEditor
.br
The command with which \fIfiles\fP invokes your favourite editor.
.TP 4
.B defaultViewer
.br
The command with which \fIfiles\fP invokes your favorite viewer.
.TP 4
.B BourneShells
.br
\fIfiles\fP calls other programs by executing your shell (as taken from the
environment variable \fISHELL\fP). Since Bourne compatible shells need one
extra parameter, \fIfiles\fP needs to know about the type of the shell. If this
resource is not set (default), or is equal to the special string \fIAUTO\fP, a
quick-and-dirty test is done at startup. 
Set the \fIBourneShells\fP resource to a comma separated list of full path
names of Bourne compatible shells if you experience problems. If your shell matches an entry in this
list, \fIfiles\fP will assume it is a Bourne shell.
.PP
There are way too many available resources to list them all in this manual
page, so please take a look at the application defaults file for more
information.
.SH "CONFIGURATION"
Besides the application resources, \fIfiles\fP can be configured by means of a
configuration file called \fI.Filesrc\fP located in your home directory. If
this file is not found, \fIfiles\fP search for a system-wide one. The
location of such file may vary and can be adjusted using the corresponding
X resource. It is a plain ASCII files which can be edited using any text editor.
Any line in this file which starts with a hash sign (\fI#\fP) is interpreted
as a comment; empty lines are ignored. Note that there exists a line
splitting this file in two parts: file type configuration and device
configuration. Also, if \fIfiles\fP has been compiled with the 
\fIMAGIC_HEADERS\fP option then another file called \fIFilesMagic\fP
(system-wide) or \fI~/.FilesMagic\fP is used (see below).

.SH "FILE TYPE CONFIGURATION"
The first half of the \fIFilesrc\fP file specifies the types of ordinary (non-executable,
non-directory) files which \fIfiles\fP should recognize. 
Each file type associates a pattern with an icon and two different kinds
of actions (commands to be executed on the file). If \fIfiles\fP has been
compiled with the \fIMAGIC_HEADERS\fP option then it is possible to specify
icons (but not actions) for directories and executables as well. Each line 
has the following format:
.sp
.nf
        pattern:icon:push-action:drop-action
.fi
.sp
As indicated, the different fields are separated by a colon (use \fI\\:\fP
to escape the \fI:\fP character, and \fI\\\\\fP to escape the backslash
character itself). The meaning of these fields is explained below.
.TP 4
.B pattern
This field allows you to specify which files belong to the type. File types
can either be specified by a \fIfilename pattern\fP, which refers to the name
of a file, or a \fImagic header\fP, which refers to the contents of the file,
or both.
.sp
There are three types of filename patterns: \fILiteral\fP patterns
specify a literal filename such as ``\fIcore\fP.'' \fISuffix\fP patterns
specify a suffix the filename must match, and are indicated by a leading
asterisk, as in ``\fI*.c\fP.'' (All characters following the initial \fI*\fP
are interpreted as literals; there is no expansion of embedded wildcards.)
Finally, \fIprefix\fP patterns specify a prefix to be matched against the
filename. They are denoted by a trailing asterisk, as in ``\fIREADME*\fP.''
.sp
Magic headers are specified by a symbolic name given in the \fIFilesMagic\fP 
file, enclosed in angle brackets. Entries referring to a magic header cause the
contents of the file to be checked against the magic numbers in the
\fIFilesMagic\fP file. The format of these entries is described in Section 
MAGIC HEADERS below.
.TP 4
.B icon
The name of the bitmap or pixmap file containing the icon to be displayed
for this file type.
.TP 4
.B push-action
The command to be executed when the user double-clicks on a file of this
type. This command is passed to the shell (via \fI-c\fP), together with
the name of the selected file. The command is executed in the directory
where the selected file is located. The filename is available in the command
as the positional parameter number one, such that an action of the form
\fIxyz $1\fP invokes the command \fIxyz\fP on the selected file. 
There are also two special kinds of push actions built into \fIfiles\fP,
\fIEDIT\fP and \fIVIEW\fP which invoke the default editor and default viewer 
on the selected file, respectively.
.TP 4
.B drop-action
Similar to the push action, this field denotes a command to be executed when
a collection of selected files is dropped onto the file. The absolute target
filename itself is available as positional parameter \fI$1\fP, the remaining
arguments denote the names of the files dropped onto the target file. The
command is executed in the directory which contains the selected files. No
special built-in commands are available for this type of action.
.PP
If an action field is empty, the corresponding action defaults to ``do
nothing.'' For instance, the following entry defines an icon and an
\fIEDIT\fP push action for \fI.c\fP files:
.sp
.nf
        *.c:files_c.xpm:EDIT:
.fi
.sp
As another example, here is an entry for compressed (i.e. gzipped) tar
files. The push action causes the archive to be extracted, while the drop
action replaces the contents of the archive with the files which have been
dragged onto the archive:
.sp
.nf
        *.tar.gz:files_taz.xpm:exec tar xfvz $1:exec tar cfvz $*
.fi
.sp
(Note the use of the shell's \fIexec\fP command. Since actions are invoked
through the shell, it is often useful to replace the shell with the actual
command which is to be executed, in order to conserve memory space on
small systems.)
.PP
It is possible that different patterns given in the \fIfilesrc\fP file overlap.
In this case \fIfiles\fP uses the \fIfirst\fP pattern which matches. Therefore
you should always list the more specific patterns first. For instance, the
following two entries specify what to do with compressed tar files (specific
case) and other \fI.gz\fP files (default case):
.sp
.nf
        *.tar.gz:files_taz.xpm:exec tar xfvz $1:exec tar cfvz $*
        *.gz:files_z.xpm:exec gunzip $1:
.fi
.PP
\fIfiles\fP also enables you to prompt for additional parameters before an action
is executed. This is generally more useful with application entries than
with file actions, and will therefore be described in the context of
application configuration, see PARAMETER DIALOGS below.
.SH "MAGIC HEADERS"
When compiled with the \fIMAGIC_HEADERS\fP option, \fIfiles\fP can determine
file types using the magic numbers contained in the files.
.PP
The magic numbers are described in a configuration file whose path is obtained
from the \fImagicFile\fP resource. The format of the file is the same as that
of the \fImagic\fP(5) file, with some extensions like regular expression
matching. (See \fIxfmtype\fP(1).)
.PP
There are five built-in types which are used if all the patterns in the
\fImagic\fP file fail:
.TP 4
.B unreadable
Read failed.
.TP 4
.B empty
File size is zero.
.TP 4
.B special
Not a regular file.
.TP 4
.B ascii
Could be read and looks like ASCII.
.TP 4
.B data
Could be read but all tests failed and doesn't look like ASCII.
.PP
To specify a magic file type you include it between angle brackets at the
beginning of the pattern field:
.sp
.nf
        <GIF>:files_gif.xpm:exec xpaint $1:
.fi
.sp
or combined with a filename pattern:
.sp
.nf
        <ascii>*.cc:files_cc.xpm:EDIT:
.fi
.PP
In the latter case, the file must meet both conditions, i.e. be an ASCII file
and have a \fI.cc\fP suffix.
.PP
To include angle brackets in the type or the pattern you must escape them
using backslashes.
.PP
If \fIfiles\fP is compiled with the \fIMAGIC_HEADERS\fP option, it is also
possible to specify custom icons for directories and executables. For this
purpose, the \fImagic\fP file distributed with \fIfiles\fP provides magic file
types named \fI<DIR>\fP, \fI<EXEC>\fP, etc. For instance, here is an entry
which specifies a special icon for hidden directories:
.sp
.nf
        <DIR>.*:hidden_dir.xpm::
.fi
.PP
In the same way you can also override the built-in icons for displaying
arbitrary directories and executables:
.sp
.nf
        <DIR>..:parent_dir.xpm::
        <DIR>:plain_dir.xpm::
        <DIR LNK>:link_dir.xpm::
.fi
.SH DEVICE CONFIGURATION
The device configuration section of \fIfilesrc\fP, lets you specify which mount
points \fIfiles\fP should keep track of, and which actions to perform in order
to mount and unmount the corresponding file systems. This allows you to access
file systems on special devices such as floppies, CD-Roms, etc. in a
transparent way. All you have to do is to enter a directory named
in \fIfilesrc\fP (e.g. by opening a file window on it), and \fIfiles\fP will
automatically perform the corresponding mount action for you. Likewise, if you
leave such a directory, \fIfiles\fP invokes the corresponding unmount
action. (CAUTION: You still have to take care that you unmount a file system,
e.g. by closing every file window which has been opened on it, before you
physically remove the corresponding medium.) Alternatively, it is
recommended that you use external utilities like \fIsupermount\fP to perform
such operations without any risk of data loss.
.PP
An entry of the devide section has the following format:
.sp
.nf
        directory:mount-action:umount-action
.fi
.sp
The \fIdirectory\fP field denotes the mount point of the file system,
\fImount-action\fP the command to be executed in order to mount the file
system, and \fIumount-action\fP the command for unmounting the file system.
Here is a ``typical'' entry from a \fIfilesrc\fP file:
.sp
.nf
        /disk/a:mount -t msdos -o user /dev/fd0 /disk/a:umount /disk/a
.fi
.sp
Of course, the details of how to mount a floppy file system may vary from
system to system, and you might have to take special actions if you want to
use \fImount\fP as an ordinary user. See \fImount\fP(8) for details.
.SH "PARAMETER DIALOGS"
\fIfiles\fP lets you prompt the user for additional parameters when a push
or drop action is invoked. In such a case, a dialog form appears, with one
field for each parameter, into which the user can enter the required
arguments. Currently, no checking is done on the supplied parameters; in
fact, the user can simply leave all fields empty. Parameters are specified
in an action using the form
.sp
.nf
        %parameter-name%
.fi
.sp
where \fIparameter-name\fP is an arbitrary string not containing the \fI%\fP
character, which will be displayed in the dialog form. (As usual, a literal
\fI%\fP character can be escaped with the backslash.) \fIfiles\fP replaces
each such \fI%...%\fP construct with the corresponding value entered by the
user.
.PP
.SH "CONSOLE OUTPUT"
Programs started by \fIfiles\fP inherit their standard output and error streams
from \fIfiles\fP. Therefore, if you start \fIfiles\fP from your session or window
manager instead of an xterm, you should redirect \fIfiles\fP's standard
output and error to something which you can read while \fIfiles\fP is running,
if the window manager does not already do that for you. Usually, you will
reassign both \fIstdout\fP and \fIstderr\fP to \fI/dev/console\fP, using the
command:
.sp
.nf
        files >/dev/console 2>&1
.fi
.sp
Then you can read error messages and other output produced by launched
applications in the console window on your desktop (such as \fIxconsole\fP,
or \fIxterm -C\fP).
.SH "ICONS"
\fIfiles\fP supports icons in both the X bitmap and Arnaud Le Hors' XPM format.
A collection of useful icons is included in the distribution.
.SH "FILES"
.TP 4
.B ~/.Filesrc
Standard location for \fIfiles\fP configuration file.
.SH "SEE ALSO"
\fIX\fP(1), \fIxconsole\fP(1), \fIxterm\fP(1), \fImount\fP(8), Arnaud Le Hors:
\fIXPM Manual. The X PixMap Format\fP, Groupe Bull, 1993. \fIThe Drag and Drop
HOWTO\fP by Cesar Crusius.

.SH "CAVEATS AND BUGS"
\fIfiles\fP catches the TERM signal to gracefully terminate the program,
unmounting all open file systems which have been mounted by \fIfiles\fP.
However, some window and session managers may not send TERM signals
to their client applications when terminating an X session. Therefore it might
be necessary to explicitly quit \fIfiles\fP or manually close file windows before exiting X.
.PP
\fIfiles\fP depends on your shell \- see resource \fIBourneShells\fP.
.SH "COPYRIGHT"
Copyright (c) 1990-1993 by Simon Marlow
.br
Copyright (c) 1994, 1995 by Albert Graef
.br
Copyright (c) 1996 by Andre Hentz
.SH "AUTHORS"
The original version of this program (called \fIxfm\fP) was written by Simon
Marlow (simonm@dcs.glasgow.ac.uk) at the University of Glasgow. Albert Graef
(ag@muwiinfa.geschichte.uni-mainz.de) at the University of Mainz did many bug 
fixes and enhancements.

The original version of this program (called \fIxfm\fP) was written by Simon 
Marlow (simonm@dcs.glasgow.ac.uk) at the University of Glasgow. Albert Graef
(ag@muwiinfa.geschichte.uni-mainz.de) at the University of Mainz 
is the author of the lastest \fIxfm\fP version (1.3.2) which contains many 
bug fixes and enhancements. Other people have contributed additional 
features: 
Dave Safford (dave.safford@edu.tamu.sc; automatic folder updates); 
Robert Vogelgesang (vogelges@rhrk.uni-kl.de; shell detection code); 
Juan D. Martin (juando@cnm.us.es; magic headers);
Kevin Rodgers (rodgers@lvs-emh.lvs.loral.com; Filter option);
Scott Heavner (sdh@falstaff.MAE.cwru.edu; View option); 
Brian King (ender@ee.WPI.EDU; default values in parameter dialogs).
.PP
In 1996, this program underwent a complete reformulation in order to be able
to work together with \fIDnD\fP (the Drag and Drop protocol by Cesar
Crusius). Many features of earlier versions were removed due to the new role
played by \fIfiles\fP in the context of \fIOffiX\fP. \fIOffiX\fP is an
expandable environment built around \fIDnD\fP and aimed to give novice and
expert users a comfortable and common desktop.
