/*
 * String.cc : Method definitions for class dndString
 * Copyright (C) 1996 Csar Crusius
 *
 * This file is part of the DND Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <OffiX/String.h>

dndString::dndString(void)			{ theString=NULL; }
dndString::dndString(const char *newString)	{ set(newString); }
dndString::dndString(dndString *newString)	{ set(newString->string()); }

dndString::~dndString(void)			{ clear(); }

void dndString::set(const char *newString)
{
	if(newString==NULL) return;
	if(theString) delete theString;
	theString=new char[strlen(newString)+1];
	if(theString) strcpy(theString,newString);
}

void dndString::set(dndString *newString)
{
	set(newString->string());
}

void dndString::clear(void)
{
	if(theString) delete theString;
	theString=NULL;
}

char *dndString::string(void)
{
	return theString;
}