/*
 * Fireworkz 1.1 - pyrotechnics simulation program
 * Copyright (C) 1999-2004 Rony B Chandran <ronybc@asia.com>
 *
 * For latest version or to drop a small donation,
 * visit http://www.ronybc.8k.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vga.h>

#define PIXCOUNT 500                   /* 500  */
#define POWER   3                      /* 3    */
#define FTWEAK 12                      /* 12   */

static int SHELLCOUNT = 10;            /* 10   */
static int RNDLIFE = 500;              /* 500  */
static int MINLIFE = 100;              /* 100  */
static int FUZZY = 0;
static int width = 640;
static int height= 480;

typedef struct {
  int burn;
  float x;
  float y;
  float xv;
  float yv; }firepix;

typedef struct {
  int life;
  int color;
  int special;
  float air;
  firepix *fpix; }fireshell;


/* "random is mathematically undefinable..
 *  we are so 'relational' so we finds nothing in random
 *  actullaly.. life is 'evolved' by random..."
 *              -someone purified with ethyl alcohol :)
 */

int rnd(int x){
  return(random()%x); }  /* can cause 'divide-by-zero' */

int explode(fireshell *fs){
  float adg = 0.001; /* gravity */
  int n,fuz=0;
  int h = height;
  int w = width;
  float air = fs->air;
  firepix *fp = fs->fpix;
  vga_setcolor(fs->color);
  if(fs->special || FUZZY) fuz=1;
  for(n=PIXCOUNT;n;n--){
  if(fp->burn){ --fp->burn; 
  if(fuz){    /* run unstable code...! */
  fp->x += fp->xv = fp->xv * air + (float)(rnd(200)-100)/2000;
  fp->y += fp->yv = fp->yv * air + (float)(rnd(200)-100)/2000 +adg; }
  else{
  fp->x += fp->xv = fp->xv * air + (float)(rnd(200)-100)/20000;
  fp->y += fp->yv = fp->yv * air + adg; }
  if(fp->y > h) fp->yv *= -0.3;
  if(fp->x < w && fp->x > 0 && fp->y < h && fp->y > 0){
  vga_drawpixel(fp->x, fp->y);}
  } fp++;
  } return(--(fs->life)); }

void recycle(fireshell *fs,int x,int y){
  int n,pixlife;
  firepix *fp = fs->fpix;
  fs->life = rnd(RNDLIFE)+MINLIFE;
  fs->air  = 1-(float)(rnd(200))/10000;
  fs->color = rnd(15);
  fs->special = rnd(10)==3 ? 1:0; 
  pixlife = rnd(fs->life)+fs->life/10+1; /*!*/
  for(n=0;n<PIXCOUNT;n++){
  fp->burn = rnd(pixlife)+32;
  fp->xv = POWER*(float)(rnd(20000)-10000)/10000;
  fp->yv = sqrt(POWER*POWER - fp->xv * fp->xv) *
               (float)(rnd(20000)-10000)/10000;
  fp->x = x;
  fp->y = y; 
  fp++;             }}

int main(int argc,char *argv[]){
  int n,q;
  firepix   *fpixs, *fpix;
  fireshell *fshells, *fshell;
  fprintf(stderr,"\nZFireworks - pyrotechnics simulation program \n");
  fprintf(stderr,"Copyright (c) 1999-2004 Rony B Chandran <ronybc@asia.com> \n\n");
  fprintf(stderr,"For latest version and to drop a small donation, \n");
  fprintf(stderr,"please visit.. http://www.ronybc.8k.com \n\n");
  for(n=1;n<argc;n++){
  if(strcmp(argv[n],"-normal")==0){
    SHELLCOUNT = 3;
    RNDLIFE = 800;
    MINLIFE = 500;  }
  else if(strcmp(argv[n],"-long")==0){
    SHELLCOUNT = 3;
    RNDLIFE = 5000;
    MINLIFE = 2000; }
  else if(strcmp(argv[n],"-fuzzy")==0){ 
    FUZZY = 1; }
  else {
    printf("Usage: zfireworks [-normal | -long] [-fuzzy] \n\n");
    printf("    -fuzzy    they will zzzoozzooo.........!\n"); 
    printf("    -normal   decrease frequency and number of explosions\n");
    printf("    -long     long living burnies \n\n");
    printf("Report bugs to <ronybc@asia.com> http://www.ronybc.8k.com\n");
    exit(0); }}

  vga_init();
  width = 800; height = 600;
  if(vga_setmode(G800x600x16)){
  if(vga_setmode(G800x600x256)){
  width = 640; height = 480;
  if(vga_setmode(G640x480x16)){
  if(vga_setmode(G640x480x256)){
  width = 320; height = 240;
  if(vga_setmode(G320x200x16)){
  if(vga_setmode(G320x200x256)){
    fprintf(stderr,"Error: Unable to find a graphics display mode.\n");
    exit(1);}}}}}}

  srandom(time(0));

  fpixs = malloc(sizeof(firepix) * PIXCOUNT * SHELLCOUNT);
  fshells = malloc(sizeof(fireshell) * SHELLCOUNT);
  fshell = fshells;
  fpix = fpixs;
  for (n=0;n<SHELLCOUNT;n++){
  fshell->fpix = fpix;
  recycle (fshell,rnd(width),rnd(height));
  fshell++; 
  fpix += PIXCOUNT; }

  while(!vga_getkey()) {

  for(q=FTWEAK;q;q--){
  fshell=fshells;
  for(n=SHELLCOUNT;n;n--){
  if (!explode (fshell))
  recycle (fshell,rnd(width),rnd(height));
  fshell++; }}
  usleep(20000);
  vga_waitretrace();
  vga_clear(); }

  vga_setmode(TEXT);
  return 0; }

