#ifndef lint
static const char rcsid[] = "$Id: server.c,v 1.1.1.1 1996/06/30 00:09:17 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: server.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:17  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:05  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
#include <stdlib.h>
#include <pthread.h>
#include <stdio.h>
#include "str_namespace.h"
#include "simple.h"                /* Created from simple.idl */
#include "check_status.h"

static void
waiter( void )
{
   sigset_t sigset;
   int caught = FAILURE;
   unsigned32 status;

   sigemptyset( &sigset );
   sigaddset( &sigset, SIGINT );
   sigaddset( &sigset, SIGTERM );
   sigaddset( &sigset, SIGHUP );
   sigaddset( &sigset, SIGQUIT );

   pthread_sigmask( SIG_SETMASK, &sigset, NULL );

   switch((caught = sigwait( sigset )))
   {
       case SIGINT:
           printf("Caught SIGINT\n");
           break;
       case SIGTERM:
           printf("Caught SIGTERM\n");
           break;
       case SIGHUP:
           printf("Caught SIGHUP\n");
           break;
       case SIGQUIT:
           printf("Caught SIGQUIT\n");
           break;
       default:
           printf("Error: signal %d\n", caught );
           break;
   }

   rpc_mgmt_stop_server_listening( NULL, &status );
   CHECK_STATUS(status, "rpc_mgmt_stop_server_listening() failed!\n", ABORT);
   pthread_exit( (void *) EXIT_SUCCESS );
}

static pthread_t sig_waiter;

int
main( int argc, char *argv[] )
{
	int st, i;
	unsigned_char_t *str_bind;
	unsigned32 status;
	rpc_binding_vector_t *bvec;
	FILE *fd;

	rpc_server_register_if( simple_v1_0_s_ifspec, NULL, NULL, &status );
	CHECK_STATUS(status, "Can't register interface\n", ABORT);

	rpc_server_use_all_protseqs( rpc_c_protseq_max_reqs_default, &status );
	CHECK_STATUS(status, "Can't create binding information\n", ABORT);

	rpc_server_inq_bindings( &bvec, &status );
	CHECK_STATUS(status, "Can't get binding information\n", ABORT); 

	if( (fd = rpc_ns_open( "ns_file.dat" )) == NULL )
	{
		fprintf( stderr, "Failed to open nameserver file!\n" );
		exit(1);
	}

	for(i = 0; i < bvec->count; i++ )
	{
		rpc_binding_to_string_binding( bvec->binding_h[i], &str_bind, &status );
		CHECK_STATUS(status, "Can't create string binding\n", RESUME );

		if( (st = rpc_ns_register( fd, str_bind )) != rpc_s_ok )
		{
			fprintf( stderr, "Error %d Failed to register binding!\n", st );
			exit(1);
		}

                printf("Exporting binding %s\n", str_bind );
		rpc_string_free( &str_bind, &status );
		CHECK_STATUS(status, "Failed to deallocate string binding\n", RESUME );
	}

	rpc_ns_close( fd );
	rpc_ns_free_string( &str_bind );

       st = pthread_create( &sig_waiter, pthread_attr_default, (thread_proc_t) waiter, NULL ); 
       if( st != SUCCESS )
       {
           fprintf( stderr, "Failed to register signal handler!\n");
           exit( EXIT_FAILURE );
       }

	printf("\n\nserver listening!\n\n");
	rpc_server_listen( 1, &status );
	CHECK_STATUS( status, "Failed in rpc_server_listen()", ABORT );

	printf("*** SERVER COMPLETE *** \n");
	return( 0 );
}
