#ifndef lint
static const char rcsid[] = "$Id: client.c,v 1.1.1.1 1996/06/30 00:09:17 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: client.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:17  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:05  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * client.c
 */
#include <stdlib.h>
#include <stdio.h>
#include "check_status.h"
#include "str_namespace.h"
#include "simple.h"

void
import_binding( const char *filename, 
			    const char *protocol,
			    rpc_binding_handle_t *bind_h )
{
	unsigned32 st;
	rpc_string_binding_t str_bind;
	FILE *fd;

	fd = rpc_ns_open_read_only( filename );
	if( fd == NULL )
	{
		fprintf( stderr, "Failed to open %s!\n", filename );
		exit(1);
	}

	st = rpc_ns_query( fd, protocol, &str_bind );
	if( st != rpc_s_ok )
	{
		fprintf( stderr, "Failed to query binding!\n");
		exit(1);
	}

	rpc_binding_from_string_binding( str_bind, bind_h, &st );
	CHECK_STATUS( st, "Failed to convert binding!\n", ABORT );
}

int
main( int argc, char *argv[] )
{
	long result = 0;
	rpc_binding_handle_t bind_h;
	char *protocol = "tcp";

	if( argc == 2 )
		protocol = argv[1];

	import_binding( "ns_file.dat", protocol, &bind_h );

	sum( bind_h, 1, 2, &result );

	printf("result = %ld\n\n", result );
	return( EXIT_SUCCESS );
}
