#ifndef lint
static const char rcsid[] = "$Id: rpcrand.c,v 1.1.1.1 1996/06/30 00:09:14 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: rpcrand.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:14  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:10  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1990 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1990 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1990 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
/*
**
**  NAME
**
**      rpcrand.c
**
**  FACILITY:
**
**      Remote Procedure Call (RPC) 
**
**  ABSTRACT:
**
**  The support routines for the rpcrand.h abstraction.  These should NOT 
**  be called directly; use the macros defined in rpcrand.h .
**
**
*/

#include <commonp.h>

/* 
 * R P C _ _ R A N D O M _ I N I T
 */

PRIVATE void rpc__random_init
#ifdef _DCE_PROTO_
(
    unsigned32 seed
)
#else
(seed)
unsigned32 seed;
#endif
{
    srandom ((int) seed);
}

/* 
 * R P C _ _ R A N D O M _ G E T
 */

PRIVATE unsigned32 rpc__random_get
#ifdef _DCE_PROTO_
(
    unsigned32 lower,
    unsigned32 upper
)
#else
(lower, upper)
unsigned32 lower;
unsigned32 upper;
#endif
{
    return (random ());
}
