/*
 * $Id: debug.h,v 1.1.1.1 1996/06/30 00:09:10 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: debug.h,v $
 * Revision 1.1.1.1  1996/06/30 00:09:10  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:10  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

#undef DEBUG_PRINT_FUNCTION
#define DEBUG_PRINT_FUNCTION(function) \
{ pthread_lock_global_np(); \
  printf("LOG: %s: th[%ld]: ", function,pthread_getsequence_np(pthread_self())); \
  pthread_unlock_global_np(); \
}

#undef DEBUG_PRINT_MSG
#define DEBUG_PRINT_MSG(msg) \
{ \
    pthread_lock_global_np(); \
    printf("%s\n",msg); \
    pthread_unlock_global_np(); \
}

#undef DEBUG_PRINT_CANCEL_MSG
#define DEBUG_PRINT_CANCEL_MSG(id) \
{ \
    char msg[60]; \
    pthread_lock_global_np(); \
    sprintf(msg, "canceled th[%ld]!", pthread_getsequence_np(id)); \
    pthread_unlock_global_np(); \
    DEBUG_PRINT_MSG(msg); \
}
