#ifndef lint
static const char rcsid[] = "$Id: cnid.c,v 1.1.1.1 1996/06/30 00:09:07 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: cnid.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:07  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:06  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
/*
**
**  NAME
**
**      cnid.c
**
**  FACILITY:
**
**      Remote Procedure Call (RPC)
**
**  ABSTRACT:
**
**  The Local Identifier Service.
**
**
*/

#include <commonp.h>    /* Common declarations for all RPC runtime */
#include <com.h>        /* Common communications services */
#include <comprot.h>    /* Common protocol services */
#include <cnp.h>        /* NCA Connection private declarations */
#include <cnid.h>

/*
 * INTERNAL variables.
 */

INTERNAL unsigned16     seqnum;

/***********************************************************************/


/*
**++
**
**  ROUTINE NAME:       rpc__cn_init_seqnum
**
**  SCOPE:              PRIVATE - declared in cnid.h
**
**  DESCRIPTION:
**
**
**  This routine initializes the global sequence number cell and
**  corresponding mutex.
**
**  A sequence number generated by extracting the lower sixteen bits
**  of system time in seconds.
**
**  INPUTS:             none
**
**  INPUTS/OUTPUTS:     none
**
**  OUTPUTS:            none
**
**  IMPLICIT INPUTS:    none
**
**  The system time.
**
**  IMPLICIT OUTPUTS:   none
**
**  The static variable seqnum will contain the lower 16
**  bits of the system time in seconds.
**
**  FUNCTION VALUE:     none
**
**  SIDE EFFECTS:       none
**
**
**
**
**--
**/

PRIVATE void rpc__cn_init_seqnum (void)

{

    /*
     * Determine the system time in seconds via the time() C runtime library
     * call. Use the lower 16 bits of this for the sequence number.
     */
    seqnum = ((unsigned32) time (NULL)) & 0xffff;
}


/*
**++
**
**  ROUTINE NAME:       rpc__cn_gen_local_id
**
**  SCOPE:              PRIVATE - declared in cnid.h
**
**  DESCRIPTION:
**
**  This routine creates a new local identifier. The index portion
**  of the identifier is taken from the index argument passed by the
**  caller.
**
**  INPUTS:
**
**      index           Index value to be stored in the local
**                      identifier being created.
**
**  INPUTS/OUTPUTS:     none
**
**  OUTPUTS:
**
**      lcl_id          The created local identifier.
**
**  IMPLICIT INPUTS:    none
**
**  IMPLICIT OUTPUTS:   none
**
**  FUNCTION VALUE:     none
**
**  SIDE EFFECTS:
**
**  The sequence number is incremented.
**
**--
**/

PRIVATE void rpc__cn_gen_local_id 
#ifdef _DCE_PROTO_
(
    unsigned32              index,
    rpc_cn_local_id_t       *lcl_id
)
#else
(index, lcl_id)
unsigned32              index;
rpc_cn_local_id_t       *lcl_id;
#endif
{

    /*
     * Increment it so that the local id being generated will be different that
     * the last.
     */
    seqnum++;

    /*
     * Since zero is defined as being an invalid local id we never want to
     * generate a local id with a sequence number part of zero (since the index
     * given may be zero.
     */
    if (seqnum == 0)
    {
        seqnum = 1;
    }

    /*
     * Copy the sequence number into the returned local id.
     */
    lcl_id->parts.id_seqnum = seqnum;

    /*
     * Put the caller provided index into the returned local id.
     */
    lcl_id->parts.id_index = (unsigned16) index;
}
