#if 0

    Invoke the following as

        $ ifaddr eth0

    or similar, depending on the name of the ethernet interface you are
    interested in.

#endif

#include <stdio.h>
#include <net/if.h>
#include <netinet/in.h>

int 
main(int argc, char **argv)
{
    int sd;
    struct ifreq ifr;
    unsigned char *a;

    if (argc != 2) {
        fprintf(stderr, "Usage: ifaddr ifname\n");
        exit(2);
    }

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
    if (sd < 0) {
        perror("socket");
        exit(1);
    }

    strncpy(&ifr.ifr_name, argv[1], IFNAMSIZ);

    if (ioctl(sd, SIOCGIFHWADDR, &ifr) < 0) 
    {
        perror("ioctl SIOCGIFHWADDR");
        exit(1);
    }

    a = (unsigned char *) &ifr.ifr_hwaddr.sa_data;
    printf("%02x%02x%02x%02x%02x%02x\n", a[0],a[1],a[2],a[3],a[4],a[5]); 
    exit(0);
}
