#ifndef lint
static const char rcsid[] = "$Id: uuidgen.c,v 1.1.1.1 1996/06/30 00:09:05 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: uuidgen.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:05  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:13  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>        /* @@ 26 June, '95 */
#include <locale.h>
#include <dce/dce.h>
#include <dce/dce_error.h>
#include <dce/uuid.h>
#include "uidsts.h"


/*
**  If error, print message and exit.
*/
static void
check_status
(
    error_status_t	st,
    char		*func
)
{
    dce_error_string_t error_text;
    int  dummy_st;

    if (st != error_status_ok) {
	dce_error_inq_text(st, error_text, &dummy_st);
	dce_fprintf(stderr, uuidgen_st_failure, func, error_text);
	exit(1);
    }
}

static void output_uuid (FILE *F, int format, uuid_p_t u)
{
    unsigned char	*buff;
    error_status_t 	st;
    
    uuid_to_string(u, &buff, &st);
    check_status(st, "uuid_to_string");
	
    switch (format) {
    case 'u':
	fprintf(F, "%s\n", buff);
	break;
    case 'i':
	fprintf(F, "[\n");
	fprintf(F, "    uuid(%s),\n", buff);
	fprintf(F, "    version(1.0)\n");
	fprintf(F, "]\n");
	fprintf(F, "interface INTERFACENAME\n");
	fprintf(F, "{\n");
	fprintf(F, "}\n");
	break;
    case 's':
	fprintf(F, "= { /* %s */\n", buff);
	fprintf(F, "    0x%8.8x, 0x%4.4x, 0x%4.4x, 0x%2.2x, 0x%2.2x,\n",
		u->time_low, u->time_mid, u->time_hi_and_version,
		u->clock_seq_hi_and_reserved, u->clock_seq_low);
	fprintf(F,
		"    { 0x%2.2x, 0x%2.2x, 0x%2.2x, 0x%2.2x, 0x%2.2x, 0x%2.2x }\n",
		u->node[0], u->node[1], u->node[2],
		u->node[3], u->node[4], u->node[5]);
	fprintf(F, "};\n");
    }
    rpc_string_free(&buff, &st);
}

int
main(
    int			ac,
    char		*av[]
)
{
    unsigned char	*buff;
    uuid_t		u;
    int			count;
    char		format;
    FILE		*F;
    int			i;
    error_status_t	st;

    /* Set defaults. */
    setlocale(LC_ALL, "");
    format = 'u';
    count = 1;
    F = stdout;

    /* Parse JCL. */
    while ((i = getopt(ac, av, "hisvn:o:t:c:")) != EOF)
	switch (i) {
	default:
	    dce_printf(uuidgen_st_usage);
	    return 1;
	case 'h':
	    dce_printf(uuidgen_st_usage);
	    dce_printf(uuidgen_st_h_flag);
	    dce_printf(uuidgen_st_i_flag);
	    dce_printf(uuidgen_st_s_flag);
	    dce_printf(uuidgen_st_n_flag);
	    dce_printf(uuidgen_st_o_flag);
	    dce_printf(uuidgen_st_t_flag);
	    dce_printf(uuidgen_st_c_flag);
	    dce_printf(uuidgen_st_v_flag);
	    return 0;
	case 'i':
	case 's':
	    format = i;
	    break;
	case 'v':
	    dce_printf(uuidgen_st_version);
	    return 0;
	case 'n':
	    count = atoi(optarg);
	    break;
	case 'o':
	    if ((F = fopen(optarg, "w")) == NULL) {
		dce_fprintf(stderr, uuidgen_st_cantopen, optarg);
		return 1;
	    }
	    break;
	case 't':
	    uuid_from_string((idl_char *) optarg, &u, &st);
	    check_status(st, "uuid_from_string");
	    uuid_to_string(&u, &buff, &st);
	    check_status(st, "uuid_to_string");
	    fprintf(F, "%08lx-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x\n",
		    u.time_low, u.time_mid, u.time_hi_and_version,
		    u.clock_seq_hi_and_reserved, u.clock_seq_low,
		    u.node[0], u.node[1], u.node[2],
		    u.node[3], u.node[4], u.node[5]);
	    return 0;
	case 'c':
	    uuid_from_string((idl_char *) optarg, &u, &st);
	    check_status(st, "uuid_from_string");
	    output_uuid(F, format, &u);
	    return 0;
	}
    ac -= optind;
    av += optind;
    if (ac) {
	dce_fprintf(stderr, uuidgen_st_usage, "uuidgen");
	return 1;
    }

    /* Do the work. */
    while (--count >= 0) {
	uuid_create(&u, &st);
	check_status(st, "uuid_create");

	output_uuid(F, format, &u);
    }
    return 0;
}

