/*
 * $Id: upkvaxf.c,v 1.1.1.1 1996/06/30 00:09:04 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: upkvaxf.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:04  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:13  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
/*
**
**  NAME:
**
**      upkvaxf.c
**
**  FACILITY:
**
**      IDL Stub Runtime Support
**
**  ABSTRACT:
**
**      This module contains code to extract information from a VAX
**      f_floating number and to initialize an UNPACKED_REAL structure
**      with those bits.
**
**		This module is meant to be used as an include file.
**
**  VERSION: DCE 1.0
**
*/

/*
**++
**  Functional Description:
**
**  This module contains code to extract information from a VAX
**  f_floating number and to initialize an UNPACKED_REAL structure
**  with those bits.
**
**  See the header files for a description of the UNPACKED_REAL
**  structure.
**
**  A VAX f_floating number in (16 bit words) looks like:
**
**      [0]: Sign bit, 8 exp bits (bias 128), 7 fraction bits
**      [1]: 16 more fraction bits
**
**      0.5 <= fraction < 1.0, MSB implicit
**
**
**  Implicit parameters:
**
**  	input_value: a pointer to the input parameter.
**
**  	r: an UNPACKED_REAL structure
**
**--
*/



	memcpy(&r[1], input_value, 4);

	/* Initialize FLAGS and perhaps set NEGATIVE bit */

	r[U_R_FLAGS] = (r[1] >> 15) & U_R_NEGATIVE;

	/* Extract VAX biased exponent */

	r[U_R_EXP] = (r[1] >> 7) & 0x000000FFL;

	if (r[U_R_EXP] == 0) {

		if (r[U_R_FLAGS])
			r[U_R_FLAGS] |= U_R_INVALID;
		else
			r[U_R_FLAGS] = U_R_ZERO;

	} else {

		/* Adjust for VAX 16 bit floating format */

		r[1] = ((r[1] << 16) | (r[1] >> 16));

		/* Add unpacked real bias and subtract VAX bias */

		r[U_R_EXP] += (U_R_BIAS - 128);

		/* Set hidden bit */

		r[1] |= 0x00800000L;

		/* Left justify fraction bits */

		r[1] <<= 8;

		/* Clear uninitialized parts for unpacked real */

		r[2] = 0;
		r[3] = 0;
		r[4] = 0;

	}
