#ifndef lint
static const char rcsid[] = "$Id: bindcall.c,v 1.1.1.1 1996/06/30 00:09:01 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: bindcall.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:01  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:11  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1991 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1991 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1991 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
/*
**
**      bindcall.c
**
**  FACILITY:
**
**      Interface Definition Language (IDL) Compiler
**
**  ABSTRACT:
**
**      Provides canned routines that may be used in conjunction with the
**      [binding_callout] ACF attribute.  These routines are called from a
**      client stub to possibly modify the binding handle, typically with
**      security information.
**
*/

#include <dce/rpc.h>
#include <dce/stubbase.h>

void rpc_ss_bind_authn_client
#ifdef IDL_PROTOTYPES
(
    rpc_binding_handle_t    *p_bh,      /* [io] Binding handle */
    rpc_if_handle_t         if_h,       /* [in] Interface handle */
    error_status_t          *p_st       /*[out] Return status */
)
#else
(p_bh, if_h, p_st)
    rpc_binding_handle_t    *p_bh;      /* [io] Binding handle */
    rpc_if_handle_t         if_h;       /* [in] Interface handle */
    error_status_t          *p_st;      /*[out] Return status */
#endif
{
    unsigned_char_t *princ_name;        /* Server principal name */

    /* Resolve binding handle if not fully bound */
    rpc_ep_resolve_binding(*p_bh, if_h, p_st);
    if (*p_st != rpc_s_ok)
        return;

    /* Get server principal name */
    rpc_mgmt_inq_server_princ_name(
        *p_bh,                          /* binding handle */
        rpc_c_authn_default,            /* default authentication service */
        &princ_name,                    /* server principal name */
        p_st);
    if (*p_st != rpc_s_ok)
        return;

    /* Set auth info in binding handle */
    rpc_binding_set_auth_info(
        *p_bh,                          /* binding handle */
        princ_name,                     /* server principal name */
        rpc_c_protect_level_default,    /* default protection level */
        rpc_c_authn_default,            /* default authentication service */
        NULL,                           /* def. auth credentials (login ctx) */
        rpc_c_authz_name,               /* authz based on cli principal name */
        p_st);
}
