/*
 * $Id: lex_lib.c,v 1.1.1.1 1996/06/30 00:09:00 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: lex_lib.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:00  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:17  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * COMPONENT_NAME: (LIBL) Lex Libraries
 *
 * FUNCTIONS: yylook, yyhlook, yyback, yyinput, yyoutput, yyunput,
 *
 * ORIGINS: This is the common bit of the lex code.  I generated it
 *	    under AIX 3.2.5, stripped out the multi-byte/wide character
 *	    support (because it doesn't work on Linux) and made it into
 *	    a common file so that I only had to fix one place and not
 *	    two (output from acf.l & nidl.l).
 *	    I also removed the c++ stuff as well because I got confused.
 *	    We bears of small brain are confused easily.
 *
 *		Ian Stewartson (June 14, 1995) (IanStewartson@solo.pipex.com)
 *
 */

int yylineno =1;

# define YYU(x)         x
# define NLSTATE        yyprevious=YYNEWLINE

# define YYCCLDOT       0x0001

unsigned char   yytext[YYLMAX];

struct yysvf    *yylstate [YYLMAX], **yylsp, **yyolsp;
unsigned char   yysbuf[YYLMAX];
unsigned char   *yysptr = yysbuf;
int             *yyfnd;
extern struct yysvf *yyestate;
int             yyprevious = YYNEWLINE;

# ifdef LEXDEBUG
int             debug;
# endif

yylook()
{
register struct yysvf *yystate, **lsp;
register struct yywork *yyt;
struct yysvf    *yyz;
int             yywch, yyfirst, yyw;
struct yywork   *yyr;
unsigned char   *yylastch;
/*
 * start off machines
 */
# ifdef LEXDEBUG
    debug = 1;
# endif

    yyfirst=1;
    if (!yymorfg)
        yylastch = yytext;
    else
    {
        yymorfg=0;
        yylastch = &(yytext[yyleng]);
    }

    for(;;)
    {
        lsp = yylstate;
        yyestate = yystate = yybgin;
        if (yyprevious==YYNEWLINE)
            yystate++;
        for (;;)
        {
# ifdef LEXDEBUG
            if(debug) fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
            yyt = yystate->yystoff;
            if(yyt == yycrank && !yyfirst)      /* may not be any transitions */
            {
                yyz = yystate->yyother;
                if(yyz == 0)
                    break;
                if(yyz->yystoff == yycrank)
                    break;
            }
            yywch = input();
            *yylastch++ = yywch;

            yyfirst=0;
        tryagain:
# ifdef LEXDEBUG
            if(debug) fprintf(yyout,"char %c\n", yywch);
# endif
            yyr = yyt;
            if ( (int)yyt > (int)yycrank)
            {
		yyt = yyr + yywch;
		if (yyt <= yytop && yyt->verify+yysvec == yystate)
		{
		    if(yyt->advance+yysvec == YYLERR) /* error transitions */
		    {
			unput(*--yylastch);
			break;
		    }
		    *lsp++ = yystate = yyt->advance+yysvec;
		    goto contin;
		}
            }

            else if ((int)yyt < (int)yycrank)   /* r < yycrank */
            {
                yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
                if(debug) fprintf(yyout,"compressed state\n");
# endif
		yyt = yyt + yywch;
		if(yyt <= yytop && yyt->verify+yysvec == yystate)
		{
		    if(yyt->advance+yysvec == YYLERR) /* error transitions */
		    {
			unput(*--yylastch);
			break;
		    }
		    *lsp++ = yystate = yyt->advance+yysvec;
		    goto contin;
		}
		yyt = yyr + YYU(yymatch[yywch]);
# ifdef LEXDEBUG
		if(debug) fprintf(yyout,"try fall back character %c\n", YYU(yymatch[yywch]));
# endif
		if(yyt <= yytop && yyt->verify+yysvec == yystate)
		{
		    if(yyt->advance+yysvec == YYLERR) /* error transition */
		    {
			unput(*--yylastch);
			break;
		    }
		    *lsp++ = yystate = yyt->advance+yysvec;
		    goto contin;
		}
            } /* r < yycrank */

            if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank)
            {
# ifdef LEXDEBUG
                if(debug) fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
                goto tryagain;
            }

            else
            {
                unput(*--yylastch);
                break;
            }
        contin:
# ifdef LEXDEBUG
            if(debug) fprintf(yyout,"state %d char %c\n",yystate-yysvec-1, yywch);
# endif
            ; /* contin: */
        } /* for(;;) */

# ifdef LEXDEBUG
        if(debug) fprintf(yyout,"stopped at %d with %c\n",*(lsp-1)-yysvec-1, yywch);
# endif

        while (lsp-- > yylstate)
        {
            *yylastch-- = 0;
            if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0)
            {
                yyolsp = lsp;
                if(yyextra[*yyfnd])             /* must backup */
                {
                    while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate)
                    {
                        lsp--;
                        unput(*yylastch--);
                    }
                }
                yyprevious = YYU(*yylastch);
                yylsp = lsp;
                yyleng = yylastch-yytext+1;
                yytext[yyleng] = 0;

# ifdef LEXDEBUG
                if(debug) fprintf(yyout,"\nmatch %s action %d\n", yytext, *yyfnd);
# endif

                return (*yyfnd++);
            }
            unput(*yylastch);
        }
        if (yytext[0] == 0  /* && feof(yyin) */)
        {
            yysptr=yysbuf;
	    return 0;
	}

        yyprevious = yytext[0] = input();
        if (yyprevious>0)
            output(yyprevious);
        yylastch=yytext;
# ifdef LEXDEBUG
        if(debug) putchar('\n');
# endif
    } /* for (;;) */

    return 0;
}
int yyback(int *p, int m)
{
    if (p==0) return(0);
    while (*p)
    {
        if (*p++ == m)
            return(1);
    }
    return(0);
}

/*
 * the following are only used in the lex library
 */
int yyinput()
{
    return(input());
}
int yyoutput(int c)
{
    output(c);
}
int yyunput(int c)
{
    unput(c);
}
