/*
 * $Id: lex_yy.c,v 1.1.1.1 1996/06/30 00:09:01 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: lex_yy.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:01  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:17  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */

#include <lex_lib_top.c>

 /*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */

/*
**  NAME:
**
**      IDL.L
**
**  FACILITY:
**
**      Interface Definition Language (IDL) Compiler
**
**  ABSTRACT:
**
**      This file defines the tokenizing rules for lexical analysis.
**
**  VERSION: DCE 1.0
**
*/



/*  Get definitions for token values    */
#define PROCESSING_LEX          /* Define before including nidl.h */
#define PROCESSING_NIDL_LEX     /* Define before including nidl.h */
#include <nidl.h>
#include <ctype.h>
#include <errors.h>
#include <nametbl.h>
#include <ast.h>
#include <astp.h>
#include <y_tab.h>
#include <driver.h>
#include <command.h>

boolean search_attributes_table = false ;

#ifndef MAX_INCLUSION_DEPTH
#define MAX_INCLUSION_DEPTH 10
#endif

static  FILE *inclusion_stack[MAX_INCLUSION_DEPTH] ;
static  int  stack_depth = 0 ;


void commenteof (
#ifdef PROTO
    void
#endif
);

int yylex (
#ifdef PROTO
    void
#endif
);

int yylook (
#ifdef PROTO
    void
#endif
);

static void read_c_comment (
#ifdef PROTO
    void
#endif
);

static void yymark (
#ifdef PROTO
    void
#endif
);

static int yywrap (
#ifdef PROTO
    void
#endif
);

static int yyuuid (
#ifdef PROTO
    char *s,
    nidl_uuid_t *uuid
#endif
);

static int yyolduuid (
#ifdef PROTO
    char *s,
    nidl_uuid_t *uuid
#endif
);



int KEYWORDS_screen (
#ifdef PROTO
    char *token,
    NAMETABLE_id_t *id
#endif
);

char *KEYWORDS_lookup_text (
#ifdef PROTO
    long token
#endif
);

int yyinput (
#ifdef PROTO
    void
#endif
);

#ifndef _AIX
int yyoutput (
#ifdef PROTO
    int c
#endif
);

int yyunput (
#ifdef PROTO
    int c
#endif
);
#endif

int yyback (
#ifdef PROTO
    int *p,

    int m
#endif
);

int yylex(){
int nstr; extern int yyprevious;
if (__once_yylex) {
      yysetlocale();
      if (yyin == NULL) yyin = stdin;
      if (yyout == NULL) yyout = stdout;
      __once_yylex = 0; }

while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
           { /* No action, and no return */ }
/*NOTREACHED*/ break;
case 2:
            {return(COLON);}
/*NOTREACHED*/ break;
case 3:
            {return(COMMA);}
/*NOTREACHED*/ break;
case 4:
           {return(DOTDOT);}
/*NOTREACHED*/ break;
case 5:
            {return(EQUAL);}
/*NOTREACHED*/ break;
case 6:
             {return(LBRACKET);}
/*NOTREACHED*/ break;
case 7:
            {return(LPAREN);}
/*NOTREACHED*/ break;
case 8:
             {return(RBRACKET);}
/*NOTREACHED*/ break;
case 9:
            {return(RPAREN);}
/*NOTREACHED*/ break;
case 10:
            {return(SEMI);}
/*NOTREACHED*/ break;
case 11:
            {return(STAR);}
/*NOTREACHED*/ break;
case 12:
            {return(LBRACE);}
/*NOTREACHED*/ break;
case 13:
          {return(LBRACE);}
/*NOTREACHED*/ break;
case 14:
            {return(RBRACE);}
/*NOTREACHED*/ break;
case 15:
          {return(RBRACE);}
/*NOTREACHED*/ break;
case 16:
            {return(QUESTION);}
/*NOTREACHED*/ break;
case 17:
            {return(BAR);}
/*NOTREACHED*/ break;
case 18:
           {return(BARBAR);}
/*NOTREACHED*/ break;
case 19:
            {return(LANGLE);}
/*NOTREACHED*/ break;
case 20:
           {return(LANGLEANGLE);}
/*NOTREACHED*/ break;
case 21:
            {return(RANGLE);}
/*NOTREACHED*/ break;
case 22:
           {return(RANGLEANGLE);}
/*NOTREACHED*/ break;
case 23:
            {return(AMP);}
/*NOTREACHED*/ break;
case 24:
           {return(AMPAMP);}
/*NOTREACHED*/ break;
case 25:
           {return(LESSEQUAL);}
/*NOTREACHED*/ break;
case 26:
           {return(GREATEREQUAL);}
/*NOTREACHED*/ break;
case 27:
           {return(EQUALEQUAL);}
/*NOTREACHED*/ break;
case 28:
            {return(CARET);}
/*NOTREACHED*/ break;
case 29:
            {return(PLUS);}
/*NOTREACHED*/ break;
case 30:
            {return(MINUS);}
/*NOTREACHED*/ break;
case 31:
            {return(NOT);}
/*NOTREACHED*/ break;
case 32:
           {return(NOTEQUAL);}
/*NOTREACHED*/ break;
case 33:
            {return(SLASH);}
/*NOTREACHED*/ break;
case 34:
            {return(PERCENT);}
/*NOTREACHED*/ break;
case 35:
            {return(TILDE);}
/*NOTREACHED*/ break;
case 36:
           { yymark() ;}
/*NOTREACHED*/ break;
case 37:
    { log_error(yylineno-1,NIDL_USETRANS); }
/*NOTREACHED*/ break;
case 38:
   { log_error(yylineno-1,NIDL_USETRANS); }
/*NOTREACHED*/ break;
case 39:
   { log_error(yylineno-1,NIDL_USETRANS); }
/*NOTREACHED*/ break;
case 40:
  {
    /* Simple escaped single quote character literal */
    yylval.y_char = '\'';
    return(CHAR);
}
/*NOTREACHED*/ break;
case 41:
 {
    /* Simple character constants */
    yylval.y_char = yytext [1];
    return(CHAR);
}
/*NOTREACHED*/ break;
case 42:
{
    /* Character constants with an escape */
    if ((yyleng > 6) || (yyleng < 4)) {
          log_error(yylineno, NIDL_INVCHARLIT);
          return(UNKNOWN);
    }
    switch (yytext[2]) {
        case 'n':   yylval.y_char = '\n'; break;
        case 't':   yylval.y_char = '\t'; break;
        case 'v':   yylval.y_char = '\v'; break;
        case 'b':   yylval.y_char = '\b'; break;
        case 'r':   yylval.y_char = '\r'; break;
        case 'f':   yylval.y_char = '\f'; break;
        case 'a':   yylval.y_char = AUDIBLE_BELL; break;
        case '\\':  yylval.y_char = '\\'; break;
        case '?':   yylval.y_char = '\?'; break;
        case '\'':  yylval.y_char = '\''; break;
        case '\"':  yylval.y_char = '\"'; break;
        case 'x' :  {
            /* Hex literal value */
            int char_value;
            if (sscanf((char *)&yytext[3],"%x",&char_value) != 1)
                log_error(yylineno, NIDL_INVCHARLIT);
            else
            {
                yylval.y_char = (char )char_value;
                log_warning(yylineno, NIDL_NONPORTCHAR);
            }
            break;
        }
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '7':   {
            /* Octal literal value */
            int char_value;
            if (sscanf((char *)&yytext[2],"%o",&char_value) != 1)
                log_error(yylineno, NIDL_INVCHARLIT);
            else
            {
                yylval.y_char = (char )char_value;
                log_warning(yylineno, NIDL_NONPORTCHAR);
            }
            break;
        }
        default:
            /* all others are illegal */
            log_error(yylineno, NIDL_INVCHARLIT);
            return(UNKNOWN);
    }

    return (CHAR);
}
/*NOTREACHED*/ break;
case 43:
 {
    char stripped_string[max_string_len] ;
    if (yytext[yyleng-1] == '\\')
        yymore(); /* Allow \" within strings, look for next " */
    else {
    yylval.y_string = STRTAB_add_string((char *)&yytext[1]);
        if (input() == '\n')
            log_error(yylineno, NIDL_STRUNTERM);
        return(STRING);
    }
}
/*NOTREACHED*/ break;
case 44:
   { read_c_comment(); }
/*NOTREACHED*/ break;
case 45:
   {
    int token;
    NAMETABLE_id_t id;
    /* If id is too long, truncate it and issue a warning */
    if (yyleng > MAX_ID) {
        NAMETABLE_id_t id;
        char *identifier;
        id = NAMETABLE_add_id((char *)yytext);
        NAMETABLE_id_to_string(id, &identifier);
        log_warning(yylineno, NIDL_IDTOOLONG, identifier, MAX_ID);
        /* Truncate the string */
        yytext[MAX_ID] = '\0';
        id = NAMETABLE_add_id((char *)yytext);
    }
    if ((token = KEYWORDS_screen((char *)yytext, &id))==IDENTIFIER) {
        yylval.y_id = id;
    }
    else {
        yylval.y_id = NAMETABLE_NIL_ID;
    }
    return token;
}
/*NOTREACHED*/ break;
case 46:
  {
    int unsigned_int = false;
#if defined(vax) && defined(ultrix)
    float fval;
    char *fval_fmt = "%f";
#define FLOAT float
#else
    double fval;
    char *fval_fmt = "%lf";
#define FLOAT double
#endif

    /*
    ** Remove suffix for long and/or unsigned, if present
    */
    if ((yytext[yyleng-1] == 'L') ||
        (yytext[yyleng-1] == 'l') ||
        (yytext[yyleng-1] == 'U') ||
        (yytext[yyleng-1] == 'u'))
    {
        if ((yytext[yyleng-1] == 'U') ||
            (yytext[yyleng-1] == 'u'))
                unsigned_int = true;
        yytext[yyleng-1] = '\0';
        if ((yytext[yyleng-2] == 'L') ||
            (yytext[yyleng-2] == 'l') ||
            (yytext[yyleng-2] == 'U') ||
            (yytext[yyleng-2] == 'u'))
        {
            if ((yytext[yyleng-2] == 'U') ||
                (yytext[yyleng-2] == 'u'))
                    unsigned_int = true;
            yytext[yyleng-2] = '\0';
        }
    }

    /*
    ** Convert to a float to get overflow detection.
    */
    sscanf((char *)yytext, fval_fmt, &fval);
    yylval.y_ival = 0;

    /*
    ** Throw out integers that are out of range.
    */
    if (unsigned_int &&
        ((strlen((char *)yytext) > 10)
        || (fval > (FLOAT)ASTP_C_ULONG_MAX)
        || (fval < (FLOAT)ASTP_C_ULONG_MIN)
        ))
        log_error(yylineno, NIDL_INTOVERFLOW, KEYWORDS_lookup_text(LONG_KW));
    else if ((strlen((char *)yytext) > 11) ||
        (fval > (FLOAT)ASTP_C_LONG_MAX) ||
        (fval < (FLOAT)ASTP_C_LONG_MIN)
        )
        log_error(yylineno, NIDL_INTOVERFLOW, KEYWORDS_lookup_text(LONG_KW));
    else {
        sscanf((char *)yytext, "%i", &yylval.y_ival);
    }


    if ((yytext[0] == '0') && (strlen((char *)yytext) != strspn((char *)yytext,"01234567"))) {
        char    *int_text;              /* Text of integer */
        STRTAB_str_t string_id;         /* Entry in string table of integer */
        string_id = STRTAB_add_string(yytext_p);
        STRTAB_str_to_string(string_id, &int_text);
        log_error(yylineno, NIDL_INVOCTDIGIT, int_text);
    }

    return(INTEGER_NUMERIC);
}
/*NOTREACHED*/ break;
case 47:
{
    /*
    ** Remove suffix for long and/or unsigned, if present
    */
    if ((yytext[yyleng-1] == 'L') ||
        (yytext[yyleng-1] == 'l') ||
        (yytext[yyleng-1] == 'U') ||
        (yytext[yyleng-1] == 'u'))
    {
        yytext[yyleng-1] = '\0';
        if ((yytext[yyleng-2] == 'L') ||
            (yytext[yyleng-2] == 'l') ||
            (yytext[yyleng-2] == 'U') ||
            (yytext[yyleng-2] == 'u'))
        {
            yytext[yyleng-2] = '\0';
        }
    }

    /*
    ** Scan the hex integer and return the value as an integer
    */
    sscanf((char *)&yytext[2],"%lx", &yylval.y_ival);
    return(INTEGER_NUMERIC);
}
/*NOTREACHED*/ break;
case 48:
{
    yylval.y_float = STRTAB_add_string((char *)yytext);
    return(FLOAT_NUMERIC);
}
/*NOTREACHED*/ break;
case 49:
     {   return (yyuuid((char *)&yytext[1], &yylval.y_uuid)); }
/*NOTREACHED*/ break;
case 50:
  {   return (yyolduuid((char *)&yytext[1], &yylval.y_uuid)); }
/*NOTREACHED*/ break;
case 51:
    {   return (UNKNOWN); }
/*NOTREACHED*/ break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

void commenteof()
{
    log_error (yylineno, NIDL_COMMENTEOF);
    nidl_terminate();
}

static int yywrap ()
{
    int    c ;
    if ((c = input()) != 0)
    {
        unput(c) ;
        return (0) ;
    }
    yylineno = 1 ;
        return (1);
}

static void yymark()
{
    char    *source ; /* Source file name in #line directive */
    int prev_lineno = yylineno - 1;

    source = (char *) MALLOC(yyleng) ;
    source[0] ='\0';
    /* If the format wasn't # line {int} {string}, then reparse without "line" identifier */
    if (sscanf((char *)yytext, "# line %d %s", &yylineno, source) < 1)
    {
	if (sscanf((char *)yytext, "# %d %s", &yylineno, source) < 1)
        {
            log_warning(prev_lineno, NIDL_CPPCMDOPT,
#ifdef VMS
                (CMD_DCL_interface) ? "/PREPROCESS" :
#endif
                "-cpp_cmd");
        }
    }

    /* If text included a source file name, set name for error reporting. */
    if (source[0] != '\0'
        &&  !(source[0] == '"' && source[1] == '"'))
    {
        char    file_name[max_string_len];

        /* Strip the quotes. */
        strcpy(file_name, &source[1]);
        file_name[strlen(file_name)-1] = '\0';

        set_name_for_errors(file_name);
    }

    FREE(source);
}

static void read_c_comment()
{
    register int c;

    /* While not EOF look for end of comment */
    while ((c = input()))
    {
        if (c == '*')
        {
            if ((c = input()) == '/')
                break ;
            else
                unput(c) ;
        }
    }

    /* Didn't find end comment before EOF, issue error */
    if (c == 0) commenteof();
}


static int yyolduuid(s, uuid)
char *s;
nidl_uuid_t *uuid;
{
    unsigned32 v1_time_high;
    unsigned32 v1_time_low;
    unsigned32 v1_reserved = 0;  /* v1 UUID always zero here */
    unsigned32 v1_family;
    unsigned32 v1_host[7];
    int        i;
    char *uuid_str;

    if (sscanf(s, "%8X%4X.%2X.%2X.%2X.%2X.%2X.%2X.%2X.%2X",
              &v1_time_high, &v1_time_low, &v1_family,
              &v1_host[0], &v1_host[1], &v1_host[2], &v1_host[3],
              &v1_host[4], &v1_host[5], &v1_host[6]) != 10)
        log_error(yylineno, NIDL_SYNTAXUUID);

    /* scanf only returns ints, so scan into ints and copy into smaller types */
    uuid->time_low                  = v1_time_high;
    uuid->time_mid                  = v1_time_low;
    uuid->time_hi_and_version       = v1_reserved;
    uuid->clock_seq_hi_and_reserved = v1_family;
    uuid->clock_seq_low             = v1_host[0];

    for (i=0; i < 6; i++)
        uuid->node[i] = v1_host[i+1];

    uuid_str = (char *)malloc(sizeof("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"));

    sprintf(uuid_str, "%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X",
              uuid->time_low, uuid->time_mid, uuid->time_hi_and_version,
              uuid->clock_seq_hi_and_reserved, uuid->clock_seq_low,
              uuid->node[0], uuid->node[1], uuid->node[2],
              uuid->node[3], uuid->node[4], uuid->node[5]);

    log_warning(yylineno, NIDL_OLDUUID);
    log_warning(yylineno, NIDL_NEWUUID, uuid_str);
    return (UUID_REP) ;
}

static int yyuuid(s, uuid)
char *s;
nidl_uuid_t *uuid;
{
    int i;
    unsigned32 time_low, time_mid, time_hi_and_version,
              clock_seq_hi_and_reserved, clock_seq_low,
              node[6];

    if (sscanf(s, "%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X",
              &time_low, &time_mid, &time_hi_and_version,
              &clock_seq_hi_and_reserved, &clock_seq_low,
              &node[0], &node[1], &node[2],
              &node[3], &node[4], &node[5]) != 11)
        log_error(yylineno, NIDL_SYNTAXUUID);

    /* scanf only returns ints, so scan into ints and copy into smaller types */
    uuid->time_low = time_low;
    uuid->time_mid = time_mid;
    uuid->time_hi_and_version = time_hi_and_version;
    uuid->clock_seq_hi_and_reserved = clock_seq_hi_and_reserved;
    uuid->clock_seq_low = clock_seq_low;
    for (i=0; i < 6; i++)
        uuid->node[i] = node[i];
    return (UUID_REP);
}
int yyvstop[] = {
0,

51,
0,

1,
51,
0,

1,
0,

31,
51,
0,

43,
51,
0,

45,
51,
0,

34,
51,
0,

23,
51,
0,

51,
0,

7,
51,
0,

9,
51,
0,

11,
51,
0,

29,
51,
0,

3,
51,
0,

30,
51,
0,

51,
0,

33,
51,
0,

46,
51,
0,

46,
51,
0,

2,
51,
0,

10,
51,
0,

19,
51,
0,

5,
51,
0,

21,
51,
0,

16,
51,
0,

6,
51,
0,

8,
51,
0,

28,
51,
0,

12,
51,
0,

17,
51,
0,

14,
51,
0,

35,
51,
0,

51,
0,

34,
51,
0,

32,
0,

43,
0,

45,
0,

24,
0,

46,
0,

4,
0,

44,
0,

46,
0,

46,
0,

46,
0,

47,
0,

20,
0,

25,
0,

27,
0,

26,
0,

22,
0,

18,
0,

36,
0,

41,
0,

42,
0,

48,
0,

46,
0,

47,
0,

47,
0,

13,
0,

15,
0,

42,
0,

40,
0,

48,
0,

47,
0,

37,
0,

39,
0,

38,
0,

49,
0,

50,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
	0,0,	0,0,	1,3,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	1,4,	1,5,
	38,0,	75,83,	96,99,	97,100,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	1,6,	1,7,
	38,0,	1,8,	1,9,	1,10,
	1,11,	1,12,	1,13,	1,14,
	1,15,	1,16,	1,17,	1,18,
	1,19,	1,20,	1,21,	1,21,
	1,21,	1,21,	1,21,	1,21,
	1,21,	1,21,	1,21,	1,22,
	1,23,	1,24,	1,25,	1,26,
	1,27,	6,37,	1,8,	10,40,
	18,46,	19,47,	7,38,	24,53,
	24,54,	25,55,	26,56,	26,57,
	27,58,	36,62,	7,38,	7,0,
	17,45,	17,45,	17,45,	17,45,
	17,45,	17,45,	17,45,	17,45,
	17,45,	17,45,	36,63,	41,65,
	1,28,	1,3,	1,29,	1,30,
	58,73,	63,76,	58,74,	50,70,
	64,77,	67,79,	76,84,	7,0,
	84,87,	7,38,	85,88,	87,90,
	7,38,	36,62,	88,91,	51,70,
	90,93,	91,94,	108,110,	109,111,
	77,85,	7,38,	114,116,	119,121,
	120,122,	126,128,	36,64,	129,131,
	1,31,	1,32,	1,33,	1,34,
	2,6,	32,59,	2,35,	50,70,
	2,36,	2,10,	7,38,	2,12,
	2,13,	2,14,	2,15,	2,16,
	2,17,	2,18,	2,19,	51,70,
	2,21,	2,21,	2,21,	2,21,
	2,21,	2,21,	2,21,	2,21,
	2,21,	2,22,	2,23,	2,24,
	2,25,	2,26,	2,27,	132,134,
	138,140,	7,38,	66,0,	8,39,
	48,69,	48,69,	48,69,	48,69,
	48,69,	48,69,	48,69,	48,69,
	48,69,	48,69,	144,146,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	150,152,	2,28,	0,0,
	2,29,	2,30,	0,0,	66,78,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	2,31,	2,32,
	2,33,	2,34,	8,39,	0,0,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	8,39,	8,39,
	8,39,	8,39,	11,41,	0,0,
	62,75,	62,75,	45,50,	62,75,
	0,0,	69,81,	11,41,	11,0,
	71,82,	12,43,	12,43,	45,51,
	12,43,	0,0,	69,81,	72,82,
	93,96,	93,96,	0,0,	93,96,
	0,0,	94,97,	94,97,	62,75,
	94,97,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	11,41,
	12,43,	11,41,	45,50,	0,0,
	11,0,	69,81,	0,0,	93,96,
	71,82,	0,0,	0,0,	45,51,
	94,97,	11,41,	69,81,	72,82,
	12,44,	12,44,	12,44,	12,44,
	12,44,	12,44,	12,44,	12,44,
	12,44,	12,44,	0,0,	0,0,
	0,0,	0,0,	11,41,	0,0,
	0,0,	12,44,	12,44,	12,44,
	12,44,	12,44,	12,44,	0,0,
	0,0,	20,48,	0,0,	20,49,
	20,49,	20,49,	20,49,	20,49,
	20,49,	20,49,	20,49,	20,49,
	20,49,	155,155,	155,155,	0,0,
	155,155,	11,42,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	12,44,	12,44,	12,44,
	12,44,	12,44,	12,44,	20,50,
	0,0,	35,60,	0,0,	0,0,
	155,155,	0,0,	0,0,	0,0,
	20,51,	35,60,	35,61,	20,52,
	21,48,	155,157,	21,49,	21,49,
	21,49,	21,49,	21,49,	21,49,
	21,49,	21,49,	21,49,	21,49,
	42,66,	0,0,	156,156,	156,156,
	0,0,	156,156,	0,0,	20,50,
	42,66,	42,0,	35,60,	0,0,
	35,60,	0,0,	0,0,	35,60,
	20,51,	0,0,	21,50,	20,52,
	0,0,	0,0,	0,0,	0,0,
	35,60,	156,156,	0,0,	21,51,
	0,0,	0,0,	0,0,	0,0,
	0,0,	42,66,	156,158,	42,66,
	0,0,	0,0,	42,67,	0,0,
	0,0,	35,60,	0,0,	0,0,
	0,0,	0,0,	0,0,	42,66,
	0,0,	0,0,	21,50,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	21,51,
	0,0,	0,0,	0,0,	0,0,
	42,66,	0,0,	0,0,	0,0,
	35,60,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	44,68,
	44,68,	44,68,	44,68,	44,68,
	44,68,	44,68,	44,68,	44,68,
	44,68,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	42,66,
	44,68,	44,68,	44,68,	44,68,
	44,68,	44,68,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	52,52,	52,52,	52,52,
	52,52,	52,52,	52,52,	52,52,
	52,52,	52,52,	52,52,	0,0,
	44,68,	44,68,	44,68,	44,68,
	44,68,	44,68,	52,52,	52,52,
	52,52,	52,52,	52,52,	52,52,
	0,0,	0,0,	0,0,	0,0,
	0,0,	52,71,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	52,72,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	52,52,	52,52,
	52,52,	52,52,	52,52,	52,52,
	0,0,	0,0,	0,0,	0,0,
	0,0,	52,71,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	52,72,	68,80,
	68,80,	68,80,	68,80,	68,80,
	68,80,	68,80,	68,80,	68,80,
	68,80,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	68,80,	68,80,	68,80,	68,80,
	68,80,	68,80,	80,86,	80,86,
	80,86,	80,86,	80,86,	80,86,
	80,86,	80,86,	80,86,	80,86,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	80,86,
	80,86,	80,86,	80,86,	80,86,
	80,86,	0,0,	0,0,	0,0,
	68,80,	68,80,	68,80,	68,80,
	68,80,	68,80,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	86,89,	86,89,	86,89,	86,89,
	86,89,	86,89,	86,89,	86,89,
	86,89,	86,89,	0,0,	80,86,
	80,86,	80,86,	80,86,	80,86,
	80,86,	86,89,	86,89,	86,89,
	86,89,	86,89,	86,89,	89,92,
	89,92,	89,92,	89,92,	89,92,
	89,92,	89,92,	89,92,	89,92,
	89,92,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	89,92,	89,92,	89,92,	89,92,
	89,92,	89,92,	0,0,	0,0,
	0,0,	86,89,	86,89,	86,89,
	86,89,	86,89,	86,89,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	92,95,	92,95,	92,95,
	92,95,	92,95,	92,95,	92,95,
	92,95,	92,95,	92,95,	0,0,
	89,92,	89,92,	89,92,	89,92,
	89,92,	89,92,	92,95,	92,95,
	92,95,	92,95,	92,95,	92,95,
	95,98,	95,98,	95,98,	95,98,
	95,98,	95,98,	95,98,	95,98,
	95,98,	95,98,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	95,98,	95,98,	95,98,
	95,98,	95,98,	95,98,	0,0,
	0,0,	0,0,	92,95,	92,95,
	92,95,	92,95,	92,95,	92,95,
	0,0,	0,0,	0,0,	98,101,
	0,0,	0,0,	98,102,	98,102,
	98,102,	98,102,	98,102,	98,102,
	98,102,	98,102,	98,102,	98,102,
	0,0,	95,98,	95,98,	95,98,
	95,98,	95,98,	95,98,	98,102,
	98,102,	98,102,	98,102,	98,102,
	98,102,	101,103,	101,103,	101,103,
	101,103,	101,103,	101,103,	101,103,
	101,103,	101,103,	101,103,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	101,103,	101,103,
	101,103,	101,103,	101,103,	101,103,
	0,0,	0,0,	0,0,	98,102,
	98,102,	98,102,	98,102,	98,102,
	98,102,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	102,104,
	102,104,	102,104,	102,104,	102,104,
	102,104,	102,104,	102,104,	102,104,
	102,104,	0,0,	101,103,	101,103,
	101,103,	101,103,	101,103,	101,103,
	102,104,	102,104,	102,104,	102,104,
	102,104,	102,104,	103,105,	103,105,
	103,105,	103,105,	103,105,	103,105,
	103,105,	103,105,	103,105,	103,105,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	103,105,
	103,105,	103,105,	103,105,	103,105,
	103,105,	0,0,	0,0,	0,0,
	102,104,	102,104,	102,104,	102,104,
	102,104,	102,104,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	104,106,	104,106,	104,106,	104,106,
	104,106,	104,106,	104,106,	104,106,
	104,106,	104,106,	0,0,	103,105,
	103,105,	103,105,	103,105,	103,105,
	103,105,	104,106,	104,106,	104,106,
	104,106,	104,106,	104,106,	105,107,
	105,107,	105,107,	105,107,	105,107,
	105,107,	105,107,	105,107,	105,107,
	105,107,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	105,107,	105,107,	105,107,	105,107,
	105,107,	105,107,	0,0,	0,0,
	0,0,	104,106,	104,106,	104,106,
	104,106,	104,106,	104,106,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	106,108,	106,108,	106,108,
	106,108,	106,108,	106,108,	106,108,
	106,108,	106,108,	106,108,	0,0,
	105,107,	105,107,	105,107,	105,107,
	105,107,	105,107,	106,108,	106,108,
	106,108,	106,108,	106,108,	106,108,
	107,109,	107,109,	107,109,	107,109,
	107,109,	107,109,	107,109,	107,109,
	107,109,	107,109,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	107,109,	107,109,	107,109,
	107,109,	107,109,	107,109,	0,0,
	0,0,	0,0,	106,108,	106,108,
	106,108,	106,108,	106,108,	106,108,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	110,112,	110,112,
	110,112,	110,112,	110,112,	110,112,
	110,112,	110,112,	110,112,	110,112,
	0,0,	107,109,	107,109,	107,109,
	107,109,	107,109,	107,109,	110,112,
	110,112,	110,112,	110,112,	110,112,
	110,112,	111,113,	111,113,	111,113,
	111,113,	111,113,	111,113,	111,113,
	111,113,	111,113,	111,113,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	111,113,	111,113,
	111,113,	111,113,	111,113,	111,113,
	0,0,	0,0,	0,0,	110,112,
	110,112,	110,112,	110,112,	110,112,
	110,112,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	112,114,
	112,114,	112,114,	112,114,	112,114,
	112,114,	112,114,	112,114,	112,114,
	112,114,	0,0,	111,113,	111,113,
	111,113,	111,113,	111,113,	111,113,
	112,114,	112,114,	112,114,	112,114,
	112,114,	112,114,	113,115,	113,115,
	113,115,	113,115,	113,115,	113,115,
	113,115,	113,115,	113,115,	113,115,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	113,115,
	113,115,	113,115,	113,115,	113,115,
	113,115,	0,0,	0,0,	0,0,
	112,114,	112,114,	112,114,	112,114,
	112,114,	112,114,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	115,117,	115,117,	115,117,	115,117,
	115,117,	115,117,	115,117,	115,117,
	115,117,	115,117,	0,0,	113,115,
	113,115,	113,115,	113,115,	113,115,
	113,115,	115,117,	115,117,	115,117,
	115,117,	115,117,	115,117,	116,118,
	116,118,	116,118,	116,118,	116,118,
	116,118,	116,118,	116,118,	116,118,
	116,118,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	116,118,	116,118,	116,118,	116,118,
	116,118,	116,118,	0,0,	0,0,
	0,0,	115,117,	115,117,	115,117,
	115,117,	115,117,	115,117,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	117,119,	117,119,	117,119,
	117,119,	117,119,	117,119,	117,119,
	117,119,	117,119,	117,119,	0,0,
	116,118,	116,118,	116,118,	116,118,
	116,118,	116,118,	117,119,	117,119,
	117,119,	117,119,	117,119,	117,119,
	118,120,	118,120,	118,120,	118,120,
	118,120,	118,120,	118,120,	118,120,
	118,120,	118,120,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	118,120,	118,120,	118,120,
	118,120,	118,120,	118,120,	0,0,
	0,0,	0,0,	117,119,	117,119,
	117,119,	117,119,	117,119,	117,119,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	121,123,	121,123,
	121,123,	121,123,	121,123,	121,123,
	121,123,	121,123,	121,123,	121,123,
	0,0,	118,120,	118,120,	118,120,
	118,120,	118,120,	118,120,	121,123,
	121,123,	121,123,	121,123,	121,123,
	121,123,	122,124,	122,124,	122,124,
	122,124,	122,124,	122,124,	122,124,
	122,124,	122,124,	122,124,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	122,124,	122,124,
	122,124,	122,124,	122,124,	122,124,
	0,0,	0,0,	0,0,	121,123,
	121,123,	121,123,	121,123,	121,123,
	121,123,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	123,125,
	123,125,	123,125,	123,125,	123,125,
	123,125,	123,125,	123,125,	123,125,
	123,125,	0,0,	122,124,	122,124,
	122,124,	122,124,	122,124,	122,124,
	123,125,	123,125,	123,125,	123,125,
	123,125,	123,125,	124,126,	124,126,
	124,126,	124,126,	124,126,	124,126,
	124,126,	124,126,	124,126,	124,126,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	124,126,
	124,126,	124,126,	124,126,	124,126,
	124,126,	0,0,	0,0,	0,0,
	123,125,	123,125,	123,125,	123,125,
	123,125,	123,125,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	125,127,	125,127,	125,127,	125,127,
	125,127,	125,127,	125,127,	125,127,
	125,127,	125,127,	0,0,	124,126,
	124,126,	124,126,	124,126,	124,126,
	124,126,	125,127,	125,127,	125,127,
	125,127,	125,127,	125,127,	127,129,
	127,129,	127,129,	127,129,	127,129,
	127,129,	127,129,	127,129,	127,129,
	127,129,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	127,129,	127,129,	127,129,	127,129,
	127,129,	127,129,	0,0,	0,0,
	0,0,	125,127,	125,127,	125,127,
	125,127,	125,127,	125,127,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	128,130,	128,130,	128,130,
	128,130,	128,130,	128,130,	128,130,
	128,130,	128,130,	128,130,	0,0,
	127,129,	127,129,	127,129,	127,129,
	127,129,	127,129,	128,130,	128,130,
	128,130,	128,130,	128,130,	128,130,
	130,132,	130,132,	130,132,	130,132,
	130,132,	130,132,	130,132,	130,132,
	130,132,	130,132,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	130,132,	130,132,	130,132,
	130,132,	130,132,	130,132,	0,0,
	0,0,	0,0,	128,130,	128,130,
	128,130,	128,130,	128,130,	128,130,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	131,133,	131,133,
	131,133,	131,133,	131,133,	131,133,
	131,133,	131,133,	131,133,	131,133,
	0,0,	130,132,	130,132,	130,132,
	130,132,	130,132,	130,132,	131,133,
	131,133,	131,133,	131,133,	131,133,
	131,133,	133,135,	133,135,	133,135,
	133,135,	133,135,	133,135,	133,135,
	133,135,	133,135,	133,135,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	133,135,	133,135,
	133,135,	133,135,	133,135,	133,135,
	0,0,	0,0,	0,0,	131,133,
	131,133,	131,133,	131,133,	131,133,
	131,133,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	134,136,
	134,136,	134,136,	134,136,	134,136,
	134,136,	134,136,	134,136,	134,136,
	134,136,	0,0,	133,135,	133,135,
	133,135,	133,135,	133,135,	133,135,
	134,136,	134,136,	134,136,	134,136,
	134,136,	134,136,	135,137,	135,137,
	135,137,	135,137,	135,137,	135,137,
	135,137,	135,137,	135,137,	135,137,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	135,137,
	135,137,	135,137,	135,137,	135,137,
	135,137,	0,0,	0,0,	0,0,
	134,136,	134,136,	134,136,	134,136,
	134,136,	134,136,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	136,138,	136,138,	136,138,	136,138,
	136,138,	136,138,	136,138,	136,138,
	136,138,	136,138,	0,0,	135,137,
	135,137,	135,137,	135,137,	135,137,
	135,137,	136,138,	136,138,	136,138,
	136,138,	136,138,	136,138,	137,139,
	137,139,	137,139,	137,139,	137,139,
	137,139,	137,139,	137,139,	137,139,
	137,139,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	137,139,	137,139,	137,139,	137,139,
	137,139,	137,139,	0,0,	0,0,
	0,0,	136,138,	136,138,	136,138,
	136,138,	136,138,	136,138,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	139,141,	139,141,	139,141,
	139,141,	139,141,	139,141,	139,141,
	139,141,	139,141,	139,141,	0,0,
	137,139,	137,139,	137,139,	137,139,
	137,139,	137,139,	139,141,	139,141,
	139,141,	139,141,	139,141,	139,141,
	140,142,	140,142,	140,142,	140,142,
	140,142,	140,142,	140,142,	140,142,
	140,142,	140,142,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	140,142,	140,142,	140,142,
	140,142,	140,142,	140,142,	0,0,
	0,0,	0,0,	139,141,	139,141,
	139,141,	139,141,	139,141,	139,141,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	141,143,	141,143,
	141,143,	141,143,	141,143,	141,143,
	141,143,	141,143,	141,143,	141,143,
	0,0,	140,142,	140,142,	140,142,
	140,142,	140,142,	140,142,	141,143,
	141,143,	141,143,	141,143,	141,143,
	141,143,	142,144,	142,144,	142,144,
	142,144,	142,144,	142,144,	142,144,
	142,144,	142,144,	142,144,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	142,144,	142,144,
	142,144,	142,144,	142,144,	142,144,
	0,0,	0,0,	0,0,	141,143,
	141,143,	141,143,	141,143,	141,143,
	141,143,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	143,145,
	143,145,	143,145,	143,145,	143,145,
	143,145,	143,145,	143,145,	143,145,
	143,145,	0,0,	142,144,	142,144,
	142,144,	142,144,	142,144,	142,144,
	143,145,	143,145,	143,145,	143,145,
	143,145,	143,145,	145,147,	145,147,
	145,147,	145,147,	145,147,	145,147,
	145,147,	145,147,	145,147,	145,147,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	145,147,
	145,147,	145,147,	145,147,	145,147,
	145,147,	0,0,	0,0,	0,0,
	143,145,	143,145,	143,145,	143,145,
	143,145,	143,145,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	146,148,	146,148,	146,148,	146,148,
	146,148,	146,148,	146,148,	146,148,
	146,148,	146,148,	0,0,	145,147,
	145,147,	145,147,	145,147,	145,147,
	145,147,	146,148,	146,148,	146,148,
	146,148,	146,148,	146,148,	147,149,
	147,149,	147,149,	147,149,	147,149,
	147,149,	147,149,	147,149,	147,149,
	147,149,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	147,149,	147,149,	147,149,	147,149,
	147,149,	147,149,	0,0,	0,0,
	0,0,	146,148,	146,148,	146,148,
	146,148,	146,148,	146,148,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	148,150,	148,150,	148,150,
	148,150,	148,150,	148,150,	148,150,
	148,150,	148,150,	148,150,	0,0,
	147,149,	147,149,	147,149,	147,149,
	147,149,	147,149,	148,150,	148,150,
	148,150,	148,150,	148,150,	148,150,
	149,151,	149,151,	149,151,	149,151,
	149,151,	149,151,	149,151,	149,151,
	149,151,	149,151,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	149,151,	149,151,	149,151,
	149,151,	149,151,	149,151,	0,0,
	0,0,	0,0,	148,150,	148,150,
	148,150,	148,150,	148,150,	148,150,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	151,153,	151,153,
	151,153,	151,153,	151,153,	151,153,
	151,153,	151,153,	151,153,	151,153,
	0,0,	149,151,	149,151,	149,151,
	149,151,	149,151,	149,151,	151,153,
	151,153,	151,153,	151,153,	151,153,
	151,153,	152,154,	152,154,	152,154,
	152,154,	152,154,	152,154,	152,154,
	152,154,	152,154,	152,154,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	152,154,	152,154,
	152,154,	152,154,	152,154,	152,154,
	0,0,	0,0,	0,0,	151,153,
	151,153,	151,153,	151,153,	151,153,
	151,153,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	153,155,
	153,155,	153,155,	153,155,	153,155,
	153,155,	153,155,	153,155,	153,155,
	153,155,	0,0,	152,154,	152,154,
	152,154,	152,154,	152,154,	152,154,
	153,155,	153,155,	153,155,	153,155,
	153,155,	153,155,	154,156,	154,156,
	154,156,	154,156,	154,156,	154,156,
	154,156,	154,156,	154,156,	154,156,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	154,156,
	154,156,	154,156,	154,156,	154,156,
	154,156,	0,0,	0,0,	0,0,
	153,155,	153,155,	153,155,	153,155,
	153,155,	153,155,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	154,156,
	154,156,	154,156,	154,156,	154,156,
	154,156,	0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-95,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+4,	0,		yyvstop+8,
yycrank+-69,	0,		yyvstop+11,
yycrank+127,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+17,
yycrank+29,	0,		yyvstop+20,
yycrank+-249,	0,		yyvstop+23,
yycrank+252,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+28,
yycrank+0,	0,		yyvstop+31,
yycrank+0,	0,		yyvstop+34,
yycrank+0,	0,		yyvstop+37,
yycrank+32,	0,		yyvstop+40,
yycrank+22,	0,		yyvstop+43,
yycrank+27,	0,		yyvstop+45,
yycrank+279,	0,		yyvstop+48,
yycrank+322,	0,		yyvstop+51,
yycrank+0,	0,		yyvstop+54,
yycrank+0,	0,		yyvstop+57,
yycrank+11,	0,		yyvstop+60,
yycrank+12,	0,		yyvstop+63,
yycrank+13,	0,		yyvstop+66,
yycrank+13,	0,		yyvstop+69,
yycrank+0,	0,		yyvstop+72,
yycrank+0,	0,		yyvstop+75,
yycrank+0,	0,		yyvstop+78,
yycrank+0,	0,		yyvstop+81,
yycrank+5,	0,		yyvstop+84,
yycrank+0,	0,		yyvstop+87,
yycrank+0,	0,		yyvstop+90,
yycrank+-356,	0,		yyvstop+93,
yycrank+10,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+98,
yycrank+-2,	yysvec+7,	yyvstop+100,
yycrank+0,	yysvec+8,	yyvstop+102,
yycrank+0,	0,		yyvstop+104,
yycrank+52,	0,		0,	
yycrank+-379,	0,		0,	
yycrank+0,	yysvec+12,	0,	
yycrank+407,	0,		0,	
yycrank+178,	yysvec+17,	yyvstop+106,
yycrank+0,	0,		yyvstop+108,
yycrank+0,	0,		yyvstop+110,
yycrank+116,	0,		0,	
yycrank+0,	yysvec+21,	yyvstop+112,
yycrank+14,	0,		yyvstop+114,
yycrank+35,	0,		yyvstop+116,
yycrank+445,	0,		yyvstop+118,
yycrank+0,	0,		yyvstop+120,
yycrank+0,	0,		yyvstop+122,
yycrank+0,	0,		yyvstop+124,
yycrank+0,	0,		yyvstop+126,
yycrank+0,	0,		yyvstop+128,
yycrank+36,	0,		0,	
yycrank+0,	0,		yyvstop+130,
yycrank+0,	yysvec+35,	0,	
yycrank+0,	0,		yyvstop+132,
yycrank+243,	0,		0,	
yycrank+32,	0,		0,	
yycrank+3,	0,		0,	
yycrank+0,	0,		yyvstop+134,
yycrank+-152,	yysvec+42,	0,	
yycrank+62,	0,		yyvstop+136,
yycrank+515,	0,		0,	
yycrank+181,	yysvec+48,	yyvstop+138,
yycrank+0,	0,		yyvstop+140,
yycrank+175,	0,		yyvstop+142,
yycrank+191,	0,		yyvstop+144,
yycrank+0,	0,		yyvstop+146,
yycrank+0,	0,		yyvstop+148,
yycrank+3,	0,		0,	
yycrank+19,	0,		0,	
yycrank+1,	0,		0,	
yycrank+0,	0,		yyvstop+150,
yycrank+0,	0,		yyvstop+152,
yycrank+538,	0,		0,	
yycrank+0,	0,		yyvstop+154,
yycrank+0,	0,		yyvstop+156,
yycrank+0,	0,		yyvstop+158,
yycrank+37,	0,		0,	
yycrank+7,	0,		0,	
yycrank+576,	0,		0,	
yycrank+42,	0,		0,	
yycrank+13,	0,		0,	
yycrank+599,	0,		0,	
yycrank+36,	0,		0,	
yycrank+5,	0,		0,	
yycrank+637,	0,		0,	
yycrank+259,	0,		0,	
yycrank+264,	0,		0,	
yycrank+660,	0,		0,	
yycrank+4,	0,		0,	
yycrank+5,	0,		0,	
yycrank+698,	0,		0,	
yycrank+0,	0,		yyvstop+160,
yycrank+0,	0,		yyvstop+162,
yycrank+721,	0,		0,	
yycrank+759,	0,		0,	
yycrank+782,	0,		0,	
yycrank+820,	0,		0,	
yycrank+843,	0,		0,	
yycrank+881,	0,		0,	
yycrank+904,	0,		0,	
yycrank+68,	0,		0,	
yycrank+70,	0,		0,	
yycrank+942,	0,		0,	
yycrank+965,	0,		0,	
yycrank+1003,	0,		0,	
yycrank+1026,	0,		0,	
yycrank+72,	0,		0,	
yycrank+1064,	0,		0,	
yycrank+1087,	0,		0,	
yycrank+1125,	0,		0,	
yycrank+1148,	0,		0,	
yycrank+74,	0,		0,	
yycrank+74,	0,		0,	
yycrank+1186,	0,		0,	
yycrank+1209,	0,		0,	
yycrank+1247,	0,		0,	
yycrank+1270,	0,		0,	
yycrank+1308,	0,		0,	
yycrank+75,	0,		0,	
yycrank+1331,	0,		0,	
yycrank+1369,	0,		0,	
yycrank+78,	0,		0,	
yycrank+1392,	0,		0,	
yycrank+1430,	0,		0,	
yycrank+113,	0,		0,	
yycrank+1453,	0,		0,	
yycrank+1491,	0,		0,	
yycrank+1514,	0,		0,	
yycrank+1552,	0,		0,	
yycrank+1575,	0,		0,	
yycrank+114,	0,		0,	
yycrank+1613,	0,		0,	
yycrank+1636,	0,		0,	
yycrank+1674,	0,		0,	
yycrank+1697,	0,		0,	
yycrank+1735,	0,		0,	
yycrank+128,	0,		0,	
yycrank+1758,	0,		0,	
yycrank+1796,	0,		0,	
yycrank+1819,	0,		0,	
yycrank+1857,	0,		0,	
yycrank+1880,	0,		0,	
yycrank+139,	0,		0,	
yycrank+1918,	0,		0,	
yycrank+1941,	0,		0,	
yycrank+1979,	0,		0,	
yycrank+2002,	0,		0,	
yycrank+328,	0,		0,	
yycrank+373,	0,		0,	
yycrank+0,	0,		yyvstop+164,
yycrank+0,	0,		yyvstop+166,
0,	0,	0};
struct yywork *yytop = yycrank+2104;
struct yysvf *yybgin = yysvec+1;
unsigned char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,011 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,'$' ,01  ,01  ,047 ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,0134,01  ,01  ,'$' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};

#include <lex_lib.c>
