############################################################################
# $Id: Rules.mk,v 1.3 1996/07/12 18:22:23 mtp Exp $
############################################################################
# @Header@
############################################################################
# $Log: Rules.mk,v $
# Revision 1.3  1996/07/12 18:22:23  mtp
# + Added DEVROOT mechanism to Rules.mk
# + Added 3 new information files
# + Removed the Original README file
#
# Revision 1.2  1996/07/10 14:57:25  mtp
# No change
#
# Revision 1.1.1.1  1996/06/30 00:08:56  mtp
# Resubmission of PD DCE sources
#
# Revision 1.2  1995/12/31 06:03:01  mtp
# + Removed extra PTHREAD_LIB definition.
# + Changed LOCAL definition to reflect current location of CVS working
#   directory.
#
# Revision 1.1.1.1  1995/12/31 05:20:05  mtp
# + Placed under CVS control
#
#########################################################################
# General rules and symbols.
#########################################################################
.SUFFIXES: .o .C .c
SHELL               = /bin/bash
ELF                 = -fPIC
AOUT                = -b i486-linuxaout
STRICT              = -Wall -Wstrict-prototypes -D__USE_POSIX
CC                  = gcc
CPP                 = g++
MV                  = mv
SED                 = sed
INSTALL             = /usr/bin/install
MAKEFILE            = Makefile
LDFLAGS             =
LD                  = ${CC}

PTHREAD_LIBS        = /usr/lib/libpthread-ext.a \
                      /usr/lib/libpthread_dce.a \
                      /usr/lib/libsock_r.a \
                      /usr/lib/libpthread.a

#########################################################################
# Rules and symbols specific to the DCE build environment.
#########################################################################
DCE                 = ${DEVROOT}
LOCAL               = ${DCE}
TOOLS_DIR           = ${LOCAL}/bin
LIBDIR              = ${LOCAL}/lib
SRCDIR              = ${LOCAL}/src
NLS_DIR             = ${LOCAL}/opt/dcelocal/nls/msg/en_US.ISO8859-1
UUID_MSG_CAT        = ${LOCAL}/src/rpc/idl/uuidgen/dceuid.cat
IDL_MSG_CAT         = ${LOCAL}/src/rpc/idl/idl_compiler/idl.cat
RPC_MSG_CAT         = ${LOCAL}/src/rpc/sys_idl/dcerpc.cat
IDLFLAGS            = -cc_cmd "gcc -c -b i486-linuxaout -O2 -D_DCE_COMPAT_"
GDB                 = -ggdb -O0
CFLAGS              = ${AOUT} -D_BSD -D_DCE_COMPAT_

GENCAT              = ${TOOLS_DIR}/gencat
TARGET              = LINUX
LIBDCE              = libdce.a

.c.o:
#	@echo + compiling using ${AOUT} $<
	${CC} -c ${CFLAGS} $<
.C.o:
	@echo + compiling $<
	@${CPP} -c ${CFLAGS} $<
