/*
 *   cddbd - CD Database Protocol Server
 *
 *   strutil.c: various string utilities
 *   $Id: strutil.c,v 1.1 2001/09/08 08:14:50 gonter Exp $
 *
 *   Copyright (C) 2001
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "list.h"
#include "cddbd.h"

int
is_instr(char c, char *str)
{

	if(*str == '\0')
		return 1;

	while(*str != '\0') {
		if(c == *str)
			return 1;
		++str;
	}

	return 0;
}


/* This function removes CR and LF chars at the end
 * of a string by replacing them with NULL chars.
 */
void
strip_crlf(char *buf)
{
	char *p;

	/* Strip out newlines. */
	p = &buf[strlen(buf) - 1];

	while(*p == '\n' || *p == '\r') {
		*p = '\0';

		if(p == buf)
			break;
		p--;
	}
}
