/*
 * Copyright (c) 2002-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: inputs.h 12512 2010-03-08 21:24:12Z jomi.gregory $
 *
 * Header file defining functions to be implemented
 * by all input sources that produce ERF records.
 */

#ifndef INPUTS_H
#define INPUTS_H

/* Endace headers. */
#include "dagapi.h"
#include "dagerf.h"
#include "dagutil.h"
#include "adt/adt_list.h"
/* maximum number of input files allowed */
#define MAXCNT 64

/* maximum packet size in pcap output */
#define MAX_PACKET 65536

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*#define PERFORMANCE_MEASUREMENT_ENABLE 0*/

/*******************************************************
 * ERF file functions
 *******************************************************/

/*ListPtr readlist_p = NULL;*/

typedef struct read_rec{
	dag_record_t *header;
	void *payload;
	off_t file_offset;
} read_rec_t;
/*
 * Get pointer to the ERF header for the next packet
 * in the input stream. Returns null if no further
 * packets are available.
 */
dag_record_t *get_next_erf_header();

read_rec_t* read_next_erf_header(ListPtr readlist_p);

/*
 * Returns a pointer to the payload of the most recent
 * packet. Returns null if there is no current packet.
 */
void * get_erf_payload(void);
/*
 * Set the stream from which input is obtained.
 */
void set_erf_input(char *in);
/*
 * Close the current input stream.
 */
void close_erf_input(void);
/*
 * write the erf record to the output file.
 */
int write_erf_record(void* packet_data, uint32_t size);
/*
 * Set the stream on which output is to be produced.
 */
void set_erf_output(char *out);
/*
 * Close the currently open input (if any).
 */
void close_erf_output(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* INPUTS_H */
