/*
 * Copyright (c) 2006-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagsnap_config.h 4052 2006-04-04 00:20:00Z koryn $
 */

#ifndef DAGSNAP_CONFIG_H
#define DAGSNAP_CONFIG_H

/* Endace headers. */
#include "dag_platform.h"

typedef struct DagsnapConfig_ DagsnapConfig_;
typedef DagsnapConfig_ * DagsnapConfigPtr; /* Opaque type-safe pointer. */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Allocation and disposal. */
DagsnapConfigPtr dagsnap_config_init(void);
DagsnapConfigPtr dagsnap_config_dispose(DagsnapConfigPtr bean);

/* Getters and Setters for properties. */
const char* dagsnap_config_get_device(DagsnapConfigPtr bean);
void dagsnap_config_set_device(DagsnapConfigPtr bean, const char* value);
const char* dagsnap_config_get_outfile_name(DagsnapConfigPtr bean);
void dagsnap_config_set_outfile_name(DagsnapConfigPtr bean, const char* value);
int32_t dagsnap_config_get_dagstream(DagsnapConfigPtr bean);
void dagsnap_config_set_dagstream(DagsnapConfigPtr bean, int32_t value);
uint32_t dagsnap_config_get_data_bytes(DagsnapConfigPtr bean);
void dagsnap_config_set_data_bytes(DagsnapConfigPtr bean, uint32_t value);
uint32_t dagsnap_config_get_run_seconds(DagsnapConfigPtr bean);
void dagsnap_config_set_run_seconds(DagsnapConfigPtr bean, uint32_t value);
uint8_t dagsnap_config_get_verbosity(DagsnapConfigPtr bean);
void dagsnap_config_set_verbosity(DagsnapConfigPtr bean, uint8_t value);
uint8_t dagsnap_config_get_max_performance(DagsnapConfigPtr bean);
void dagsnap_config_set_max_performance(DagsnapConfigPtr bean, uint8_t value);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DAGSNAP_CONFIG_H */
