/*
 * Copyright (c) 2004 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: list.h 401 2004-07-20 00:07:27Z abel $
 */

#ifndef _LISTH
#define _LISTH

#ifndef NULL
#define NULL (void*)0
#endif

typedef struct _list_elem_t {
	struct _list_elem_t * next;
	struct _list_elem_t * prev;
	int type;
	void * elem;
} list_elem_t;

typedef struct {
	list_elem_t * first;
	list_elem_t * last;
	list_elem_t * ptr;
	int size;
} list_t;


list_t * listNew ();
void listAdd (list_t *list, void *elem, int type);
void listAddFirst (list_t *list, void *elem, int type);
void listRemoveFirst (list_t *list);
void listRemoveLast (list_t *list);
void * listGetFirst (list_t *list);
int listGetFirstType (list_t *list);
void * listGetLast (list_t *list);
int listGetLastType (list_t *list);
int listGetSize (list_t *list);
void listPtrBegin (list_t *list);
void listPtrNext (list_t *list);
void * listGetPtrElem (list_t *list);
int listGetPtrType (list_t *list);
int listHasMoreElements (list_t *list);
void listRemovePtr (list_t *list);


#endif

