/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagcrc.c 9029 2008-04-08 00:20:31Z vladimir $
 */


static unsigned long crc_32_tab[] = {     /* CRC polynomial 0xedb88320 */
  0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419, 0x706af48f,
  0xe963a535, 0x9e6495a3, 0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988,
  0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91, 0x1db71064, 0x6ab020f2,
  0xf3b97148, 0x84be41de, 0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7,
  0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9,
  0xfa0f3d63, 0x8d080df5, 0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172,
  0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b, 0x35b5a8fa, 0x42b2986c,
  0xdbbbc9d6, 0xacbcf940, 0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59,
  0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423,
  0xcfba9599, 0xb8bda50f, 0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924,
  0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d, 0x76dc4190, 0x01db7106,
  0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433,
  0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818, 0x7f6a0dbb, 0x086d3d2d,
  0x91646c97, 0xe6635c01, 0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e,
  0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457, 0x65b0d9c6, 0x12b7e950,
  0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65,
  0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2, 0x4adfa541, 0x3dd895d7,
  0xa4d1c46d, 0xd3d6f4fb, 0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0,
  0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9, 0x5005713c, 0x270241aa,
  0xbe0b1010, 0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
  0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17, 0x2eb40d81,
  0xb7bd5c3b, 0xc0ba6cad, 0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a,
  0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683, 0xe3630b12, 0x94643b84,
  0x0d6d6a3e, 0x7a6a5aa8, 0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1,
  0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb,
  0x196c3671, 0x6e6b06e7, 0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc,
  0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5, 0xd6d6a3e8, 0xa1d1937e,
  0x38d8c2c4, 0x4fdff252, 0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b,
  0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55,
  0x316e8eef, 0x4669be79, 0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236,
  0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f, 0xc5ba3bbe, 0xb2bd0b28,
  0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d,
  0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a, 0x9c0906a9, 0xeb0e363f,
  0x72076785, 0x05005713, 0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38,
  0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21, 0x86d3d2d4, 0xf1d4e242,
  0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777,
  0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c, 0x8f659eff, 0xf862ae69,
  0x616bffd3, 0x166ccf45, 0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2,
  0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db, 0xaed16a4a, 0xd9d65adc,
  0x40df0b66, 0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
  0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605, 0xcdd70693,
  0x54de5729, 0x23d967bf, 0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94,
  0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d
};

/* 0x8408 is 0x1021 inverted bit by bit	*/
unsigned short int ccitt_tab[] = { /* CRC polynomial 0x8408 */
0x0000, 0x1189, 0x2312, 0x329B, 0x4624, 0x57AD, 0x6536, 0x74BF,
0x8C48, 0x9DC1, 0xAF5A, 0xBED3, 0xCA6C, 0xDBE5, 0xE97E, 0xF8F7,
0x1081, 0x0108, 0x3393, 0x221A, 0x56A5, 0x472C, 0x75B7, 0x643E,
0x9CC9, 0x8D40, 0xBFDB, 0xAE52, 0xDAED, 0xCB64, 0xF9FF, 0xE876,
0x2102, 0x308B, 0x0210, 0x1399, 0x6726, 0x76AF, 0x4434, 0x55BD,
0xAD4A, 0xBCC3, 0x8E58, 0x9FD1, 0xEB6E, 0xFAE7, 0xC87C, 0xD9F5,
0x3183, 0x200A, 0x1291, 0x0318, 0x77A7, 0x662E, 0x54B5, 0x453C,
0xBDCB, 0xAC42, 0x9ED9, 0x8F50, 0xFBEF, 0xEA66, 0xD8FD, 0xC974,
0x4204, 0x538D, 0x6116, 0x709F, 0x0420, 0x15A9, 0x2732, 0x36BB,
0xCE4C, 0xDFC5, 0xED5E, 0xFCD7, 0x8868, 0x99E1, 0xAB7A, 0xBAF3,
0x5285, 0x430C, 0x7197, 0x601E, 0x14A1, 0x0528, 0x37B3, 0x263A,
0xDECD, 0xCF44, 0xFDDF, 0xEC56, 0x98E9, 0x8960, 0xBBFB, 0xAA72,
0x6306, 0x728F, 0x4014, 0x519D, 0x2522, 0x34AB, 0x0630, 0x17B9,
0xEF4E, 0xFEC7, 0xCC5C, 0xDDD5, 0xA96A, 0xB8E3, 0x8A78, 0x9BF1,
0x7387, 0x620E, 0x5095, 0x411C, 0x35A3, 0x242A, 0x16B1, 0x0738,
0xFFCF, 0xEE46, 0xDCDD, 0xCD54, 0xB9EB, 0xA862, 0x9AF9, 0x8B70,
0x8408, 0x9581, 0xA71A, 0xB693, 0xC22C, 0xD3A5, 0xE13E, 0xF0B7,
0x0840, 0x19C9, 0x2B52, 0x3ADB, 0x4E64, 0x5FED, 0x6D76, 0x7CFF,
0x9489, 0x8500, 0xB79B, 0xA612, 0xD2AD, 0xC324, 0xF1BF, 0xE036,
0x18C1, 0x0948, 0x3BD3, 0x2A5A, 0x5EE5, 0x4F6C, 0x7DF7, 0x6C7E,
0xA50A, 0xB483, 0x8618, 0x9791, 0xE32E, 0xF2A7, 0xC03C, 0xD1B5,
0x2942, 0x38CB, 0x0A50, 0x1BD9, 0x6F66, 0x7EEF, 0x4C74, 0x5DFD,
0xB58B, 0xA402, 0x9699, 0x8710, 0xF3AF, 0xE226, 0xD0BD, 0xC134,
0x39C3, 0x284A, 0x1AD1, 0x0B58, 0x7FE7, 0x6E6E, 0x5CF5, 0x4D7C,
0xC60C, 0xD785, 0xE51E, 0xF497, 0x8028, 0x91A1, 0xA33A, 0xB2B3,
0x4A44, 0x5BCD, 0x6956, 0x78DF, 0x0C60, 0x1DE9, 0x2F72, 0x3EFB,
0xD68D, 0xC704, 0xF59F, 0xE416, 0x90A9, 0x8120, 0xB3BB, 0xA232,
0x5AC5, 0x4B4C, 0x79D7, 0x685E, 0x1CE1, 0x0D68, 0x3FF3, 0x2E7A,
0xE70E, 0xF687, 0xC41C, 0xD595, 0xA12A, 0xB0A3, 0x8238, 0x93B1,
0x6B46, 0x7ACF, 0x4854, 0x59DD, 0x2D62, 0x3CEB, 0x0E70, 0x1FF9,
0xF78F, 0xE606, 0xD49D, 0xC514, 0xB1AB, 0xA022, 0x92B9, 0x8330,
0x7BC7, 0x6A4E, 0x58D5, 0x495C, 0x3DE3, 0x2C6A, 0x1EF1, 0x0F78,
};

static unsigned short infiniband_vcrc_table[256] = {
    0x0000, 0x1ba1, 0x3742, 0x2ce3, 0x6e84, 0x7525, 0x59c6, 0x4267,
    0xdd08, 0xc6a9, 0xea4a, 0xf1eb, 0xb38c, 0xa82d, 0x84ce, 0x9f6f,
    0x1a01, 0x01a0, 0x2d43, 0x36e2, 0x7485, 0x6f24, 0x43c7, 0x5866,
    0xc709, 0xdca8, 0xf04b, 0xebea, 0xa98d, 0xb22c, 0x9ecf, 0x856e,
    0x3402, 0x2fa3, 0x0340, 0x18e1, 0x5a86, 0x4127, 0x6dc4, 0x7665,
    0xe90a, 0xf2ab, 0xde48, 0xc5e9, 0x878e, 0x9c2f, 0xb0cc, 0xab6d,
    0x2e03, 0x35a2, 0x1941, 0x02e0, 0x4087, 0x5b26, 0x77c5, 0x6c64,
    0xf30b, 0xe8aa, 0xc449, 0xdfe8, 0x9d8f, 0x862e, 0xaacd, 0xb16c,
    0x6804, 0x73a5, 0x5f46, 0x44e7, 0x0680, 0x1d21, 0x31c2, 0x2a63,
    0xb50c, 0xaead, 0x824e, 0x99ef, 0xdb88, 0xc029, 0xecca, 0xf76b,
    0x7205, 0x69a4, 0x4547, 0x5ee6, 0x1c81, 0x0720, 0x2bc3, 0x3062,
    0xaf0d, 0xb4ac, 0x984f, 0x83ee, 0xc189, 0xda28, 0xf6cb, 0xed6a,
    0x5c06, 0x47a7, 0x6b44, 0x70e5, 0x3282, 0x2923, 0x05c0, 0x1e61,
    0x810e, 0x9aaf, 0xb64c, 0xaded, 0xef8a, 0xf42b, 0xd8c8, 0xc369,
    0x4607, 0x5da6, 0x7145, 0x6ae4, 0x2883, 0x3322, 0x1fc1, 0x0460,
    0x9b0f, 0x80ae, 0xac4d, 0xb7ec, 0xf58b, 0xee2a, 0xc2c9, 0xd968,
    0xd008, 0xcba9, 0xe74a, 0xfceb, 0xbe8c, 0xa52d, 0x89ce, 0x926f,
    0x0d00, 0x16a1, 0x3a42, 0x21e3, 0x6384, 0x7825, 0x54c6, 0x4f67,
    0xca09, 0xd1a8, 0xfd4b, 0xe6ea, 0xa48d, 0xbf2c, 0x93cf, 0x886e,
    0x1701, 0x0ca0, 0x2043, 0x3be2, 0x7985, 0x6224, 0x4ec7, 0x5566,
    0xe40a, 0xffab, 0xd348, 0xc8e9, 0x8a8e, 0x912f, 0xbdcc, 0xa66d,
    0x3902, 0x22a3, 0x0e40, 0x15e1, 0x5786, 0x4c27, 0x60c4, 0x7b65,
    0xfe0b, 0xe5aa, 0xc949, 0xd2e8, 0x908f, 0x8b2e, 0xa7cd, 0xbc6c,
    0x2303, 0x38a2, 0x1441, 0x0fe0, 0x4d87, 0x5626, 0x7ac5, 0x6164,
    0xb80c, 0xa3ad, 0x8f4e, 0x94ef, 0xd688, 0xcd29, 0xe1ca, 0xfa6b,
    0x6504, 0x7ea5, 0x5246, 0x49e7, 0x0b80, 0x1021, 0x3cc2, 0x2763,
    0xa20d, 0xb9ac, 0x954f, 0x8eee, 0xcc89, 0xd728, 0xfbcb, 0xe06a,
    0x7f05, 0x64a4, 0x4847, 0x53e6, 0x1181, 0x0a20, 0x26c3, 0x3d62,
    0x8c0e, 0x97af, 0xbb4c, 0xa0ed, 0xe28a, 0xf92b, 0xd5c8, 0xce69,
    0x5106, 0x4aa7, 0x6644, 0x7de5, 0x3f82, 0x2423, 0x08c0, 0x1361,
    0x960f, 0x8dae, 0xa14d, 0xbaec, 0xf88b, 0xe32a, 0xcfc9, 0xd468,
    0x4b07, 0x50a6, 0x7c45, 0x67e4, 0x2583, 0x3e22, 0x12c1, 0x0960,
};
#define UPDC32(octet,crc) (crc_32_tab[(crc ^ octet) & 0x0ff] ^ ((crc) >> 8))
#define UPDCIT(ch, crc)   (ccitt_tab[((crc) ^ (ch)) & 0x0ff] ^ ((crc) >> 8))




/* "123456789" = CBF43926 */
/****************************************************************************/
unsigned long crc32_calc (unsigned char *buf, int len) {
  int i;
  unsigned long crc = 0x0ffffffff;

  for (i = 0; i < len; i++) {
    crc = UPDC32(buf[i],crc);
  }

  // this should only be applied at the end of CRC calculation, so
  // you can't use this function more than once to concatenate two
  // crc calculations
  crc = crc ^ 0x0ffffffff;

  return (crc);
}

/****************************************************************************/
unsigned long crc32_append (unsigned long crc, unsigned char *buf, int len) {
  int i;

  for (i = 0; i < len; i++) {
    crc = UPDC32(buf[i],crc);
  }

  // Must reflect crc to be correct once all the data is processed
  // crc = crc ^ 0xffffffff;

  return (crc);
}

/****************************************************************************/
unsigned long crc32_reflect (unsigned long crc) {
	crc = crc ^ 0x0ffffffff;
	return crc;
}

/****************************************************************************/
unsigned long crc32_init () {
	return 0x0ffffffff;
}


/****************************************************************************/


/****************************************************************************/
// Init CRC to 0x0FFFF
unsigned short int crc16_update (unsigned short int crc, unsigned char *data, int len) {
	int i;

	for (i=0; i<len; i++) {
		crc = UPDCIT(data[i],crc);

	}
	crc ^= 0xffff;
	return crc;
}

/****************************************************************************/
unsigned short int crc16_init () {
	return 0x0ffff;
}


unsigned short int  daggen_infiniband_vcrc16(unsigned short int  crc, const unsigned char* buf, int len)
{
    unsigned short int c = crc ^ 0xffff;

    while (len--)
    {

        int t = (c   ^ (*buf)) & 0xff;
        buf++;
        c = infiniband_vcrc_table[t] ^ (c >> 8);
    }

    return c ^ 0xffff;
}

/* Function:     daggen_infiniband_icrc
 * Description:  calculate ICRC(32 bits ) for the infiniband packet
 * Inputs:       	crc:- Initial value
*			buf1 - pointer to masked buffer (header)
*			len1 - length of the buf1
*			buf2 - pointer rest of the packet
*			len2 - length of the buf2
* Outputs:      calculated crc32 of the given packet 
 */
unsigned int 
daggen_infiniband_icrc(unsigned int crc, const unsigned char* buf1, int len1, const unsigned char* buf2, int len2)
{
	unsigned int c = crc ^ 0xffffffffL;
	int i = 0;
	const unsigned char *buf = buf1;
	while (i < (len1+ len2) )
	{
		int t = (c ^ (*buf)) & 0xff;
		c = crc_32_tab[t] ^ (c >> 8);
		i++;
		buf++;
		if ( i == len1) buf = buf2;
	}
	
	return c ^ 0xffffffffL;
}


