/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: cmdline.c 4890 2006-07-20 04:28:28Z patricia $
 */

#include <stdlib.h>
#include <limits.h>
#if !defined(_WIN32)
#include <unistd.h>
#endif /* not _WIN32 */

#include <stdio.h>
#include <string.h>
#include "daggen.h"
#include "cmdline.h"

#if defined(_WIN32)
#include "getopt.h"
extern char *optarg;
extern int optind;
#endif /* _WIN32 */

void cmdlineParse(int argc, char **argv, options_t * options) {
	int  ch;

	while ((ch = getopt(argc, argv, "e:f:hi:o:l:pqr:s:S:x:v")) != -1)
		switch (ch) {
		case 'f':
			// Config file
			strcpy (options->config_file, optarg);
			break;

		case 'e': break;
		case 'i': break;
		case 'l': break;
		case 'o': break;
		case 'r': break;
		case 's': break;
		case 'S': break;
		case 'v': break;
		case 'p': break;
		case 'x': break;

		case '?':
		case 'h':
		default:
			cmdlineUsage();
		}

	argc -= optind;
	argv += optind;
}

void cmdlineParse2 (int argc, char **argv, options_t * options) {
	int  ch;

	optind = 1;

#if defined(__FreeBSD__)
	optreset = 1;
#endif

	while ((ch = getopt(argc, argv, "e:f:hi:o:l:pr:s:S:x:v")) != -1)
		switch (ch) {
		case 'f': break;
		case 'e':
			options->fcs_size = (int) strtol (optarg, (char **)NULL, 10);
			if (	options->fcs_size != -1 &&
				options->fcs_size != 0 &&
				options->fcs_size != 2 &&
				options->fcs_size != 4 &&
				options->fcs_size != 6) {
				printf ("Wrong FCS size. Should be 0, 2 or 4 (bytes), 6 for a wrong CRC.\n");
				exit(0);
			}
			break;

		case 'i':
			// Interface
			options->interface_num = (int) strtol (optarg, (char **)NULL, 10);
			break;
		case 'l':
			// Rx Error
			options->rx_error = (int) strtol (optarg, (char **)NULL, 10);
			if (	options->fcs_size != -1 &&
				options->fcs_size != 0 &&
				options->fcs_size != 1) {
				printf ("Wrong RX ERROR. Should be 0(OFF) or 1(OFF).\n");
				exit(0);
			}
			break;
		case 'o':
			// Output file
			strcpy (options->output_file, optarg);
			break;

		case 'r':
			// Random seed
			options->random_seed = (unsigned long) strtol(optarg, (char **)NULL, 10);
			break;

		case 's':
			// Snaplength - Round DOWN (64-bit alignment)
			options->snaplength = (unsigned int) strtol(optarg, (char **)NULL, 10);
			options->snaplength_round = SNAP_ROUND_DOWN;
			break;

		case 'S':
			// Snaplength - Round UP (64-bit aligment)
			options->snaplength = (unsigned int) strtol(optarg, (char **)NULL, 10);
			options->snaplength_round = SNAP_ROUND_UP;
			break;

		case 'v':
			// Verbose
			options->verbose = 1;
			break;

		case 'p':
			// PCAP format
			options->output_format = OUTPUT_FORMAT_PCAP;
			break;

		case 'x':
			// Traffic group
			strcpy (options->traffic_group, optarg);
			break;

		case '?':
		case 'h':
		default:
			cmdlineUsage();
		}

	argc -= optind;
	argv += optind;
}

void cmdlineUsage (void) {
	printf ("daggen usage:\n");
	printf ("\tdaggen <options>\n\n");
	printf ("options can be:\n");
	printf ("\tConfig file:             -f <config_file>\tdefault: config.dag\n");
	printf ("\tOutput file:             -o <output_file>\tdefault: output.dag\n");
	printf ("\tRandom seed:             -r <random_seed>\tdefault: time dependant\n");
	printf ("\tInterface:               -i <interface>\tdefault: 0\n");
	printf ("\tRx Error:                -l <rx_error>\tdefault: 0\n");
	printf ("\tVerbose mode:            -v\t\tdefault: quiet\n");
	printf ("\tTraffic group:           -x <group_id>\tdefault: first declared\n");
	printf ("\tFCS bytes:               -e <fcs_bytes>\tdefault: 0\n");
	printf ("\tPcap format:             -p\t\tdefault: ERF format\n");
	printf ("\tSnaplength (round down): -s <bytes>\tdefault: max packet size\n");
	printf ("\tSnaplength (round up):   -S <bytes>\tdefault: max packet size\n");
	printf ("\n");

	exit(EXIT_SUCCESS);
}
