/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: inline_filter.h 12688 2010-03-31 21:27:06Z sfd $
 */

#ifndef INLINE_FILTER_H
#define INLINE_FILTER_H


#if defined(__FreeBSD__) || defined(__linux__) || (defined(__SVR4) && defined(__sun)) || (defined(__APPLE__) && defined(__ppc__))


#include <inttypes.h>

#elif defined(_WIN32)

#include <wintypedefs.h>

#else
#error Compiling on an unsupported platform - please contact <support@endace.com> for assistance.
#endif /* Platform-specific code. */


#define MAX_HEADERS 8


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define TX_ACCUM_BYTES_MAX  (64*1024)

void set_device_name(const char* name, const int stream);
void set_tx_device_name(const char* name, const int stream);
void set_filter_expression(const char* filter);

void set_file_name(const char* filename);
void set_file_filter_expr(const char* file_filter);
void set_disk_cache_size(unsigned long size_in_mb);
void set_dag_fwd_verbosity();
void set_copy_transmit();

int init_filter(void);
void run_inline_filter(unsigned int runtime_seconds, unsigned int);
void set_low_latency(unsigned int rx);
void set_interface_swap(void);
void set_tx_accum_bytes(unsigned long size_KB);



#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* INLINE_FILTER_H */
