/*
 * Copyright (c) 2006-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagflood_model.h 4074 2006-04-05 02:02:23Z koryn $
 */

#ifndef DAGFLOOD_MODEL_H
#define DAGFLOOD_MODEL_H

/* dagflood headers. */
#include "dagflood_config.h"

/* Endace headers. */
#include "dag_platform.h"


typedef struct Dagflood_ Dagflood_;
typedef Dagflood_ * DagfloodPtr; /* Opaque type-safe pointer. */


/* Information passed to clients for display purposes. */
typedef struct dagflood_info_t
{
	uint64_t bytes_written;
	uint32_t running_seconds;
	uint32_t running_nanoseconds;
	int state;

} dagflood_info_t, * DagfloodInfoPtr;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/**
Create a dagflood object.
@param config The configuration options to apply to the transmit session.  The config object is owned by the dagflood object after this call, and will be disposed in the call to dagflood_dispose.
@return A reference to a new dagflood object.
*/
DagfloodPtr dagflood_create(DagfloodConfigPtr config);

/**
Dispose of a dagflood object.
@param flooder A reference to a dagflood object.
*/
void dagflood_dispose(DagfloodPtr flooder);

/**
Retrieve the status of a dagflood transmit session.
@param flooder A reference to a dagflood object.
@param info A pointer to a dagflood_info_t struct.  On return the fields in this object will have been updated with the state of the transmit session at the time the routine was called.
*/
void dagflood_get_status(DagfloodPtr flooder, DagfloodInfoPtr info);

/**
Start the transmit session.
@param flooder A reference to a dagflood object.
@return 1 on success, 0 otherwise.
*/
int dagflood_transmit(DagfloodPtr flooder);

/**
Stop a transmit session.
@param flooder A reference to a dagflood object.
*/
void dagflood_stop(DagfloodPtr flooder);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DAGFLOOD_MODEL_H */
