/*
 * Copyright (c) 2002-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: utils.h 12513 2010-03-08 22:41:59Z jomi.gregory $
 *
 * Helper functions.
 */

#ifndef UTILS_H
#define UTILS_H

/* dagconvert headers. */
#include "inputs.h"

/* Endace headers. */
#include "dagapi.h"
#include "dagutil.h"
#include "dag_platform.h"

/*
 * Default snaplength
 */
#define DEFAULT_SNAPLEN 2040

/*
 * ATM snaplength
 */
#define ATM_SNAPLEN 48


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/*
 * Swap byte ordering of uint64_t on a big endian
 * machine.
 */
uint64_t swapll(uint64_t ull);

/*
 * This routine implements a POSIX compliant way to get the seconds
 * offset from UTC. Unfortunately, struct tm's do not need to implement
 * some of the older fields any more, such as tm_gmtoff.
 */
int gmtoff(void);

INLINE int get_atm_wire_length(dag_record_t * header);
INLINE int get_atm_snap_length(dag_record_t * header);

INLINE int get_erf_wire_length(dag_record_t * header);
INLINE int get_ethernet_snap_length(dag_record_t * header);
INLINE int get_hdlc_snap_length(dag_record_t * header);
INLINE int get_aal5_snap_length(dag_record_t * header);
INLINE int get_raw_snap_length(dag_record_t * header);
INLINE int get_ipv4_snap_length(dag_record_t * header);

void get_dlt(dag_record_t * header, int * linktype, int * snapshot);

/*this function is used to change the extn of a file. Can use temp extn to write and once complete use standrd extn*/
int change_output_file_extn(char *file_name, char *old_extn, char* new_extn);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* UTILS_H */
