/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 */

#ifndef STATISTICS_PRINTING_H
#define STATISTICS_PRINTING_H

#include "../../include/dag_config.h"

/* struct to store the attribute code and the its verbosity level 
 * To be used in attribute_is_printable()      */
typedef struct attribute_verbosity_mapping_s
{
    dag_attribute_code_t attribute_code;
    int attribute_verbosity;
} attribute_verbosity_mapping_t;


void print_statistics(dag_card_ref_t card_ref, int port, int vc_index);
void print_statistics_header(dag_card_ref_t card_ref);
void dag71s_print_statistics(dag_card_ref_t card, int port, int vc_index);
void dag71s_print_statistics_header();
void dag50s_print_statistics(dag_card_ref_t card, int port);
void dag50s_print_statistics_header();
void dag52sxa_print_statistics(dag_card_ref_t card, int port);
void dag52sxa_print_statistics_header();
void dag45ge_print_statistics(dag_card_ref_t card, int port);
void dag45ge_print_statistics_header();
void dag62se_print_statistics(dag_card_ref_t card, int port);
void dag62se_print_statistics_header();
void dag70ge_print_statistics(dag_card_ref_t card, int port);
void dag70ge_print_statistics_header();
void dag37d_print_statistics(dag_card_ref_t card, int port);
void dag37d_print_statistics_header();
#if 0
void dag82x_print_statistics(dag_card_ref_t card, int port);
void dag82x_print_statistics_header();
#endif

#endif

