/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 */

#ifndef EXTENDED_STATISTICS_H 
#define EXTENDED_STATISTICS_H

#include "../../include/dag_config.h"

typedef enum
{
    EXTENDED_CURRENT = 1,
    EXTENDED_HI = 2,
    EXTENDED_LO = 4
}ext_stat_t;

void print_tx_statistics(dag_card_ref_t card_ref, int port);
void print_tx_statistics_header(dag_card_ref_t card);
void print_extended_statistics(dag_card_ref_t card_ref, int port, ext_stat_t ext_stat_type, int vc_index);
void print_extended_statistics_header(dag_card_ref_t card_ref, ext_stat_t ext_stat_type);
void dag71s_print_extended_statistics(dag_card_ref_t card, int port, int vc_index);
void dag71s_print_extended_statistics_header();
void dag50s_print_extended_statistics(dag_card_ref_t card, int port);
void dag50s_print_extended_statistics_header();
void dag62se_print_extended_statistics(dag_card_ref_t card, int port);
void dag62se_print_extended_statistics_header(dag_card_ref_t card);
void dag45ge_print_extended_statistics(dag_card_ref_t card, int port, ext_stat_t ext_stat_type);
void dag45ge_print_extended_statistics_header(ext_stat_t ext_stat_type);
void dag45ge_print_current_extended_statistics_for_component(dag_card_ref_t card_ref, dag_component_t minimacstat_component);
void dag45ge_print_hi_extended_statistics_for_component(dag_card_ref_t card_ref, dag_component_t minimacstat_component);
void dag45ge_print_lo_extended_statistics_for_component(dag_card_ref_t card_ref, dag_component_t minimacstat_component);
void dag45ge_print_current_extended_statistics_header(void);
void dag45ge_print_hi_extended_statistics_header(void);
void dag45ge_print_lo_extended_statistics_header(void);
#if 0
void dag82x_print_extended_statistics(dag_card_ref_t card, int port);
void dag82x_print_extended_statistics_header(void);
#endif
void dag45ge_print_tx_statistics(dag_card_ref_t card_ref, int port);
void dag45ge_print_tx_statistics_header(void);
void dag52sxa_print_extended_statistics(dag_card_ref_t card, int port);
void dag52sxa_print_extended_statistics_header();


#endif

