/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 */

#ifndef COUNTERS_PRINTING_H
#define COUNTERS_PRINTING_H

#include "dag_config.h"

void print_counters(dag_card_ref_t card_ref, int port);
void print_univ_counters(dag_card_ref_t card_ref);
void print_counters_header(dag_card_ref_t card_ref);
void xgmii_print_statistics_counters(dag_card_ref_t card, dag_component_t xgmii_stats);
void dag37d_print_counters(dag_card_ref_t card_ref, int port);
void dag37d_print_counters_header();
void dag45ge_print_counters(dag_card_ref_t card, int port);
void dag45ge_print_counters_header();
void dag82x_print_counters_header();
void dag50s_print_counters_header();
void dag50s_print_counters();
void dagx_print_counters_header(dag_card_ref_t card);
void dagx_print_counters(dag_card_ref_t card, int port);
void dagx_print_port_counters(dag_card_ref_t card, dag_component_t port);
void dagx_print_ucsi_counters(dag_counter_value_t *counters,uint32_t count, int port);
void dagx_print_ucsi_counters_header(dag_card_ref_t card);


#endif

